<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Exchange StructType
 * @subpackage Structs
 */
class Exchange extends AbstractStructBase
{
    /**
     * The changedFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $changedFlag;
    /**
     * The clientIdentification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $clientIdentification;
    /**
     * The deliveryBreak
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $deliveryBreak;
    /**
     * The denyReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $denyReason;
    /**
     * The historicalStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $historicalStartDate;
    /**
     * The historicalStopDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $historicalStopDate;
    /**
     * The keepAlive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $keepAlive;
    /**
     * The requestType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $requestType;
    /**
     * The response
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $response;
    /**
     * The subscriptionReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $subscriptionReference;
    /**
     * The supplierIdentification
     * @var \StructType\InternationalIdentifier
     */
    public $supplierIdentification;
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Target
     */
    public $target;
    /**
     * The subscription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Subscription
     */
    public $subscription;
    /**
     * The filterReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FilterReference[]
     */
    public $filterReference;
    /**
     * The catalogueReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CatalogueReference[]
     */
    public $catalogueReference;
    /**
     * The exchangeExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $exchangeExtension;
    /**
     * Constructor method for Exchange
     * @uses Exchange::setChangedFlag()
     * @uses Exchange::setClientIdentification()
     * @uses Exchange::setDeliveryBreak()
     * @uses Exchange::setDenyReason()
     * @uses Exchange::setHistoricalStartDate()
     * @uses Exchange::setHistoricalStopDate()
     * @uses Exchange::setKeepAlive()
     * @uses Exchange::setRequestType()
     * @uses Exchange::setResponse()
     * @uses Exchange::setSubscriptionReference()
     * @uses Exchange::setSupplierIdentification()
     * @uses Exchange::setTarget()
     * @uses Exchange::setSubscription()
     * @uses Exchange::setFilterReference()
     * @uses Exchange::setCatalogueReference()
     * @uses Exchange::setExchangeExtension()
     * @param string $changedFlag
     * @param string $clientIdentification
     * @param bool $deliveryBreak
     * @param string $denyReason
     * @param string $historicalStartDate
     * @param string $historicalStopDate
     * @param bool $keepAlive
     * @param string $requestType
     * @param string $response
     * @param string $subscriptionReference
     * @param \StructType\InternationalIdentifier $supplierIdentification
     * @param \StructType\Target $target
     * @param \StructType\Subscription $subscription
     * @param \StructType\FilterReference[] $filterReference
     * @param \StructType\CatalogueReference[] $catalogueReference
     * @param \StructType\ExtensionType $exchangeExtension
     */
    public function __construct($changedFlag = null, $clientIdentification = null, $deliveryBreak = null, $denyReason = null, $historicalStartDate = null, $historicalStopDate = null, $keepAlive = null, $requestType = null, $response = null, $subscriptionReference = null, \StructType\InternationalIdentifier $supplierIdentification = null, \StructType\Target $target = null, \StructType\Subscription $subscription = null, array $filterReference = array(), array $catalogueReference = array(), \StructType\ExtensionType $exchangeExtension = null)
    {
        $this
            ->setChangedFlag($changedFlag)
            ->setClientIdentification($clientIdentification)
            ->setDeliveryBreak($deliveryBreak)
            ->setDenyReason($denyReason)
            ->setHistoricalStartDate($historicalStartDate)
            ->setHistoricalStopDate($historicalStopDate)
            ->setKeepAlive($keepAlive)
            ->setRequestType($requestType)
            ->setResponse($response)
            ->setSubscriptionReference($subscriptionReference)
            ->setSupplierIdentification($supplierIdentification)
            ->setTarget($target)
            ->setSubscription($subscription)
            ->setFilterReference($filterReference)
            ->setCatalogueReference($catalogueReference)
            ->setExchangeExtension($exchangeExtension);
    }
    /**
     * Get changedFlag value
     * @return string|null
     */
    public function getChangedFlag()
    {
        return $this->changedFlag;
    }
    /**
     * Set changedFlag value
     * @uses \EnumType\ChangedFlagEnum::valueIsValid()
     * @uses \EnumType\ChangedFlagEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $changedFlag
     * @return \StructType\Exchange
     */
    public function setChangedFlag($changedFlag = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ChangedFlagEnum::valueIsValid($changedFlag)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $changedFlag, implode(', ', \EnumType\ChangedFlagEnum::getValidValues())), __LINE__);
        }
        $this->changedFlag = $changedFlag;
        return $this;
    }
    /**
     * Get clientIdentification value
     * @return string|null
     */
    public function getClientIdentification()
    {
        return $this->clientIdentification;
    }
    /**
     * Set clientIdentification value
     * @param string $clientIdentification
     * @return \StructType\Exchange
     */
    public function setClientIdentification($clientIdentification = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clientIdentification) && strlen($clientIdentification) > 1024) || (is_array($clientIdentification) && count($clientIdentification) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($clientIdentification) ? strlen($clientIdentification) : count($clientIdentification)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clientIdentification) && !is_string($clientIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientIdentification)), __LINE__);
        }
        $this->clientIdentification = $clientIdentification;
        return $this;
    }
    /**
     * Get deliveryBreak value
     * @return bool|null
     */
    public function getDeliveryBreak()
    {
        return $this->deliveryBreak;
    }
    /**
     * Set deliveryBreak value
     * @param bool $deliveryBreak
     * @return \StructType\Exchange
     */
    public function setDeliveryBreak($deliveryBreak = null)
    {
        // validation for constraint: boolean
        if (!is_null($deliveryBreak) && !is_bool($deliveryBreak)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deliveryBreak)), __LINE__);
        }
        $this->deliveryBreak = $deliveryBreak;
        return $this;
    }
    /**
     * Get denyReason value
     * @return string|null
     */
    public function getDenyReason()
    {
        return $this->denyReason;
    }
    /**
     * Set denyReason value
     * @uses \EnumType\DenyReasonEnum::valueIsValid()
     * @uses \EnumType\DenyReasonEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $denyReason
     * @return \StructType\Exchange
     */
    public function setDenyReason($denyReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DenyReasonEnum::valueIsValid($denyReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $denyReason, implode(', ', \EnumType\DenyReasonEnum::getValidValues())), __LINE__);
        }
        $this->denyReason = $denyReason;
        return $this;
    }
    /**
     * Get historicalStartDate value
     * @return string|null
     */
    public function getHistoricalStartDate()
    {
        return $this->historicalStartDate;
    }
    /**
     * Set historicalStartDate value
     * @param string $historicalStartDate
     * @return \StructType\Exchange
     */
    public function setHistoricalStartDate($historicalStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($historicalStartDate) && !is_string($historicalStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($historicalStartDate)), __LINE__);
        }
        $this->historicalStartDate = $historicalStartDate;
        return $this;
    }
    /**
     * Get historicalStopDate value
     * @return string|null
     */
    public function getHistoricalStopDate()
    {
        return $this->historicalStopDate;
    }
    /**
     * Set historicalStopDate value
     * @param string $historicalStopDate
     * @return \StructType\Exchange
     */
    public function setHistoricalStopDate($historicalStopDate = null)
    {
        // validation for constraint: string
        if (!is_null($historicalStopDate) && !is_string($historicalStopDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($historicalStopDate)), __LINE__);
        }
        $this->historicalStopDate = $historicalStopDate;
        return $this;
    }
    /**
     * Get keepAlive value
     * @return bool|null
     */
    public function getKeepAlive()
    {
        return $this->keepAlive;
    }
    /**
     * Set keepAlive value
     * @param bool $keepAlive
     * @return \StructType\Exchange
     */
    public function setKeepAlive($keepAlive = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepAlive) && !is_bool($keepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($keepAlive)), __LINE__);
        }
        $this->keepAlive = $keepAlive;
        return $this;
    }
    /**
     * Get requestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->requestType;
    }
    /**
     * Set requestType value
     * @uses \EnumType\RequestTypeEnum::valueIsValid()
     * @uses \EnumType\RequestTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestType
     * @return \StructType\Exchange
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RequestTypeEnum::valueIsValid($requestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestType, implode(', ', \EnumType\RequestTypeEnum::getValidValues())), __LINE__);
        }
        $this->requestType = $requestType;
        return $this;
    }
    /**
     * Get response value
     * @return string|null
     */
    public function getResponse()
    {
        return $this->response;
    }
    /**
     * Set response value
     * @uses \EnumType\ResponseEnum::valueIsValid()
     * @uses \EnumType\ResponseEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $response
     * @return \StructType\Exchange
     */
    public function setResponse($response = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResponseEnum::valueIsValid($response)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $response, implode(', ', \EnumType\ResponseEnum::getValidValues())), __LINE__);
        }
        $this->response = $response;
        return $this;
    }
    /**
     * Get subscriptionReference value
     * @return string|null
     */
    public function getSubscriptionReference()
    {
        return $this->subscriptionReference;
    }
    /**
     * Set subscriptionReference value
     * @param string $subscriptionReference
     * @return \StructType\Exchange
     */
    public function setSubscriptionReference($subscriptionReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($subscriptionReference) && strlen($subscriptionReference) > 1024) || (is_array($subscriptionReference) && count($subscriptionReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($subscriptionReference) ? strlen($subscriptionReference) : count($subscriptionReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($subscriptionReference) && !is_string($subscriptionReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriptionReference)), __LINE__);
        }
        $this->subscriptionReference = $subscriptionReference;
        return $this;
    }
    /**
     * Get supplierIdentification value
     * @return \StructType\InternationalIdentifier|null
     */
    public function getSupplierIdentification()
    {
        return $this->supplierIdentification;
    }
    /**
     * Set supplierIdentification value
     * @param \StructType\InternationalIdentifier $supplierIdentification
     * @return \StructType\Exchange
     */
    public function setSupplierIdentification(\StructType\InternationalIdentifier $supplierIdentification = null)
    {
        $this->supplierIdentification = $supplierIdentification;
        return $this;
    }
    /**
     * Get target value
     * @return \StructType\Target|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param \StructType\Target $target
     * @return \StructType\Exchange
     */
    public function setTarget(\StructType\Target $target = null)
    {
        $this->target = $target;
        return $this;
    }
    /**
     * Get subscription value
     * @return \StructType\Subscription|null
     */
    public function getSubscription()
    {
        return $this->subscription;
    }
    /**
     * Set subscription value
     * @param \StructType\Subscription $subscription
     * @return \StructType\Exchange
     */
    public function setSubscription(\StructType\Subscription $subscription = null)
    {
        $this->subscription = $subscription;
        return $this;
    }
    /**
     * Get filterReference value
     * @return \StructType\FilterReference[]|null
     */
    public function getFilterReference()
    {
        return $this->filterReference;
    }
    /**
     * Set filterReference value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterReference[] $filterReference
     * @return \StructType\Exchange
     */
    public function setFilterReference(array $filterReference = array())
    {
        foreach ($filterReference as $exchangeFilterReferenceItem) {
            // validation for constraint: itemType
            if (!$exchangeFilterReferenceItem instanceof \StructType\FilterReference) {
                throw new \InvalidArgumentException(sprintf('The filterReference property can only contain items of \StructType\FilterReference, "%s" given', is_object($exchangeFilterReferenceItem) ? get_class($exchangeFilterReferenceItem) : gettype($exchangeFilterReferenceItem)), __LINE__);
            }
        }
        $this->filterReference = $filterReference;
        return $this;
    }
    /**
     * Add item to filterReference value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterReference $item
     * @return \StructType\Exchange
     */
    public function addToFilterReference(\StructType\FilterReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FilterReference) {
            throw new \InvalidArgumentException(sprintf('The filterReference property can only contain items of \StructType\FilterReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->filterReference[] = $item;
        return $this;
    }
    /**
     * Get catalogueReference value
     * @return \StructType\CatalogueReference[]|null
     */
    public function getCatalogueReference()
    {
        return $this->catalogueReference;
    }
    /**
     * Set catalogueReference value
     * @throws \InvalidArgumentException
     * @param \StructType\CatalogueReference[] $catalogueReference
     * @return \StructType\Exchange
     */
    public function setCatalogueReference(array $catalogueReference = array())
    {
        foreach ($catalogueReference as $exchangeCatalogueReferenceItem) {
            // validation for constraint: itemType
            if (!$exchangeCatalogueReferenceItem instanceof \StructType\CatalogueReference) {
                throw new \InvalidArgumentException(sprintf('The catalogueReference property can only contain items of \StructType\CatalogueReference, "%s" given', is_object($exchangeCatalogueReferenceItem) ? get_class($exchangeCatalogueReferenceItem) : gettype($exchangeCatalogueReferenceItem)), __LINE__);
            }
        }
        $this->catalogueReference = $catalogueReference;
        return $this;
    }
    /**
     * Add item to catalogueReference value
     * @throws \InvalidArgumentException
     * @param \StructType\CatalogueReference $item
     * @return \StructType\Exchange
     */
    public function addToCatalogueReference(\StructType\CatalogueReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CatalogueReference) {
            throw new \InvalidArgumentException(sprintf('The catalogueReference property can only contain items of \StructType\CatalogueReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->catalogueReference[] = $item;
        return $this;
    }
    /**
     * Get exchangeExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getExchangeExtension()
    {
        return $this->exchangeExtension;
    }
    /**
     * Set exchangeExtension value
     * @param \StructType\ExtensionType $exchangeExtension
     * @return \StructType\Exchange
     */
    public function setExchangeExtension(\StructType\ExtensionType $exchangeExtension = null)
    {
        $this->exchangeExtension = $exchangeExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Exchange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
