<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedTimetablePermissions StructType
 * Meta informations extracted from the WSDL
 * - documentation: Participant's permissions to use the service.
 * @subpackage Structs
 */
class EstimatedTimetablePermissions extends PermissionsStructure
{
    /**
     * The EstimatedTimetablePermission
     * Meta informations extracted from the WSDL
     * - documentation: Permission for a single participant or all participants to use an aspect of the service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ConnectionServicePermissionStructure[]
     */
    public $EstimatedTimetablePermission;
    /**
     * Constructor method for EstimatedTimetablePermissions
     * @uses EstimatedTimetablePermissions::setEstimatedTimetablePermission()
     * @param \StructType\ConnectionServicePermissionStructure[] $estimatedTimetablePermission
     */
    public function __construct(array $estimatedTimetablePermission = array())
    {
        $this
            ->setEstimatedTimetablePermission($estimatedTimetablePermission);
    }
    /**
     * Get EstimatedTimetablePermission value
     * @return \StructType\ConnectionServicePermissionStructure[]|null
     */
    public function getEstimatedTimetablePermission()
    {
        return $this->EstimatedTimetablePermission;
    }
    /**
     * Set EstimatedTimetablePermission value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionServicePermissionStructure[] $estimatedTimetablePermission
     * @return \StructType\EstimatedTimetablePermissions
     */
    public function setEstimatedTimetablePermission(array $estimatedTimetablePermission = array())
    {
        foreach ($estimatedTimetablePermission as $estimatedTimetablePermissionsEstimatedTimetablePermissionItem) {
            // validation for constraint: itemType
            if (!$estimatedTimetablePermissionsEstimatedTimetablePermissionItem instanceof \StructType\ConnectionServicePermissionStructure) {
                throw new \InvalidArgumentException(sprintf('The EstimatedTimetablePermission property can only contain items of \StructType\ConnectionServicePermissionStructure, "%s" given', is_object($estimatedTimetablePermissionsEstimatedTimetablePermissionItem) ? get_class($estimatedTimetablePermissionsEstimatedTimetablePermissionItem) : gettype($estimatedTimetablePermissionsEstimatedTimetablePermissionItem)), __LINE__);
            }
        }
        $this->EstimatedTimetablePermission = $estimatedTimetablePermission;
        return $this;
    }
    /**
     * Add item to EstimatedTimetablePermission value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionServicePermissionStructure $item
     * @return \StructType\EstimatedTimetablePermissions
     */
    public function addToEstimatedTimetablePermission(\StructType\ConnectionServicePermissionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConnectionServicePermissionStructure) {
            throw new \InvalidArgumentException(sprintf('The EstimatedTimetablePermission property can only contain items of \StructType\ConnectionServicePermissionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EstimatedTimetablePermission[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EstimatedTimetablePermissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
