<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedTimetableDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Delivery for Real-time Timetable Service.
 * @subpackage Structs
 */
class EstimatedTimetableDeliveryStructure extends AbstractServiceDeliveryStructure
{
    /**
     * The EstimatedJourneyVersionFrame
     * @var \StructType\EstimatedVersionFrameStructure
     */
    public $EstimatedJourneyVersionFrame;
    /**
     * The Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for EstimatedTimetableDeliveryStructure
     * @uses EstimatedTimetableDeliveryStructure::setEstimatedJourneyVersionFrame()
     * @uses EstimatedTimetableDeliveryStructure::setExtensions()
     * @uses EstimatedTimetableDeliveryStructure::setVersion()
     * @param \StructType\EstimatedVersionFrameStructure $estimatedJourneyVersionFrame
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\EstimatedVersionFrameStructure $estimatedJourneyVersionFrame = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setEstimatedJourneyVersionFrame($estimatedJourneyVersionFrame)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get EstimatedJourneyVersionFrame value
     * @return \StructType\EstimatedVersionFrameStructure|null
     */
    public function getEstimatedJourneyVersionFrame()
    {
        return $this->EstimatedJourneyVersionFrame;
    }
    /**
     * Set EstimatedJourneyVersionFrame value
     * @param \StructType\EstimatedVersionFrameStructure $estimatedJourneyVersionFrame
     * @return \StructType\EstimatedTimetableDeliveryStructure
     */
    public function setEstimatedJourneyVersionFrame(\StructType\EstimatedVersionFrameStructure $estimatedJourneyVersionFrame = null)
    {
        $this->EstimatedJourneyVersionFrame = $estimatedJourneyVersionFrame;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\EstimatedTimetableDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\EstimatedTimetableDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EstimatedTimetableDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
