<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedCallStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Rea-ltime info about a VEHICLE JOURNEY Stop.
 * @subpackage Structs
 */
class EstimatedCallStructure extends AbstractStructBase
{
    /**
     * The StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The VisitNumber
     * Meta informations extracted from the WSDL
     * - documentation: Type for Stop Visit.
     * @var int
     */
    public $VisitNumber;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The StopPointName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $StopPointName;
    /**
     * The ExtraCall
     * Meta informations extracted from the WSDL
     * - documentation: This call is additional and unplanned. If omitted: CALL is planned.
     * - minOccurs: 0
     * @var bool
     */
    public $ExtraCall;
    /**
     * The Cancellation
     * Meta informations extracted from the WSDL
     * - documentation: This call is a cancellation of a previously announced call.
     * - minOccurs: 0
     * @var bool
     */
    public $Cancellation;
    /**
     * The PredictionInaccurate
     * @var bool
     */
    public $PredictionInaccurate;
    /**
     * The Occupancy
     * @var string
     */
    public $Occupancy;
    /**
     * The TimingPoint
     * @var bool
     */
    public $TimingPoint;
    /**
     * The BoardingStretch
     * @var bool
     */
    public $BoardingStretch;
    /**
     * The RequestStop
     * @var bool
     */
    public $RequestStop;
    /**
     * The OriginDisplay
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $OriginDisplay;
    /**
     * The DestinationDisplay
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DestinationDisplay;
    /**
     * The CallNote
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $CallNote;
    /**
     * The FacilityConditionElement
     * @var \StructType\FacilityConditionStructure
     */
    public $FacilityConditionElement;
    /**
     * The FacilityChangeElement
     * @var \StructType\FacilityChangeStructure
     */
    public $FacilityChangeElement;
    /**
     * The SituationRef
     * @var \StructType\SituationRefStructure
     */
    public $SituationRef;
    /**
     * The AimedArrivalTime
     * @var string
     */
    public $AimedArrivalTime;
    /**
     * The ExpectedArrivalTime
     * @var string
     */
    public $ExpectedArrivalTime;
    /**
     * The ExpectedArrivalPredictionQuality
     * @var \StructType\PredictionQualityStructure
     */
    public $ExpectedArrivalPredictionQuality;
    /**
     * The ArrivalStatus
     * @var string
     */
    public $ArrivalStatus;
    /**
     * The ArrivalProximityText
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $ArrivalProximityText;
    /**
     * The ArrivalPlatformName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $ArrivalPlatformName;
    /**
     * The ArrivalBoardingActivity
     * @var string
     */
    public $ArrivalBoardingActivity;
    /**
     * The ArrivalStopAssignment
     * @var \StructType\StopAssignmentStructure
     */
    public $ArrivalStopAssignment;
    /**
     * The ArrivalOperatorRefs
     * @var \StructType\OperatorRefStructure
     */
    public $ArrivalOperatorRefs;
    /**
     * The AimedDepartureTime
     * @var string
     */
    public $AimedDepartureTime;
    /**
     * The ExpectedDepartureTime
     * @var string
     */
    public $ExpectedDepartureTime;
    /**
     * The ProvisionalExpectedDepartureTime
     * @var string
     */
    public $ProvisionalExpectedDepartureTime;
    /**
     * The EarliestExpectedDepartureTime
     * @var string
     */
    public $EarliestExpectedDepartureTime;
    /**
     * The ExpectedDeparturePredictionQuality
     * @var \StructType\PredictionQualityStructure
     */
    public $ExpectedDeparturePredictionQuality;
    /**
     * The AimedLatestPassengerAccessTime
     * @var string
     */
    public $AimedLatestPassengerAccessTime;
    /**
     * The ExpectedLatestPassengerAccessTime
     * @var string
     */
    public $ExpectedLatestPassengerAccessTime;
    /**
     * The DepartureStatus
     * @var string
     */
    public $DepartureStatus;
    /**
     * The DepartureProximityText
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DepartureProximityText;
    /**
     * The DeparturePlatformName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DeparturePlatformName;
    /**
     * The DepartureBoardingActivity
     * @var string
     */
    public $DepartureBoardingActivity;
    /**
     * The DepartureStopAssignment
     * @var \StructType\StopAssignmentStructure
     */
    public $DepartureStopAssignment;
    /**
     * The DepartureOperatorRefs
     * @var \StructType\OperatorRefStructure
     */
    public $DepartureOperatorRefs;
    /**
     * The AimedHeadwayInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $AimedHeadwayInterval;
    /**
     * The ExpectedHeadwayInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $ExpectedHeadwayInterval;
    /**
     * The DistanceFromStop
     * Meta informations extracted from the WSDL
     * - documentation: Distance (metres) as defined by http://www.ordnancesurvey.co.uk/xml/resource/units.xml#metres. ALternative units may be specifed by context.
     * @var int
     */
    public $DistanceFromStop;
    /**
     * The NumberOfStopsAway
     * @var int
     */
    public $NumberOfStopsAway;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for EstimatedCallStructure
     * @uses EstimatedCallStructure::setStopPointRef()
     * @uses EstimatedCallStructure::setVisitNumber()
     * @uses EstimatedCallStructure::setOrder()
     * @uses EstimatedCallStructure::setStopPointName()
     * @uses EstimatedCallStructure::setExtraCall()
     * @uses EstimatedCallStructure::setCancellation()
     * @uses EstimatedCallStructure::setPredictionInaccurate()
     * @uses EstimatedCallStructure::setOccupancy()
     * @uses EstimatedCallStructure::setTimingPoint()
     * @uses EstimatedCallStructure::setBoardingStretch()
     * @uses EstimatedCallStructure::setRequestStop()
     * @uses EstimatedCallStructure::setOriginDisplay()
     * @uses EstimatedCallStructure::setDestinationDisplay()
     * @uses EstimatedCallStructure::setCallNote()
     * @uses EstimatedCallStructure::setFacilityConditionElement()
     * @uses EstimatedCallStructure::setFacilityChangeElement()
     * @uses EstimatedCallStructure::setSituationRef()
     * @uses EstimatedCallStructure::setAimedArrivalTime()
     * @uses EstimatedCallStructure::setExpectedArrivalTime()
     * @uses EstimatedCallStructure::setExpectedArrivalPredictionQuality()
     * @uses EstimatedCallStructure::setArrivalStatus()
     * @uses EstimatedCallStructure::setArrivalProximityText()
     * @uses EstimatedCallStructure::setArrivalPlatformName()
     * @uses EstimatedCallStructure::setArrivalBoardingActivity()
     * @uses EstimatedCallStructure::setArrivalStopAssignment()
     * @uses EstimatedCallStructure::setArrivalOperatorRefs()
     * @uses EstimatedCallStructure::setAimedDepartureTime()
     * @uses EstimatedCallStructure::setExpectedDepartureTime()
     * @uses EstimatedCallStructure::setProvisionalExpectedDepartureTime()
     * @uses EstimatedCallStructure::setEarliestExpectedDepartureTime()
     * @uses EstimatedCallStructure::setExpectedDeparturePredictionQuality()
     * @uses EstimatedCallStructure::setAimedLatestPassengerAccessTime()
     * @uses EstimatedCallStructure::setExpectedLatestPassengerAccessTime()
     * @uses EstimatedCallStructure::setDepartureStatus()
     * @uses EstimatedCallStructure::setDepartureProximityText()
     * @uses EstimatedCallStructure::setDeparturePlatformName()
     * @uses EstimatedCallStructure::setDepartureBoardingActivity()
     * @uses EstimatedCallStructure::setDepartureStopAssignment()
     * @uses EstimatedCallStructure::setDepartureOperatorRefs()
     * @uses EstimatedCallStructure::setAimedHeadwayInterval()
     * @uses EstimatedCallStructure::setExpectedHeadwayInterval()
     * @uses EstimatedCallStructure::setDistanceFromStop()
     * @uses EstimatedCallStructure::setNumberOfStopsAway()
     * @uses EstimatedCallStructure::setExtensions()
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param int $visitNumber
     * @param int $order
     * @param \StructType\NaturalLanguageStringStructure $stopPointName
     * @param bool $extraCall
     * @param bool $cancellation
     * @param bool $predictionInaccurate
     * @param string $occupancy
     * @param bool $timingPoint
     * @param bool $boardingStretch
     * @param bool $requestStop
     * @param \StructType\NaturalLanguageStringStructure $originDisplay
     * @param \StructType\NaturalLanguageStringStructure $destinationDisplay
     * @param \StructType\NaturalLanguageStringStructure $callNote
     * @param \StructType\FacilityConditionStructure $facilityConditionElement
     * @param \StructType\FacilityChangeStructure $facilityChangeElement
     * @param \StructType\SituationRefStructure $situationRef
     * @param string $aimedArrivalTime
     * @param string $expectedArrivalTime
     * @param \StructType\PredictionQualityStructure $expectedArrivalPredictionQuality
     * @param string $arrivalStatus
     * @param \StructType\NaturalLanguageStringStructure $arrivalProximityText
     * @param \StructType\NaturalLanguageStringStructure $arrivalPlatformName
     * @param string $arrivalBoardingActivity
     * @param \StructType\StopAssignmentStructure $arrivalStopAssignment
     * @param \StructType\OperatorRefStructure $arrivalOperatorRefs
     * @param string $aimedDepartureTime
     * @param string $expectedDepartureTime
     * @param string $provisionalExpectedDepartureTime
     * @param string $earliestExpectedDepartureTime
     * @param \StructType\PredictionQualityStructure $expectedDeparturePredictionQuality
     * @param string $aimedLatestPassengerAccessTime
     * @param string $expectedLatestPassengerAccessTime
     * @param string $departureStatus
     * @param \StructType\NaturalLanguageStringStructure $departureProximityText
     * @param \StructType\NaturalLanguageStringStructure $departurePlatformName
     * @param string $departureBoardingActivity
     * @param \StructType\StopAssignmentStructure $departureStopAssignment
     * @param \StructType\OperatorRefStructure $departureOperatorRefs
     * @param string $aimedHeadwayInterval
     * @param string $expectedHeadwayInterval
     * @param int $distanceFromStop
     * @param int $numberOfStopsAway
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\StopPointRefStructure $stopPointRef = null, $visitNumber = null, $order = null, \StructType\NaturalLanguageStringStructure $stopPointName = null, $extraCall = null, $cancellation = null, $predictionInaccurate = null, $occupancy = null, $timingPoint = null, $boardingStretch = null, $requestStop = null, \StructType\NaturalLanguageStringStructure $originDisplay = null, \StructType\NaturalLanguageStringStructure $destinationDisplay = null, \StructType\NaturalLanguageStringStructure $callNote = null, \StructType\FacilityConditionStructure $facilityConditionElement = null, \StructType\FacilityChangeStructure $facilityChangeElement = null, \StructType\SituationRefStructure $situationRef = null, $aimedArrivalTime = null, $expectedArrivalTime = null, \StructType\PredictionQualityStructure $expectedArrivalPredictionQuality = null, $arrivalStatus = null, \StructType\NaturalLanguageStringStructure $arrivalProximityText = null, \StructType\NaturalLanguageStringStructure $arrivalPlatformName = null, $arrivalBoardingActivity = null, \StructType\StopAssignmentStructure $arrivalStopAssignment = null, \StructType\OperatorRefStructure $arrivalOperatorRefs = null, $aimedDepartureTime = null, $expectedDepartureTime = null, $provisionalExpectedDepartureTime = null, $earliestExpectedDepartureTime = null, \StructType\PredictionQualityStructure $expectedDeparturePredictionQuality = null, $aimedLatestPassengerAccessTime = null, $expectedLatestPassengerAccessTime = null, $departureStatus = null, \StructType\NaturalLanguageStringStructure $departureProximityText = null, \StructType\NaturalLanguageStringStructure $departurePlatformName = null, $departureBoardingActivity = null, \StructType\StopAssignmentStructure $departureStopAssignment = null, \StructType\OperatorRefStructure $departureOperatorRefs = null, $aimedHeadwayInterval = null, $expectedHeadwayInterval = null, $distanceFromStop = null, $numberOfStopsAway = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setStopPointRef($stopPointRef)
            ->setVisitNumber($visitNumber)
            ->setOrder($order)
            ->setStopPointName($stopPointName)
            ->setExtraCall($extraCall)
            ->setCancellation($cancellation)
            ->setPredictionInaccurate($predictionInaccurate)
            ->setOccupancy($occupancy)
            ->setTimingPoint($timingPoint)
            ->setBoardingStretch($boardingStretch)
            ->setRequestStop($requestStop)
            ->setOriginDisplay($originDisplay)
            ->setDestinationDisplay($destinationDisplay)
            ->setCallNote($callNote)
            ->setFacilityConditionElement($facilityConditionElement)
            ->setFacilityChangeElement($facilityChangeElement)
            ->setSituationRef($situationRef)
            ->setAimedArrivalTime($aimedArrivalTime)
            ->setExpectedArrivalTime($expectedArrivalTime)
            ->setExpectedArrivalPredictionQuality($expectedArrivalPredictionQuality)
            ->setArrivalStatus($arrivalStatus)
            ->setArrivalProximityText($arrivalProximityText)
            ->setArrivalPlatformName($arrivalPlatformName)
            ->setArrivalBoardingActivity($arrivalBoardingActivity)
            ->setArrivalStopAssignment($arrivalStopAssignment)
            ->setArrivalOperatorRefs($arrivalOperatorRefs)
            ->setAimedDepartureTime($aimedDepartureTime)
            ->setExpectedDepartureTime($expectedDepartureTime)
            ->setProvisionalExpectedDepartureTime($provisionalExpectedDepartureTime)
            ->setEarliestExpectedDepartureTime($earliestExpectedDepartureTime)
            ->setExpectedDeparturePredictionQuality($expectedDeparturePredictionQuality)
            ->setAimedLatestPassengerAccessTime($aimedLatestPassengerAccessTime)
            ->setExpectedLatestPassengerAccessTime($expectedLatestPassengerAccessTime)
            ->setDepartureStatus($departureStatus)
            ->setDepartureProximityText($departureProximityText)
            ->setDeparturePlatformName($departurePlatformName)
            ->setDepartureBoardingActivity($departureBoardingActivity)
            ->setDepartureStopAssignment($departureStopAssignment)
            ->setDepartureOperatorRefs($departureOperatorRefs)
            ->setAimedHeadwayInterval($aimedHeadwayInterval)
            ->setExpectedHeadwayInterval($expectedHeadwayInterval)
            ->setDistanceFromStop($distanceFromStop)
            ->setNumberOfStopsAway($numberOfStopsAway)
            ->setExtensions($extensions);
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\EstimatedCallStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get VisitNumber value
     * @return int|null
     */
    public function getVisitNumber()
    {
        return $this->VisitNumber;
    }
    /**
     * Set VisitNumber value
     * @param int $visitNumber
     * @return \StructType\EstimatedCallStructure
     */
    public function setVisitNumber($visitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($visitNumber) && !is_numeric($visitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($visitNumber)), __LINE__);
        }
        $this->VisitNumber = $visitNumber;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\EstimatedCallStructure
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get StopPointName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getStopPointName()
    {
        return $this->StopPointName;
    }
    /**
     * Set StopPointName value
     * @param \StructType\NaturalLanguageStringStructure $stopPointName
     * @return \StructType\EstimatedCallStructure
     */
    public function setStopPointName(\StructType\NaturalLanguageStringStructure $stopPointName = null)
    {
        $this->StopPointName = $stopPointName;
        return $this;
    }
    /**
     * Get ExtraCall value
     * @return bool|null
     */
    public function getExtraCall()
    {
        return $this->ExtraCall;
    }
    /**
     * Set ExtraCall value
     * @param bool $extraCall
     * @return \StructType\EstimatedCallStructure
     */
    public function setExtraCall($extraCall = null)
    {
        // validation for constraint: boolean
        if (!is_null($extraCall) && !is_bool($extraCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($extraCall)), __LINE__);
        }
        $this->ExtraCall = $extraCall;
        return $this;
    }
    /**
     * Get Cancellation value
     * @return bool|null
     */
    public function getCancellation()
    {
        return $this->Cancellation;
    }
    /**
     * Set Cancellation value
     * @param bool $cancellation
     * @return \StructType\EstimatedCallStructure
     */
    public function setCancellation($cancellation = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancellation) && !is_bool($cancellation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cancellation)), __LINE__);
        }
        $this->Cancellation = $cancellation;
        return $this;
    }
    /**
     * Get PredictionInaccurate value
     * @return bool|null
     */
    public function getPredictionInaccurate()
    {
        return $this->PredictionInaccurate;
    }
    /**
     * Set PredictionInaccurate value
     * @param bool $predictionInaccurate
     * @return \StructType\EstimatedCallStructure
     */
    public function setPredictionInaccurate($predictionInaccurate = null)
    {
        // validation for constraint: boolean
        if (!is_null($predictionInaccurate) && !is_bool($predictionInaccurate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($predictionInaccurate)), __LINE__);
        }
        $this->PredictionInaccurate = $predictionInaccurate;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return string|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * Set Occupancy value
     * @uses \EnumType\OccupancyEnumeration::valueIsValid()
     * @uses \EnumType\OccupancyEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $occupancy
     * @return \StructType\EstimatedCallStructure
     */
    public function setOccupancy($occupancy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OccupancyEnumeration::valueIsValid($occupancy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $occupancy, implode(', ', \EnumType\OccupancyEnumeration::getValidValues())), __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Get TimingPoint value
     * @return bool|null
     */
    public function getTimingPoint()
    {
        return $this->TimingPoint;
    }
    /**
     * Set TimingPoint value
     * @param bool $timingPoint
     * @return \StructType\EstimatedCallStructure
     */
    public function setTimingPoint($timingPoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($timingPoint) && !is_bool($timingPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($timingPoint)), __LINE__);
        }
        $this->TimingPoint = $timingPoint;
        return $this;
    }
    /**
     * Get BoardingStretch value
     * @return bool|null
     */
    public function getBoardingStretch()
    {
        return $this->BoardingStretch;
    }
    /**
     * Set BoardingStretch value
     * @param bool $boardingStretch
     * @return \StructType\EstimatedCallStructure
     */
    public function setBoardingStretch($boardingStretch = null)
    {
        // validation for constraint: boolean
        if (!is_null($boardingStretch) && !is_bool($boardingStretch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($boardingStretch)), __LINE__);
        }
        $this->BoardingStretch = $boardingStretch;
        return $this;
    }
    /**
     * Get RequestStop value
     * @return bool|null
     */
    public function getRequestStop()
    {
        return $this->RequestStop;
    }
    /**
     * Set RequestStop value
     * @param bool $requestStop
     * @return \StructType\EstimatedCallStructure
     */
    public function setRequestStop($requestStop = null)
    {
        // validation for constraint: boolean
        if (!is_null($requestStop) && !is_bool($requestStop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requestStop)), __LINE__);
        }
        $this->RequestStop = $requestStop;
        return $this;
    }
    /**
     * Get OriginDisplay value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getOriginDisplay()
    {
        return $this->OriginDisplay;
    }
    /**
     * Set OriginDisplay value
     * @param \StructType\NaturalLanguageStringStructure $originDisplay
     * @return \StructType\EstimatedCallStructure
     */
    public function setOriginDisplay(\StructType\NaturalLanguageStringStructure $originDisplay = null)
    {
        $this->OriginDisplay = $originDisplay;
        return $this;
    }
    /**
     * Get DestinationDisplay value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDestinationDisplay()
    {
        return $this->DestinationDisplay;
    }
    /**
     * Set DestinationDisplay value
     * @param \StructType\NaturalLanguageStringStructure $destinationDisplay
     * @return \StructType\EstimatedCallStructure
     */
    public function setDestinationDisplay(\StructType\NaturalLanguageStringStructure $destinationDisplay = null)
    {
        $this->DestinationDisplay = $destinationDisplay;
        return $this;
    }
    /**
     * Get CallNote value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getCallNote()
    {
        return $this->CallNote;
    }
    /**
     * Set CallNote value
     * @param \StructType\NaturalLanguageStringStructure $callNote
     * @return \StructType\EstimatedCallStructure
     */
    public function setCallNote(\StructType\NaturalLanguageStringStructure $callNote = null)
    {
        $this->CallNote = $callNote;
        return $this;
    }
    /**
     * Get FacilityConditionElement value
     * @return \StructType\FacilityConditionStructure|null
     */
    public function getFacilityConditionElement()
    {
        return $this->FacilityConditionElement;
    }
    /**
     * Set FacilityConditionElement value
     * @param \StructType\FacilityConditionStructure $facilityConditionElement
     * @return \StructType\EstimatedCallStructure
     */
    public function setFacilityConditionElement(\StructType\FacilityConditionStructure $facilityConditionElement = null)
    {
        $this->FacilityConditionElement = $facilityConditionElement;
        return $this;
    }
    /**
     * Get FacilityChangeElement value
     * @return \StructType\FacilityChangeStructure|null
     */
    public function getFacilityChangeElement()
    {
        return $this->FacilityChangeElement;
    }
    /**
     * Set FacilityChangeElement value
     * @param \StructType\FacilityChangeStructure $facilityChangeElement
     * @return \StructType\EstimatedCallStructure
     */
    public function setFacilityChangeElement(\StructType\FacilityChangeStructure $facilityChangeElement = null)
    {
        $this->FacilityChangeElement = $facilityChangeElement;
        return $this;
    }
    /**
     * Get SituationRef value
     * @return \StructType\SituationRefStructure|null
     */
    public function getSituationRef()
    {
        return $this->SituationRef;
    }
    /**
     * Set SituationRef value
     * @param \StructType\SituationRefStructure $situationRef
     * @return \StructType\EstimatedCallStructure
     */
    public function setSituationRef(\StructType\SituationRefStructure $situationRef = null)
    {
        $this->SituationRef = $situationRef;
        return $this;
    }
    /**
     * Get AimedArrivalTime value
     * @return string|null
     */
    public function getAimedArrivalTime()
    {
        return $this->AimedArrivalTime;
    }
    /**
     * Set AimedArrivalTime value
     * @param string $aimedArrivalTime
     * @return \StructType\EstimatedCallStructure
     */
    public function setAimedArrivalTime($aimedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedArrivalTime) && !is_string($aimedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedArrivalTime)), __LINE__);
        }
        $this->AimedArrivalTime = $aimedArrivalTime;
        return $this;
    }
    /**
     * Get ExpectedArrivalTime value
     * @return string|null
     */
    public function getExpectedArrivalTime()
    {
        return $this->ExpectedArrivalTime;
    }
    /**
     * Set ExpectedArrivalTime value
     * @param string $expectedArrivalTime
     * @return \StructType\EstimatedCallStructure
     */
    public function setExpectedArrivalTime($expectedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($expectedArrivalTime) && !is_string($expectedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedArrivalTime)), __LINE__);
        }
        $this->ExpectedArrivalTime = $expectedArrivalTime;
        return $this;
    }
    /**
     * Get ExpectedArrivalPredictionQuality value
     * @return \StructType\PredictionQualityStructure|null
     */
    public function getExpectedArrivalPredictionQuality()
    {
        return $this->ExpectedArrivalPredictionQuality;
    }
    /**
     * Set ExpectedArrivalPredictionQuality value
     * @param \StructType\PredictionQualityStructure $expectedArrivalPredictionQuality
     * @return \StructType\EstimatedCallStructure
     */
    public function setExpectedArrivalPredictionQuality(\StructType\PredictionQualityStructure $expectedArrivalPredictionQuality = null)
    {
        $this->ExpectedArrivalPredictionQuality = $expectedArrivalPredictionQuality;
        return $this;
    }
    /**
     * Get ArrivalStatus value
     * @return string|null
     */
    public function getArrivalStatus()
    {
        return $this->ArrivalStatus;
    }
    /**
     * Set ArrivalStatus value
     * @uses \EnumType\CallStatusEnumeration::valueIsValid()
     * @uses \EnumType\CallStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrivalStatus
     * @return \StructType\EstimatedCallStructure
     */
    public function setArrivalStatus($arrivalStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CallStatusEnumeration::valueIsValid($arrivalStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $arrivalStatus, implode(', ', \EnumType\CallStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->ArrivalStatus = $arrivalStatus;
        return $this;
    }
    /**
     * Get ArrivalProximityText value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getArrivalProximityText()
    {
        return $this->ArrivalProximityText;
    }
    /**
     * Set ArrivalProximityText value
     * @param \StructType\NaturalLanguageStringStructure $arrivalProximityText
     * @return \StructType\EstimatedCallStructure
     */
    public function setArrivalProximityText(\StructType\NaturalLanguageStringStructure $arrivalProximityText = null)
    {
        $this->ArrivalProximityText = $arrivalProximityText;
        return $this;
    }
    /**
     * Get ArrivalPlatformName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getArrivalPlatformName()
    {
        return $this->ArrivalPlatformName;
    }
    /**
     * Set ArrivalPlatformName value
     * @param \StructType\NaturalLanguageStringStructure $arrivalPlatformName
     * @return \StructType\EstimatedCallStructure
     */
    public function setArrivalPlatformName(\StructType\NaturalLanguageStringStructure $arrivalPlatformName = null)
    {
        $this->ArrivalPlatformName = $arrivalPlatformName;
        return $this;
    }
    /**
     * Get ArrivalBoardingActivity value
     * @return string|null
     */
    public function getArrivalBoardingActivity()
    {
        return $this->ArrivalBoardingActivity;
    }
    /**
     * Set ArrivalBoardingActivity value
     * @uses \EnumType\ArrivalBoardingActivityEnumeration::valueIsValid()
     * @uses \EnumType\ArrivalBoardingActivityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrivalBoardingActivity
     * @return \StructType\EstimatedCallStructure
     */
    public function setArrivalBoardingActivity($arrivalBoardingActivity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ArrivalBoardingActivityEnumeration::valueIsValid($arrivalBoardingActivity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $arrivalBoardingActivity, implode(', ', \EnumType\ArrivalBoardingActivityEnumeration::getValidValues())), __LINE__);
        }
        $this->ArrivalBoardingActivity = $arrivalBoardingActivity;
        return $this;
    }
    /**
     * Get ArrivalStopAssignment value
     * @return \StructType\StopAssignmentStructure|null
     */
    public function getArrivalStopAssignment()
    {
        return $this->ArrivalStopAssignment;
    }
    /**
     * Set ArrivalStopAssignment value
     * @param \StructType\StopAssignmentStructure $arrivalStopAssignment
     * @return \StructType\EstimatedCallStructure
     */
    public function setArrivalStopAssignment(\StructType\StopAssignmentStructure $arrivalStopAssignment = null)
    {
        $this->ArrivalStopAssignment = $arrivalStopAssignment;
        return $this;
    }
    /**
     * Get ArrivalOperatorRefs value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getArrivalOperatorRefs()
    {
        return $this->ArrivalOperatorRefs;
    }
    /**
     * Set ArrivalOperatorRefs value
     * @param \StructType\OperatorRefStructure $arrivalOperatorRefs
     * @return \StructType\EstimatedCallStructure
     */
    public function setArrivalOperatorRefs(\StructType\OperatorRefStructure $arrivalOperatorRefs = null)
    {
        $this->ArrivalOperatorRefs = $arrivalOperatorRefs;
        return $this;
    }
    /**
     * Get AimedDepartureTime value
     * @return string|null
     */
    public function getAimedDepartureTime()
    {
        return $this->AimedDepartureTime;
    }
    /**
     * Set AimedDepartureTime value
     * @param string $aimedDepartureTime
     * @return \StructType\EstimatedCallStructure
     */
    public function setAimedDepartureTime($aimedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedDepartureTime) && !is_string($aimedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedDepartureTime)), __LINE__);
        }
        $this->AimedDepartureTime = $aimedDepartureTime;
        return $this;
    }
    /**
     * Get ExpectedDepartureTime value
     * @return string|null
     */
    public function getExpectedDepartureTime()
    {
        return $this->ExpectedDepartureTime;
    }
    /**
     * Set ExpectedDepartureTime value
     * @param string $expectedDepartureTime
     * @return \StructType\EstimatedCallStructure
     */
    public function setExpectedDepartureTime($expectedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($expectedDepartureTime) && !is_string($expectedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedDepartureTime)), __LINE__);
        }
        $this->ExpectedDepartureTime = $expectedDepartureTime;
        return $this;
    }
    /**
     * Get ProvisionalExpectedDepartureTime value
     * @return string|null
     */
    public function getProvisionalExpectedDepartureTime()
    {
        return $this->ProvisionalExpectedDepartureTime;
    }
    /**
     * Set ProvisionalExpectedDepartureTime value
     * @param string $provisionalExpectedDepartureTime
     * @return \StructType\EstimatedCallStructure
     */
    public function setProvisionalExpectedDepartureTime($provisionalExpectedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($provisionalExpectedDepartureTime) && !is_string($provisionalExpectedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provisionalExpectedDepartureTime)), __LINE__);
        }
        $this->ProvisionalExpectedDepartureTime = $provisionalExpectedDepartureTime;
        return $this;
    }
    /**
     * Get EarliestExpectedDepartureTime value
     * @return string|null
     */
    public function getEarliestExpectedDepartureTime()
    {
        return $this->EarliestExpectedDepartureTime;
    }
    /**
     * Set EarliestExpectedDepartureTime value
     * @param string $earliestExpectedDepartureTime
     * @return \StructType\EstimatedCallStructure
     */
    public function setEarliestExpectedDepartureTime($earliestExpectedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($earliestExpectedDepartureTime) && !is_string($earliestExpectedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($earliestExpectedDepartureTime)), __LINE__);
        }
        $this->EarliestExpectedDepartureTime = $earliestExpectedDepartureTime;
        return $this;
    }
    /**
     * Get ExpectedDeparturePredictionQuality value
     * @return \StructType\PredictionQualityStructure|null
     */
    public function getExpectedDeparturePredictionQuality()
    {
        return $this->ExpectedDeparturePredictionQuality;
    }
    /**
     * Set ExpectedDeparturePredictionQuality value
     * @param \StructType\PredictionQualityStructure $expectedDeparturePredictionQuality
     * @return \StructType\EstimatedCallStructure
     */
    public function setExpectedDeparturePredictionQuality(\StructType\PredictionQualityStructure $expectedDeparturePredictionQuality = null)
    {
        $this->ExpectedDeparturePredictionQuality = $expectedDeparturePredictionQuality;
        return $this;
    }
    /**
     * Get AimedLatestPassengerAccessTime value
     * @return string|null
     */
    public function getAimedLatestPassengerAccessTime()
    {
        return $this->AimedLatestPassengerAccessTime;
    }
    /**
     * Set AimedLatestPassengerAccessTime value
     * @param string $aimedLatestPassengerAccessTime
     * @return \StructType\EstimatedCallStructure
     */
    public function setAimedLatestPassengerAccessTime($aimedLatestPassengerAccessTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedLatestPassengerAccessTime) && !is_string($aimedLatestPassengerAccessTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedLatestPassengerAccessTime)), __LINE__);
        }
        $this->AimedLatestPassengerAccessTime = $aimedLatestPassengerAccessTime;
        return $this;
    }
    /**
     * Get ExpectedLatestPassengerAccessTime value
     * @return string|null
     */
    public function getExpectedLatestPassengerAccessTime()
    {
        return $this->ExpectedLatestPassengerAccessTime;
    }
    /**
     * Set ExpectedLatestPassengerAccessTime value
     * @param string $expectedLatestPassengerAccessTime
     * @return \StructType\EstimatedCallStructure
     */
    public function setExpectedLatestPassengerAccessTime($expectedLatestPassengerAccessTime = null)
    {
        // validation for constraint: string
        if (!is_null($expectedLatestPassengerAccessTime) && !is_string($expectedLatestPassengerAccessTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedLatestPassengerAccessTime)), __LINE__);
        }
        $this->ExpectedLatestPassengerAccessTime = $expectedLatestPassengerAccessTime;
        return $this;
    }
    /**
     * Get DepartureStatus value
     * @return string|null
     */
    public function getDepartureStatus()
    {
        return $this->DepartureStatus;
    }
    /**
     * Set DepartureStatus value
     * @uses \EnumType\CallStatusEnumeration::valueIsValid()
     * @uses \EnumType\CallStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureStatus
     * @return \StructType\EstimatedCallStructure
     */
    public function setDepartureStatus($departureStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CallStatusEnumeration::valueIsValid($departureStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $departureStatus, implode(', ', \EnumType\CallStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->DepartureStatus = $departureStatus;
        return $this;
    }
    /**
     * Get DepartureProximityText value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDepartureProximityText()
    {
        return $this->DepartureProximityText;
    }
    /**
     * Set DepartureProximityText value
     * @param \StructType\NaturalLanguageStringStructure $departureProximityText
     * @return \StructType\EstimatedCallStructure
     */
    public function setDepartureProximityText(\StructType\NaturalLanguageStringStructure $departureProximityText = null)
    {
        $this->DepartureProximityText = $departureProximityText;
        return $this;
    }
    /**
     * Get DeparturePlatformName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDeparturePlatformName()
    {
        return $this->DeparturePlatformName;
    }
    /**
     * Set DeparturePlatformName value
     * @param \StructType\NaturalLanguageStringStructure $departurePlatformName
     * @return \StructType\EstimatedCallStructure
     */
    public function setDeparturePlatformName(\StructType\NaturalLanguageStringStructure $departurePlatformName = null)
    {
        $this->DeparturePlatformName = $departurePlatformName;
        return $this;
    }
    /**
     * Get DepartureBoardingActivity value
     * @return string|null
     */
    public function getDepartureBoardingActivity()
    {
        return $this->DepartureBoardingActivity;
    }
    /**
     * Set DepartureBoardingActivity value
     * @uses \EnumType\DepartureBoardingActivityEnumeration::valueIsValid()
     * @uses \EnumType\DepartureBoardingActivityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureBoardingActivity
     * @return \StructType\EstimatedCallStructure
     */
    public function setDepartureBoardingActivity($departureBoardingActivity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DepartureBoardingActivityEnumeration::valueIsValid($departureBoardingActivity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $departureBoardingActivity, implode(', ', \EnumType\DepartureBoardingActivityEnumeration::getValidValues())), __LINE__);
        }
        $this->DepartureBoardingActivity = $departureBoardingActivity;
        return $this;
    }
    /**
     * Get DepartureStopAssignment value
     * @return \StructType\StopAssignmentStructure|null
     */
    public function getDepartureStopAssignment()
    {
        return $this->DepartureStopAssignment;
    }
    /**
     * Set DepartureStopAssignment value
     * @param \StructType\StopAssignmentStructure $departureStopAssignment
     * @return \StructType\EstimatedCallStructure
     */
    public function setDepartureStopAssignment(\StructType\StopAssignmentStructure $departureStopAssignment = null)
    {
        $this->DepartureStopAssignment = $departureStopAssignment;
        return $this;
    }
    /**
     * Get DepartureOperatorRefs value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getDepartureOperatorRefs()
    {
        return $this->DepartureOperatorRefs;
    }
    /**
     * Set DepartureOperatorRefs value
     * @param \StructType\OperatorRefStructure $departureOperatorRefs
     * @return \StructType\EstimatedCallStructure
     */
    public function setDepartureOperatorRefs(\StructType\OperatorRefStructure $departureOperatorRefs = null)
    {
        $this->DepartureOperatorRefs = $departureOperatorRefs;
        return $this;
    }
    /**
     * Get AimedHeadwayInterval value
     * @return string|null
     */
    public function getAimedHeadwayInterval()
    {
        return $this->AimedHeadwayInterval;
    }
    /**
     * Set AimedHeadwayInterval value
     * @param string $aimedHeadwayInterval
     * @return \StructType\EstimatedCallStructure
     */
    public function setAimedHeadwayInterval($aimedHeadwayInterval = null)
    {
        // validation for constraint: string
        if (!is_null($aimedHeadwayInterval) && !is_string($aimedHeadwayInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedHeadwayInterval)), __LINE__);
        }
        $this->AimedHeadwayInterval = $aimedHeadwayInterval;
        return $this;
    }
    /**
     * Get ExpectedHeadwayInterval value
     * @return string|null
     */
    public function getExpectedHeadwayInterval()
    {
        return $this->ExpectedHeadwayInterval;
    }
    /**
     * Set ExpectedHeadwayInterval value
     * @param string $expectedHeadwayInterval
     * @return \StructType\EstimatedCallStructure
     */
    public function setExpectedHeadwayInterval($expectedHeadwayInterval = null)
    {
        // validation for constraint: string
        if (!is_null($expectedHeadwayInterval) && !is_string($expectedHeadwayInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedHeadwayInterval)), __LINE__);
        }
        $this->ExpectedHeadwayInterval = $expectedHeadwayInterval;
        return $this;
    }
    /**
     * Get DistanceFromStop value
     * @return int|null
     */
    public function getDistanceFromStop()
    {
        return $this->DistanceFromStop;
    }
    /**
     * Set DistanceFromStop value
     * @param int $distanceFromStop
     * @return \StructType\EstimatedCallStructure
     */
    public function setDistanceFromStop($distanceFromStop = null)
    {
        // validation for constraint: int
        if (!is_null($distanceFromStop) && !is_numeric($distanceFromStop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distanceFromStop)), __LINE__);
        }
        $this->DistanceFromStop = $distanceFromStop;
        return $this;
    }
    /**
     * Get NumberOfStopsAway value
     * @return int|null
     */
    public function getNumberOfStopsAway()
    {
        return $this->NumberOfStopsAway;
    }
    /**
     * Set NumberOfStopsAway value
     * @param int $numberOfStopsAway
     * @return \StructType\EstimatedCallStructure
     */
    public function setNumberOfStopsAway($numberOfStopsAway = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfStopsAway) && !is_numeric($numberOfStopsAway)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfStopsAway)), __LINE__);
        }
        $this->NumberOfStopsAway = $numberOfStopsAway;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\EstimatedCallStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EstimatedCallStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
