<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquipmentAvailabilityStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Availaibility Change of EQUIPMENT.
 * @subpackage Structs
 */
class EquipmentAvailabilityStructure extends AbstractStructBase
{
    /**
     * The EquipmentRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to an EQUIPMENT.
     * - minOccurs: 0
     * @var \StructType\EquipmentRefStructure
     */
    public $EquipmentRef;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Description of EQUIPMENT. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Description;
    /**
     * The EquipmentTypeRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a TYPE OF EQUIPMENT.r.
     * - minOccurs: 0
     * @var \StructType\EquipmentTypeRefStructure
     */
    public $EquipmentTypeRef;
    /**
     * The ValidityPeriod
     * Meta informations extracted from the WSDL
     * - documentation: Period for which change to EQUIPMENT status applies applies. If omitted, indefinite period.
     * - minOccurs: 0
     * @var \StructType\HalfOpenTimestampOutputRangeStructure
     */
    public $ValidityPeriod;
    /**
     * The EquipmentStatus
     * Meta informations extracted from the WSDL
     * - default: notAvailable
     * - documentation: Availability status of the EQUIPMENT. Default is 'notAvailable'.
     * @var string
     */
    public $EquipmentStatus;
    /**
     * The EquipmentFeatures
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EquipmentFeatures
     */
    public $EquipmentFeatures;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for EquipmentAvailabilityStructure
     * @uses EquipmentAvailabilityStructure::setEquipmentRef()
     * @uses EquipmentAvailabilityStructure::setDescription()
     * @uses EquipmentAvailabilityStructure::setEquipmentTypeRef()
     * @uses EquipmentAvailabilityStructure::setValidityPeriod()
     * @uses EquipmentAvailabilityStructure::setEquipmentStatus()
     * @uses EquipmentAvailabilityStructure::setEquipmentFeatures()
     * @uses EquipmentAvailabilityStructure::setExtensions()
     * @param \StructType\EquipmentRefStructure $equipmentRef
     * @param \StructType\NaturalLanguageStringStructure[] $description
     * @param \StructType\EquipmentTypeRefStructure $equipmentTypeRef
     * @param \StructType\HalfOpenTimestampOutputRangeStructure $validityPeriod
     * @param string $equipmentStatus
     * @param \StructType\EquipmentFeatures $equipmentFeatures
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\EquipmentRefStructure $equipmentRef = null, array $description = array(), \StructType\EquipmentTypeRefStructure $equipmentTypeRef = null, \StructType\HalfOpenTimestampOutputRangeStructure $validityPeriod = null, $equipmentStatus = 'notAvailable', \StructType\EquipmentFeatures $equipmentFeatures = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setEquipmentRef($equipmentRef)
            ->setDescription($description)
            ->setEquipmentTypeRef($equipmentTypeRef)
            ->setValidityPeriod($validityPeriod)
            ->setEquipmentStatus($equipmentStatus)
            ->setEquipmentFeatures($equipmentFeatures)
            ->setExtensions($extensions);
    }
    /**
     * Get EquipmentRef value
     * @return \StructType\EquipmentRefStructure|null
     */
    public function getEquipmentRef()
    {
        return $this->EquipmentRef;
    }
    /**
     * Set EquipmentRef value
     * @param \StructType\EquipmentRefStructure $equipmentRef
     * @return \StructType\EquipmentAvailabilityStructure
     */
    public function setEquipmentRef(\StructType\EquipmentRefStructure $equipmentRef = null)
    {
        $this->EquipmentRef = $equipmentRef;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $description
     * @return \StructType\EquipmentAvailabilityStructure
     */
    public function setDescription(array $description = array())
    {
        foreach ($description as $equipmentAvailabilityStructureDescriptionItem) {
            // validation for constraint: itemType
            if (!$equipmentAvailabilityStructureDescriptionItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($equipmentAvailabilityStructureDescriptionItem) ? get_class($equipmentAvailabilityStructureDescriptionItem) : gettype($equipmentAvailabilityStructureDescriptionItem)), __LINE__);
            }
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\EquipmentAvailabilityStructure
     */
    public function addToDescription(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get EquipmentTypeRef value
     * @return \StructType\EquipmentTypeRefStructure|null
     */
    public function getEquipmentTypeRef()
    {
        return $this->EquipmentTypeRef;
    }
    /**
     * Set EquipmentTypeRef value
     * @param \StructType\EquipmentTypeRefStructure $equipmentTypeRef
     * @return \StructType\EquipmentAvailabilityStructure
     */
    public function setEquipmentTypeRef(\StructType\EquipmentTypeRefStructure $equipmentTypeRef = null)
    {
        $this->EquipmentTypeRef = $equipmentTypeRef;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \StructType\HalfOpenTimestampOutputRangeStructure|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \StructType\HalfOpenTimestampOutputRangeStructure $validityPeriod
     * @return \StructType\EquipmentAvailabilityStructure
     */
    public function setValidityPeriod(\StructType\HalfOpenTimestampOutputRangeStructure $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get EquipmentStatus value
     * @return string|null
     */
    public function getEquipmentStatus()
    {
        return $this->EquipmentStatus;
    }
    /**
     * Set EquipmentStatus value
     * @uses \EnumType\EquipmentStatusEnumeration::valueIsValid()
     * @uses \EnumType\EquipmentStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $equipmentStatus
     * @return \StructType\EquipmentAvailabilityStructure
     */
    public function setEquipmentStatus($equipmentStatus = 'notAvailable')
    {
        // validation for constraint: enumeration
        if (!\EnumType\EquipmentStatusEnumeration::valueIsValid($equipmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $equipmentStatus, implode(', ', \EnumType\EquipmentStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->EquipmentStatus = $equipmentStatus;
        return $this;
    }
    /**
     * Get EquipmentFeatures value
     * @return \StructType\EquipmentFeatures|null
     */
    public function getEquipmentFeatures()
    {
        return $this->EquipmentFeatures;
    }
    /**
     * Set EquipmentFeatures value
     * @param \StructType\EquipmentFeatures $equipmentFeatures
     * @return \StructType\EquipmentAvailabilityStructure
     */
    public function setEquipmentFeatures(\StructType\EquipmentFeatures $equipmentFeatures = null)
    {
        $this->EquipmentFeatures = $equipmentFeatures;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\EquipmentAvailabilityStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EquipmentAvailabilityStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
