<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EasementsStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for easement info.
 * @subpackage Structs
 */
class EasementsStructure extends AbstractStructBase
{
    /**
     * The TicketRestrictions
     * Meta informations extracted from the WSDL
     * - documentation: Ticket restriction conditiosn in effect. TPEG pti table pti25.
     * - minOccurs: 0
     * @var string
     */
    public $TicketRestrictions;
    /**
     * The Easement
     * Meta informations extracted from the WSDL
     * - documentation: Description of fare exceptions allowed because of disruption. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Easement;
    /**
     * The EasementRef
     * Meta informations extracted from the WSDL
     * - documentation: Refernce to a fare exceptions code that is allowed because of the disruption. An easement may relax a fare condition, for exampel "You may use your metro ticket on the bus', or 'You may use your bus ticket in teh metro between these
     * two stops'.
     * - minOccurs: 0
     * @var string
     */
    public $EasementRef;
    /**
     * Constructor method for EasementsStructure
     * @uses EasementsStructure::setTicketRestrictions()
     * @uses EasementsStructure::setEasement()
     * @uses EasementsStructure::setEasementRef()
     * @param string $ticketRestrictions
     * @param \StructType\NaturalLanguageStringStructure[] $easement
     * @param string $easementRef
     */
    public function __construct($ticketRestrictions = null, array $easement = array(), $easementRef = null)
    {
        $this
            ->setTicketRestrictions($ticketRestrictions)
            ->setEasement($easement)
            ->setEasementRef($easementRef);
    }
    /**
     * Get TicketRestrictions value
     * @return string|null
     */
    public function getTicketRestrictions()
    {
        return $this->TicketRestrictions;
    }
    /**
     * Set TicketRestrictions value
     * @uses \EnumType\TicketRestrictionEnumeration::valueIsValid()
     * @uses \EnumType\TicketRestrictionEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketRestrictions
     * @return \StructType\EasementsStructure
     */
    public function setTicketRestrictions($ticketRestrictions = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TicketRestrictionEnumeration::valueIsValid($ticketRestrictions)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ticketRestrictions, implode(', ', \EnumType\TicketRestrictionEnumeration::getValidValues())), __LINE__);
        }
        $this->TicketRestrictions = $ticketRestrictions;
        return $this;
    }
    /**
     * Get Easement value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getEasement()
    {
        return $this->Easement;
    }
    /**
     * Set Easement value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $easement
     * @return \StructType\EasementsStructure
     */
    public function setEasement(array $easement = array())
    {
        foreach ($easement as $easementsStructureEasementItem) {
            // validation for constraint: itemType
            if (!$easementsStructureEasementItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Easement property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($easementsStructureEasementItem) ? get_class($easementsStructureEasementItem) : gettype($easementsStructureEasementItem)), __LINE__);
            }
        }
        $this->Easement = $easement;
        return $this;
    }
    /**
     * Add item to Easement value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\EasementsStructure
     */
    public function addToEasement(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Easement property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Easement[] = $item;
        return $this;
    }
    /**
     * Get EasementRef value
     * @return string|null
     */
    public function getEasementRef()
    {
        return $this->EasementRef;
    }
    /**
     * Set EasementRef value
     * @param string $easementRef
     * @return \StructType\EasementsStructure
     */
    public function setEasementRef($easementRef = null)
    {
        // validation for constraint: string
        if (!is_null($easementRef) && !is_string($easementRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($easementRef)), __LINE__);
        }
        $this->EasementRef = $easementRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EasementsStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
