<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Directions StructType
 * Meta informations extracted from the WSDL
 * - documentation: DIRECTIONs and Stops for the LINE. 'normal'
 * @subpackage Structs
 */
class Directions extends AbstractStructBase
{
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - documentation: Directions of Route
     * - maxOccurs: unbounded
     * @var \StructType\RouteDirectionStructure[]
     */
    public $Direction;
    /**
     * Constructor method for Directions
     * @uses Directions::setDirection()
     * @param \StructType\RouteDirectionStructure[] $direction
     */
    public function __construct(array $direction = array())
    {
        $this
            ->setDirection($direction);
    }
    /**
     * Get Direction value
     * @return \StructType\RouteDirectionStructure[]|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @throws \InvalidArgumentException
     * @param \StructType\RouteDirectionStructure[] $direction
     * @return \StructType\Directions
     */
    public function setDirection(array $direction = array())
    {
        foreach ($direction as $directionsDirectionItem) {
            // validation for constraint: itemType
            if (!$directionsDirectionItem instanceof \StructType\RouteDirectionStructure) {
                throw new \InvalidArgumentException(sprintf('The Direction property can only contain items of \StructType\RouteDirectionStructure, "%s" given', is_object($directionsDirectionItem) ? get_class($directionsDirectionItem) : gettype($directionsDirectionItem)), __LINE__);
            }
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Add item to Direction value
     * @throws \InvalidArgumentException
     * @param \StructType\RouteDirectionStructure $item
     * @return \StructType\Directions
     */
    public function addToDirection(\StructType\RouteDirectionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RouteDirectionStructure) {
            throw new \InvalidArgumentException(sprintf('The Direction property can only contain items of \StructType\RouteDirectionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Direction[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Directions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
