<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Destinations StructType
 * Meta informations extracted from the WSDL
 * - documentation: DESTINATIONs to which the LINE runs. Detail level is 'normal'
 * @subpackage Structs
 */
class Destinations extends AbstractStructBase
{
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: Destination
     * @var \StructType\AnnotatedDestinationStructure[]
     */
    public $Destination;
    /**
     * Constructor method for Destinations
     * @uses Destinations::setDestination()
     * @param \StructType\AnnotatedDestinationStructure[] $destination
     */
    public function __construct(array $destination = array())
    {
        $this
            ->setDestination($destination);
    }
    /**
     * Get Destination value
     * @return \StructType\AnnotatedDestinationStructure[]|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @throws \InvalidArgumentException
     * @param \StructType\AnnotatedDestinationStructure[] $destination
     * @return \StructType\Destinations
     */
    public function setDestination(array $destination = array())
    {
        foreach ($destination as $destinationsDestinationItem) {
            // validation for constraint: itemType
            if (!$destinationsDestinationItem instanceof \StructType\AnnotatedDestinationStructure) {
                throw new \InvalidArgumentException(sprintf('The Destination property can only contain items of \StructType\AnnotatedDestinationStructure, "%s" given', is_object($destinationsDestinationItem) ? get_class($destinationsDestinationItem) : gettype($destinationsDestinationItem)), __LINE__);
            }
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Add item to Destination value
     * @throws \InvalidArgumentException
     * @param \StructType\AnnotatedDestinationStructure $item
     * @return \StructType\Destinations
     */
    public function addToDestination(\StructType\AnnotatedDestinationStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnnotatedDestinationStructure) {
            throw new \InvalidArgumentException(sprintf('The Destination property can only contain items of \StructType\AnnotatedDestinationStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Destination[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Destinations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
