<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Information about a DESTINATION.
 * @subpackage Structs
 */
class DestinationStructure extends AbstractStructBase
{
    /**
     * The DestinationRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifer of Destinatioin
     * @var \StructType\DestinationRefStructure
     */
    public $DestinationRef;
    /**
     * The DestinationName
     * Meta informations extracted from the WSDL
     * - documentation: Name of Destination
     * - maxOccurs: unbounded
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $DestinationName;
    /**
     * Constructor method for DestinationStructure
     * @uses DestinationStructure::setDestinationRef()
     * @uses DestinationStructure::setDestinationName()
     * @param \StructType\DestinationRefStructure $destinationRef
     * @param \StructType\NaturalLanguageStringStructure[] $destinationName
     */
    public function __construct(\StructType\DestinationRefStructure $destinationRef = null, array $destinationName = array())
    {
        $this
            ->setDestinationRef($destinationRef)
            ->setDestinationName($destinationName);
    }
    /**
     * Get DestinationRef value
     * @return \StructType\DestinationRefStructure|null
     */
    public function getDestinationRef()
    {
        return $this->DestinationRef;
    }
    /**
     * Set DestinationRef value
     * @param \StructType\DestinationRefStructure $destinationRef
     * @return \StructType\DestinationStructure
     */
    public function setDestinationRef(\StructType\DestinationRefStructure $destinationRef = null)
    {
        $this->DestinationRef = $destinationRef;
        return $this;
    }
    /**
     * Get DestinationName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getDestinationName()
    {
        return $this->DestinationName;
    }
    /**
     * Set DestinationName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $destinationName
     * @return \StructType\DestinationStructure
     */
    public function setDestinationName(array $destinationName = array())
    {
        foreach ($destinationName as $destinationStructureDestinationNameItem) {
            // validation for constraint: itemType
            if (!$destinationStructureDestinationNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The DestinationName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($destinationStructureDestinationNameItem) ? get_class($destinationStructureDestinationNameItem) : gettype($destinationStructureDestinationNameItem)), __LINE__);
            }
        }
        $this->DestinationName = $destinationName;
        return $this;
    }
    /**
     * Add item to DestinationName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\DestinationStructure
     */
    public function addToDestinationName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The DestinationName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DestinationName[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DestinationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
