<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Delivery StructType
 * Meta informations extracted from the WSDL
 * - documentation: Delivery capabilities.
 * @subpackage Structs
 */
class Delivery extends AbstractStructBase
{
    /**
     * The DirectDelivery
     * Meta informations extracted from the WSDL
     * - documentation: Whether the service supports Direct delivery.
     * @var bool
     */
    public $DirectDelivery;
    /**
     * The FetchedDelivery
     * Meta informations extracted from the WSDL
     * - documentation: Whether the service supports Fetched delivery (VDV Style)
     * @var bool
     */
    public $FetchedDelivery;
    /**
     * Constructor method for Delivery
     * @uses Delivery::setDirectDelivery()
     * @uses Delivery::setFetchedDelivery()
     * @param bool $directDelivery
     * @param bool $fetchedDelivery
     */
    public function __construct($directDelivery = null, $fetchedDelivery = null)
    {
        $this
            ->setDirectDelivery($directDelivery)
            ->setFetchedDelivery($fetchedDelivery);
    }
    /**
     * Get DirectDelivery value
     * @return bool|null
     */
    public function getDirectDelivery()
    {
        return $this->DirectDelivery;
    }
    /**
     * Set DirectDelivery value
     * @param bool $directDelivery
     * @return \StructType\Delivery
     */
    public function setDirectDelivery($directDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($directDelivery) && !is_bool($directDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($directDelivery)), __LINE__);
        }
        $this->DirectDelivery = $directDelivery;
        return $this;
    }
    /**
     * Get FetchedDelivery value
     * @return bool|null
     */
    public function getFetchedDelivery()
    {
        return $this->FetchedDelivery;
    }
    /**
     * Set FetchedDelivery value
     * @param bool $fetchedDelivery
     * @return \StructType\Delivery
     */
    public function setFetchedDelivery($fetchedDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($fetchedDelivery) && !is_bool($fetchedDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fetchedDelivery)), __LINE__);
        }
        $this->FetchedDelivery = $fetchedDelivery;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Delivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
