<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DayWeekMonth StructType
 * @subpackage Structs
 */
class DayWeekMonth extends AbstractStructBase
{
    /**
     * The applicableDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var string[]
     */
    public $applicableDay;
    /**
     * The applicableWeek
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var string[]
     */
    public $applicableWeek;
    /**
     * The applicableMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 12
     * - minOccurs: 0
     * @var string[]
     */
    public $applicableMonth;
    /**
     * The dayWeekMonthExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $dayWeekMonthExtension;
    /**
     * Constructor method for DayWeekMonth
     * @uses DayWeekMonth::setApplicableDay()
     * @uses DayWeekMonth::setApplicableWeek()
     * @uses DayWeekMonth::setApplicableMonth()
     * @uses DayWeekMonth::setDayWeekMonthExtension()
     * @param string[] $applicableDay
     * @param string[] $applicableWeek
     * @param string[] $applicableMonth
     * @param \StructType\ExtensionType $dayWeekMonthExtension
     */
    public function __construct(array $applicableDay = array(), array $applicableWeek = array(), array $applicableMonth = array(), \StructType\ExtensionType $dayWeekMonthExtension = null)
    {
        $this
            ->setApplicableDay($applicableDay)
            ->setApplicableWeek($applicableWeek)
            ->setApplicableMonth($applicableMonth)
            ->setDayWeekMonthExtension($dayWeekMonthExtension);
    }
    /**
     * Get applicableDay value
     * @return string[]|null
     */
    public function getApplicableDay()
    {
        return $this->applicableDay;
    }
    /**
     * Set applicableDay value
     * @uses \EnumType\DayEnum::valueIsValid()
     * @uses \EnumType\DayEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $applicableDay
     * @return \StructType\DayWeekMonth
     */
    public function setApplicableDay(array $applicableDay = array())
    {
        $invalidValues = array();
        foreach ($applicableDay as $dayWeekMonthApplicableDayItem) {
            if (!\EnumType\DayEnum::valueIsValid($dayWeekMonthApplicableDayItem)) {
                $invalidValues[] = var_export($dayWeekMonthApplicableDayItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\DayEnum::getValidValues())), __LINE__);
        }
        $this->applicableDay = $applicableDay;
        return $this;
    }
    /**
     * Add item to applicableDay value
     * @uses \EnumType\DayEnum::valueIsValid()
     * @uses \EnumType\DayEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DayWeekMonth
     */
    public function addToApplicableDay($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\DayEnum::getValidValues())), __LINE__);
        }
        $this->applicableDay[] = $item;
        return $this;
    }
    /**
     * Get applicableWeek value
     * @return string[]|null
     */
    public function getApplicableWeek()
    {
        return $this->applicableWeek;
    }
    /**
     * Set applicableWeek value
     * @uses \EnumType\WeekOfMonthEnum::valueIsValid()
     * @uses \EnumType\WeekOfMonthEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $applicableWeek
     * @return \StructType\DayWeekMonth
     */
    public function setApplicableWeek(array $applicableWeek = array())
    {
        $invalidValues = array();
        foreach ($applicableWeek as $dayWeekMonthApplicableWeekItem) {
            if (!\EnumType\WeekOfMonthEnum::valueIsValid($dayWeekMonthApplicableWeekItem)) {
                $invalidValues[] = var_export($dayWeekMonthApplicableWeekItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\WeekOfMonthEnum::getValidValues())), __LINE__);
        }
        $this->applicableWeek = $applicableWeek;
        return $this;
    }
    /**
     * Add item to applicableWeek value
     * @uses \EnumType\WeekOfMonthEnum::valueIsValid()
     * @uses \EnumType\WeekOfMonthEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DayWeekMonth
     */
    public function addToApplicableWeek($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WeekOfMonthEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\WeekOfMonthEnum::getValidValues())), __LINE__);
        }
        $this->applicableWeek[] = $item;
        return $this;
    }
    /**
     * Get applicableMonth value
     * @return string[]|null
     */
    public function getApplicableMonth()
    {
        return $this->applicableMonth;
    }
    /**
     * Set applicableMonth value
     * @uses \EnumType\MonthOfYearEnum::valueIsValid()
     * @uses \EnumType\MonthOfYearEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $applicableMonth
     * @return \StructType\DayWeekMonth
     */
    public function setApplicableMonth(array $applicableMonth = array())
    {
        $invalidValues = array();
        foreach ($applicableMonth as $dayWeekMonthApplicableMonthItem) {
            if (!\EnumType\MonthOfYearEnum::valueIsValid($dayWeekMonthApplicableMonthItem)) {
                $invalidValues[] = var_export($dayWeekMonthApplicableMonthItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\MonthOfYearEnum::getValidValues())), __LINE__);
        }
        $this->applicableMonth = $applicableMonth;
        return $this;
    }
    /**
     * Add item to applicableMonth value
     * @uses \EnumType\MonthOfYearEnum::valueIsValid()
     * @uses \EnumType\MonthOfYearEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DayWeekMonth
     */
    public function addToApplicableMonth($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MonthOfYearEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\MonthOfYearEnum::getValidValues())), __LINE__);
        }
        $this->applicableMonth[] = $item;
        return $this;
    }
    /**
     * Get dayWeekMonthExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getDayWeekMonthExtension()
    {
        return $this->dayWeekMonthExtension;
    }
    /**
     * Set dayWeekMonthExtension value
     * @param \StructType\ExtensionType $dayWeekMonthExtension
     * @return \StructType\DayWeekMonth
     */
    public function setDayWeekMonthExtension(\StructType\ExtensionType $dayWeekMonthExtension = null)
    {
        $this->dayWeekMonthExtension = $dayWeekMonthExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DayWeekMonth
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
