<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedVehicleJourneyStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Planned VEHICLE JOURNEY (Production Timetable Service).
 * @subpackage Structs
 */
class DatedVehicleJourneyStructure extends AbstractStructBase
{
    /**
     * The DatedVehicleJourneyCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifier for a VEHICLE JOURNEY. | Type for identifier of a Dated VEHICLE JOURNEY.
     * - minOccurs: 0
     * @var string
     */
    public $DatedVehicleJourneyCode;
    /**
     * The FramedVehicleJourneyRef
     * @var \StructType\FramedVehicleJourneyRefStructure
     */
    public $FramedVehicleJourneyRef;
    /**
     * The VehicleJourneyRef
     * @var \StructType\VehicleJourneyRefStructure
     */
    public $VehicleJourneyRef;
    /**
     * The ExtraJourney
     * @var bool
     */
    public $ExtraJourney;
    /**
     * The Cancellation
     * @var bool
     */
    public $Cancellation;
    /**
     * The JourneyPatternRef
     * @var \StructType\JourneyPatternRefStructure
     */
    public $JourneyPatternRef;
    /**
     * The JourneyPatternName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $JourneyPatternName;
    /**
     * The VehicleMode
     * @var string
     */
    public $VehicleMode;
    /**
     * The RouteRef
     * @var \StructType\RouteRefStructure
     */
    public $RouteRef;
    /**
     * The PublishedLineName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $PublishedLineName;
    /**
     * The GroupOfLinesRef
     * @var \StructType\GroupOfLinesRefStructure
     */
    public $GroupOfLinesRef;
    /**
     * The DirectionName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DirectionName;
    /**
     * The ExternalLineRef
     * @var \StructType\LineRefStructure
     */
    public $ExternalLineRef;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The ProductCategoryRef
     * @var \StructType\ProductCategoryRefStructure
     */
    public $ProductCategoryRef;
    /**
     * The ServiceFeatureRef
     * @var \StructType\ServiceFeatureRefStructure
     */
    public $ServiceFeatureRef;
    /**
     * The VehicleFeatureRef
     * @var \StructType\VehicleFeatureRefStructure
     */
    public $VehicleFeatureRef;
    /**
     * The VehicleJourneyName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $VehicleJourneyName;
    /**
     * The JourneyNote
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $JourneyNote;
    /**
     * The PublicContact
     * @var \StructType\SimpleContactStructure
     */
    public $PublicContact;
    /**
     * The OperationsContact
     * @var \StructType\SimpleContactStructure
     */
    public $OperationsContact;
    /**
     * The OriginDisplay
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $OriginDisplay;
    /**
     * The DestinationDisplay
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DestinationDisplay;
    /**
     * The LineNote
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $LineNote;
    /**
     * The FirstOrLastJourney
     * @var string
     */
    public $FirstOrLastJourney;
    /**
     * The HeadwayService
     * @var bool
     */
    public $HeadwayService;
    /**
     * The Monitored
     * @var bool
     */
    public $Monitored;
    /**
     * The BlockRef
     * @var \StructType\BlockRefStructure
     */
    public $BlockRef;
    /**
     * The CourseOfJourneyRef
     * @var \StructType\CourseOfJourneyRefStructure
     */
    public $CourseOfJourneyRef;
    /**
     * The DatedCalls
     * @var \StructType\DatedCalls
     */
    public $DatedCalls;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for DatedVehicleJourneyStructure
     * @uses DatedVehicleJourneyStructure::setDatedVehicleJourneyCode()
     * @uses DatedVehicleJourneyStructure::setFramedVehicleJourneyRef()
     * @uses DatedVehicleJourneyStructure::setVehicleJourneyRef()
     * @uses DatedVehicleJourneyStructure::setExtraJourney()
     * @uses DatedVehicleJourneyStructure::setCancellation()
     * @uses DatedVehicleJourneyStructure::setJourneyPatternRef()
     * @uses DatedVehicleJourneyStructure::setJourneyPatternName()
     * @uses DatedVehicleJourneyStructure::setVehicleMode()
     * @uses DatedVehicleJourneyStructure::setRouteRef()
     * @uses DatedVehicleJourneyStructure::setPublishedLineName()
     * @uses DatedVehicleJourneyStructure::setGroupOfLinesRef()
     * @uses DatedVehicleJourneyStructure::setDirectionName()
     * @uses DatedVehicleJourneyStructure::setExternalLineRef()
     * @uses DatedVehicleJourneyStructure::setOperatorRef()
     * @uses DatedVehicleJourneyStructure::setProductCategoryRef()
     * @uses DatedVehicleJourneyStructure::setServiceFeatureRef()
     * @uses DatedVehicleJourneyStructure::setVehicleFeatureRef()
     * @uses DatedVehicleJourneyStructure::setVehicleJourneyName()
     * @uses DatedVehicleJourneyStructure::setJourneyNote()
     * @uses DatedVehicleJourneyStructure::setPublicContact()
     * @uses DatedVehicleJourneyStructure::setOperationsContact()
     * @uses DatedVehicleJourneyStructure::setOriginDisplay()
     * @uses DatedVehicleJourneyStructure::setDestinationDisplay()
     * @uses DatedVehicleJourneyStructure::setLineNote()
     * @uses DatedVehicleJourneyStructure::setFirstOrLastJourney()
     * @uses DatedVehicleJourneyStructure::setHeadwayService()
     * @uses DatedVehicleJourneyStructure::setMonitored()
     * @uses DatedVehicleJourneyStructure::setBlockRef()
     * @uses DatedVehicleJourneyStructure::setCourseOfJourneyRef()
     * @uses DatedVehicleJourneyStructure::setDatedCalls()
     * @uses DatedVehicleJourneyStructure::setExtensions()
     * @param string $datedVehicleJourneyCode
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @param \StructType\VehicleJourneyRefStructure $vehicleJourneyRef
     * @param bool $extraJourney
     * @param bool $cancellation
     * @param \StructType\JourneyPatternRefStructure $journeyPatternRef
     * @param \StructType\NaturalLanguageStringStructure $journeyPatternName
     * @param string $vehicleMode
     * @param \StructType\RouteRefStructure $routeRef
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @param \StructType\GroupOfLinesRefStructure $groupOfLinesRef
     * @param \StructType\NaturalLanguageStringStructure $directionName
     * @param \StructType\LineRefStructure $externalLineRef
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @param \StructType\NaturalLanguageStringStructure $vehicleJourneyName
     * @param \StructType\NaturalLanguageStringStructure $journeyNote
     * @param \StructType\SimpleContactStructure $publicContact
     * @param \StructType\SimpleContactStructure $operationsContact
     * @param \StructType\NaturalLanguageStringStructure $originDisplay
     * @param \StructType\NaturalLanguageStringStructure $destinationDisplay
     * @param \StructType\NaturalLanguagePlaceNameStructure $lineNote
     * @param string $firstOrLastJourney
     * @param bool $headwayService
     * @param bool $monitored
     * @param \StructType\BlockRefStructure $blockRef
     * @param \StructType\CourseOfJourneyRefStructure $courseOfJourneyRef
     * @param \StructType\DatedCalls $datedCalls
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($datedVehicleJourneyCode = null, \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null, \StructType\VehicleJourneyRefStructure $vehicleJourneyRef = null, $extraJourney = null, $cancellation = null, \StructType\JourneyPatternRefStructure $journeyPatternRef = null, \StructType\NaturalLanguageStringStructure $journeyPatternName = null, $vehicleMode = null, \StructType\RouteRefStructure $routeRef = null, \StructType\NaturalLanguageStringStructure $publishedLineName = null, \StructType\GroupOfLinesRefStructure $groupOfLinesRef = null, \StructType\NaturalLanguageStringStructure $directionName = null, \StructType\LineRefStructure $externalLineRef = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\ProductCategoryRefStructure $productCategoryRef = null, \StructType\ServiceFeatureRefStructure $serviceFeatureRef = null, \StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null, \StructType\NaturalLanguageStringStructure $vehicleJourneyName = null, \StructType\NaturalLanguageStringStructure $journeyNote = null, \StructType\SimpleContactStructure $publicContact = null, \StructType\SimpleContactStructure $operationsContact = null, \StructType\NaturalLanguageStringStructure $originDisplay = null, \StructType\NaturalLanguageStringStructure $destinationDisplay = null, \StructType\NaturalLanguagePlaceNameStructure $lineNote = null, $firstOrLastJourney = null, $headwayService = null, $monitored = null, \StructType\BlockRefStructure $blockRef = null, \StructType\CourseOfJourneyRefStructure $courseOfJourneyRef = null, \StructType\DatedCalls $datedCalls = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setDatedVehicleJourneyCode($datedVehicleJourneyCode)
            ->setFramedVehicleJourneyRef($framedVehicleJourneyRef)
            ->setVehicleJourneyRef($vehicleJourneyRef)
            ->setExtraJourney($extraJourney)
            ->setCancellation($cancellation)
            ->setJourneyPatternRef($journeyPatternRef)
            ->setJourneyPatternName($journeyPatternName)
            ->setVehicleMode($vehicleMode)
            ->setRouteRef($routeRef)
            ->setPublishedLineName($publishedLineName)
            ->setGroupOfLinesRef($groupOfLinesRef)
            ->setDirectionName($directionName)
            ->setExternalLineRef($externalLineRef)
            ->setOperatorRef($operatorRef)
            ->setProductCategoryRef($productCategoryRef)
            ->setServiceFeatureRef($serviceFeatureRef)
            ->setVehicleFeatureRef($vehicleFeatureRef)
            ->setVehicleJourneyName($vehicleJourneyName)
            ->setJourneyNote($journeyNote)
            ->setPublicContact($publicContact)
            ->setOperationsContact($operationsContact)
            ->setOriginDisplay($originDisplay)
            ->setDestinationDisplay($destinationDisplay)
            ->setLineNote($lineNote)
            ->setFirstOrLastJourney($firstOrLastJourney)
            ->setHeadwayService($headwayService)
            ->setMonitored($monitored)
            ->setBlockRef($blockRef)
            ->setCourseOfJourneyRef($courseOfJourneyRef)
            ->setDatedCalls($datedCalls)
            ->setExtensions($extensions);
    }
    /**
     * Get DatedVehicleJourneyCode value
     * @return string|null
     */
    public function getDatedVehicleJourneyCode()
    {
        return $this->DatedVehicleJourneyCode;
    }
    /**
     * Set DatedVehicleJourneyCode value
     * @param string $datedVehicleJourneyCode
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setDatedVehicleJourneyCode($datedVehicleJourneyCode = null)
    {
        // validation for constraint: string
        if (!is_null($datedVehicleJourneyCode) && !is_string($datedVehicleJourneyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datedVehicleJourneyCode)), __LINE__);
        }
        $this->DatedVehicleJourneyCode = $datedVehicleJourneyCode;
        return $this;
    }
    /**
     * Get FramedVehicleJourneyRef value
     * @return \StructType\FramedVehicleJourneyRefStructure|null
     */
    public function getFramedVehicleJourneyRef()
    {
        return $this->FramedVehicleJourneyRef;
    }
    /**
     * Set FramedVehicleJourneyRef value
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setFramedVehicleJourneyRef(\StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null)
    {
        $this->FramedVehicleJourneyRef = $framedVehicleJourneyRef;
        return $this;
    }
    /**
     * Get VehicleJourneyRef value
     * @return \StructType\VehicleJourneyRefStructure|null
     */
    public function getVehicleJourneyRef()
    {
        return $this->VehicleJourneyRef;
    }
    /**
     * Set VehicleJourneyRef value
     * @param \StructType\VehicleJourneyRefStructure $vehicleJourneyRef
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setVehicleJourneyRef(\StructType\VehicleJourneyRefStructure $vehicleJourneyRef = null)
    {
        $this->VehicleJourneyRef = $vehicleJourneyRef;
        return $this;
    }
    /**
     * Get ExtraJourney value
     * @return bool|null
     */
    public function getExtraJourney()
    {
        return $this->ExtraJourney;
    }
    /**
     * Set ExtraJourney value
     * @param bool $extraJourney
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setExtraJourney($extraJourney = null)
    {
        // validation for constraint: boolean
        if (!is_null($extraJourney) && !is_bool($extraJourney)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($extraJourney)), __LINE__);
        }
        $this->ExtraJourney = $extraJourney;
        return $this;
    }
    /**
     * Get Cancellation value
     * @return bool|null
     */
    public function getCancellation()
    {
        return $this->Cancellation;
    }
    /**
     * Set Cancellation value
     * @param bool $cancellation
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setCancellation($cancellation = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancellation) && !is_bool($cancellation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cancellation)), __LINE__);
        }
        $this->Cancellation = $cancellation;
        return $this;
    }
    /**
     * Get JourneyPatternRef value
     * @return \StructType\JourneyPatternRefStructure|null
     */
    public function getJourneyPatternRef()
    {
        return $this->JourneyPatternRef;
    }
    /**
     * Set JourneyPatternRef value
     * @param \StructType\JourneyPatternRefStructure $journeyPatternRef
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setJourneyPatternRef(\StructType\JourneyPatternRefStructure $journeyPatternRef = null)
    {
        $this->JourneyPatternRef = $journeyPatternRef;
        return $this;
    }
    /**
     * Get JourneyPatternName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getJourneyPatternName()
    {
        return $this->JourneyPatternName;
    }
    /**
     * Set JourneyPatternName value
     * @param \StructType\NaturalLanguageStringStructure $journeyPatternName
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setJourneyPatternName(\StructType\NaturalLanguageStringStructure $journeyPatternName = null)
    {
        $this->JourneyPatternName = $journeyPatternName;
        return $this;
    }
    /**
     * Get VehicleMode value
     * @return string|null
     */
    public function getVehicleMode()
    {
        return $this->VehicleMode;
    }
    /**
     * Set VehicleMode value
     * @uses \EnumType\VehicleModesEnumeration::valueIsValid()
     * @uses \EnumType\VehicleModesEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleMode
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setVehicleMode($vehicleMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleModesEnumeration::valueIsValid($vehicleMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleMode, implode(', ', \EnumType\VehicleModesEnumeration::getValidValues())), __LINE__);
        }
        $this->VehicleMode = $vehicleMode;
        return $this;
    }
    /**
     * Get RouteRef value
     * @return \StructType\RouteRefStructure|null
     */
    public function getRouteRef()
    {
        return $this->RouteRef;
    }
    /**
     * Set RouteRef value
     * @param \StructType\RouteRefStructure $routeRef
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setRouteRef(\StructType\RouteRefStructure $routeRef = null)
    {
        $this->RouteRef = $routeRef;
        return $this;
    }
    /**
     * Get PublishedLineName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getPublishedLineName()
    {
        return $this->PublishedLineName;
    }
    /**
     * Set PublishedLineName value
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setPublishedLineName(\StructType\NaturalLanguageStringStructure $publishedLineName = null)
    {
        $this->PublishedLineName = $publishedLineName;
        return $this;
    }
    /**
     * Get GroupOfLinesRef value
     * @return \StructType\GroupOfLinesRefStructure|null
     */
    public function getGroupOfLinesRef()
    {
        return $this->GroupOfLinesRef;
    }
    /**
     * Set GroupOfLinesRef value
     * @param \StructType\GroupOfLinesRefStructure $groupOfLinesRef
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setGroupOfLinesRef(\StructType\GroupOfLinesRefStructure $groupOfLinesRef = null)
    {
        $this->GroupOfLinesRef = $groupOfLinesRef;
        return $this;
    }
    /**
     * Get DirectionName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDirectionName()
    {
        return $this->DirectionName;
    }
    /**
     * Set DirectionName value
     * @param \StructType\NaturalLanguageStringStructure $directionName
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setDirectionName(\StructType\NaturalLanguageStringStructure $directionName = null)
    {
        $this->DirectionName = $directionName;
        return $this;
    }
    /**
     * Get ExternalLineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getExternalLineRef()
    {
        return $this->ExternalLineRef;
    }
    /**
     * Set ExternalLineRef value
     * @param \StructType\LineRefStructure $externalLineRef
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setExternalLineRef(\StructType\LineRefStructure $externalLineRef = null)
    {
        $this->ExternalLineRef = $externalLineRef;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get ProductCategoryRef value
     * @return \StructType\ProductCategoryRefStructure|null
     */
    public function getProductCategoryRef()
    {
        return $this->ProductCategoryRef;
    }
    /**
     * Set ProductCategoryRef value
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setProductCategoryRef(\StructType\ProductCategoryRefStructure $productCategoryRef = null)
    {
        $this->ProductCategoryRef = $productCategoryRef;
        return $this;
    }
    /**
     * Get ServiceFeatureRef value
     * @return \StructType\ServiceFeatureRefStructure|null
     */
    public function getServiceFeatureRef()
    {
        return $this->ServiceFeatureRef;
    }
    /**
     * Set ServiceFeatureRef value
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setServiceFeatureRef(\StructType\ServiceFeatureRefStructure $serviceFeatureRef = null)
    {
        $this->ServiceFeatureRef = $serviceFeatureRef;
        return $this;
    }
    /**
     * Get VehicleFeatureRef value
     * @return \StructType\VehicleFeatureRefStructure|null
     */
    public function getVehicleFeatureRef()
    {
        return $this->VehicleFeatureRef;
    }
    /**
     * Set VehicleFeatureRef value
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setVehicleFeatureRef(\StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null)
    {
        $this->VehicleFeatureRef = $vehicleFeatureRef;
        return $this;
    }
    /**
     * Get VehicleJourneyName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getVehicleJourneyName()
    {
        return $this->VehicleJourneyName;
    }
    /**
     * Set VehicleJourneyName value
     * @param \StructType\NaturalLanguageStringStructure $vehicleJourneyName
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setVehicleJourneyName(\StructType\NaturalLanguageStringStructure $vehicleJourneyName = null)
    {
        $this->VehicleJourneyName = $vehicleJourneyName;
        return $this;
    }
    /**
     * Get JourneyNote value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getJourneyNote()
    {
        return $this->JourneyNote;
    }
    /**
     * Set JourneyNote value
     * @param \StructType\NaturalLanguageStringStructure $journeyNote
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setJourneyNote(\StructType\NaturalLanguageStringStructure $journeyNote = null)
    {
        $this->JourneyNote = $journeyNote;
        return $this;
    }
    /**
     * Get PublicContact value
     * @return \StructType\SimpleContactStructure|null
     */
    public function getPublicContact()
    {
        return $this->PublicContact;
    }
    /**
     * Set PublicContact value
     * @param \StructType\SimpleContactStructure $publicContact
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setPublicContact(\StructType\SimpleContactStructure $publicContact = null)
    {
        $this->PublicContact = $publicContact;
        return $this;
    }
    /**
     * Get OperationsContact value
     * @return \StructType\SimpleContactStructure|null
     */
    public function getOperationsContact()
    {
        return $this->OperationsContact;
    }
    /**
     * Set OperationsContact value
     * @param \StructType\SimpleContactStructure $operationsContact
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setOperationsContact(\StructType\SimpleContactStructure $operationsContact = null)
    {
        $this->OperationsContact = $operationsContact;
        return $this;
    }
    /**
     * Get OriginDisplay value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getOriginDisplay()
    {
        return $this->OriginDisplay;
    }
    /**
     * Set OriginDisplay value
     * @param \StructType\NaturalLanguageStringStructure $originDisplay
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setOriginDisplay(\StructType\NaturalLanguageStringStructure $originDisplay = null)
    {
        $this->OriginDisplay = $originDisplay;
        return $this;
    }
    /**
     * Get DestinationDisplay value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDestinationDisplay()
    {
        return $this->DestinationDisplay;
    }
    /**
     * Set DestinationDisplay value
     * @param \StructType\NaturalLanguageStringStructure $destinationDisplay
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setDestinationDisplay(\StructType\NaturalLanguageStringStructure $destinationDisplay = null)
    {
        $this->DestinationDisplay = $destinationDisplay;
        return $this;
    }
    /**
     * Get LineNote value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getLineNote()
    {
        return $this->LineNote;
    }
    /**
     * Set LineNote value
     * @param \StructType\NaturalLanguagePlaceNameStructure $lineNote
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setLineNote(\StructType\NaturalLanguagePlaceNameStructure $lineNote = null)
    {
        $this->LineNote = $lineNote;
        return $this;
    }
    /**
     * Get FirstOrLastJourney value
     * @return string|null
     */
    public function getFirstOrLastJourney()
    {
        return $this->FirstOrLastJourney;
    }
    /**
     * Set FirstOrLastJourney value
     * @uses \EnumType\FirstOrLastJourneyEnumeration::valueIsValid()
     * @uses \EnumType\FirstOrLastJourneyEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firstOrLastJourney
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setFirstOrLastJourney($firstOrLastJourney = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FirstOrLastJourneyEnumeration::valueIsValid($firstOrLastJourney)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $firstOrLastJourney, implode(', ', \EnumType\FirstOrLastJourneyEnumeration::getValidValues())), __LINE__);
        }
        $this->FirstOrLastJourney = $firstOrLastJourney;
        return $this;
    }
    /**
     * Get HeadwayService value
     * @return bool|null
     */
    public function getHeadwayService()
    {
        return $this->HeadwayService;
    }
    /**
     * Set HeadwayService value
     * @param bool $headwayService
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setHeadwayService($headwayService = null)
    {
        // validation for constraint: boolean
        if (!is_null($headwayService) && !is_bool($headwayService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($headwayService)), __LINE__);
        }
        $this->HeadwayService = $headwayService;
        return $this;
    }
    /**
     * Get Monitored value
     * @return bool|null
     */
    public function getMonitored()
    {
        return $this->Monitored;
    }
    /**
     * Set Monitored value
     * @param bool $monitored
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setMonitored($monitored = null)
    {
        // validation for constraint: boolean
        if (!is_null($monitored) && !is_bool($monitored)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($monitored)), __LINE__);
        }
        $this->Monitored = $monitored;
        return $this;
    }
    /**
     * Get BlockRef value
     * @return \StructType\BlockRefStructure|null
     */
    public function getBlockRef()
    {
        return $this->BlockRef;
    }
    /**
     * Set BlockRef value
     * @param \StructType\BlockRefStructure $blockRef
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setBlockRef(\StructType\BlockRefStructure $blockRef = null)
    {
        $this->BlockRef = $blockRef;
        return $this;
    }
    /**
     * Get CourseOfJourneyRef value
     * @return \StructType\CourseOfJourneyRefStructure|null
     */
    public function getCourseOfJourneyRef()
    {
        return $this->CourseOfJourneyRef;
    }
    /**
     * Set CourseOfJourneyRef value
     * @param \StructType\CourseOfJourneyRefStructure $courseOfJourneyRef
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setCourseOfJourneyRef(\StructType\CourseOfJourneyRefStructure $courseOfJourneyRef = null)
    {
        $this->CourseOfJourneyRef = $courseOfJourneyRef;
        return $this;
    }
    /**
     * Get DatedCalls value
     * @return \StructType\DatedCalls|null
     */
    public function getDatedCalls()
    {
        return $this->DatedCalls;
    }
    /**
     * Set DatedCalls value
     * @param \StructType\DatedCalls $datedCalls
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setDatedCalls(\StructType\DatedCalls $datedCalls = null)
    {
        $this->DatedCalls = $datedCalls;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatedVehicleJourneyStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
