<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataReceivedResponseStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Data received Acknowledgement Response.
 * @subpackage Structs
 */
class DataReceivedResponseStructure extends ConsumerResponseEndpointStructure
{
    /**
     * The Status
     * @var bool
     */
    public $Status;
    /**
     * The ErrorCondition
     * @var \StructType\ErrorCondition
     */
    public $ErrorCondition;
    /**
     * Constructor method for DataReceivedResponseStructure
     * @uses DataReceivedResponseStructure::setStatus()
     * @uses DataReceivedResponseStructure::setErrorCondition()
     * @param bool $status
     * @param \StructType\ErrorCondition $errorCondition
     */
    public function __construct($status = null, \StructType\ErrorCondition $errorCondition = null)
    {
        $this
            ->setStatus($status)
            ->setErrorCondition($errorCondition);
    }
    /**
     * Get Status value
     * @return bool|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return \StructType\DataReceivedResponseStructure
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ErrorCondition value
     * @return \StructType\ErrorCondition|null
     */
    public function getErrorCondition()
    {
        return $this->ErrorCondition;
    }
    /**
     * Set ErrorCondition value
     * @param \StructType\ErrorCondition $errorCondition
     * @return \StructType\DataReceivedResponseStructure
     */
    public function setErrorCondition(\StructType\ErrorCondition $errorCondition = null)
    {
        $this->ErrorCondition = $errorCondition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataReceivedResponseStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
