<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataManagedObjectStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Abstract Type for DATA MANAGED OBJECT, that is an object that may be assigned a RESPONSIBILITY SET dictating a responsbile ORGANISATION and/or ADMINISTRATIVE ZONE.
 * @subpackage Structs
 */
abstract class DataManagedObjectStructure extends VersionedObjectStructure
{
    /**
     * The ManagedByAreaRef
     * @var \StructType\AdministrativeAreaRefStructure
     */
    public $ManagedByAreaRef;
    /**
     * The InfoLinks
     * @var \StructType\InfoLinksStructure
     */
    public $InfoLinks;
    /**
     * Constructor method for DataManagedObjectStructure
     * @uses DataManagedObjectStructure::setManagedByAreaRef()
     * @uses DataManagedObjectStructure::setInfoLinks()
     * @param \StructType\AdministrativeAreaRefStructure $managedByAreaRef
     * @param \StructType\InfoLinksStructure $infoLinks
     */
    public function __construct(\StructType\AdministrativeAreaRefStructure $managedByAreaRef = null, \StructType\InfoLinksStructure $infoLinks = null)
    {
        $this
            ->setManagedByAreaRef($managedByAreaRef)
            ->setInfoLinks($infoLinks);
    }
    /**
     * Get ManagedByAreaRef value
     * @return \StructType\AdministrativeAreaRefStructure|null
     */
    public function getManagedByAreaRef()
    {
        return $this->ManagedByAreaRef;
    }
    /**
     * Set ManagedByAreaRef value
     * @param \StructType\AdministrativeAreaRefStructure $managedByAreaRef
     * @return \StructType\DataManagedObjectStructure
     */
    public function setManagedByAreaRef(\StructType\AdministrativeAreaRefStructure $managedByAreaRef = null)
    {
        $this->ManagedByAreaRef = $managedByAreaRef;
        return $this;
    }
    /**
     * Get InfoLinks value
     * @return \StructType\InfoLinksStructure|null
     */
    public function getInfoLinks()
    {
        return $this->InfoLinks;
    }
    /**
     * Set InfoLinks value
     * @param \StructType\InfoLinksStructure $infoLinks
     * @return \StructType\DataManagedObjectStructure
     */
    public function setInfoLinks(\StructType\InfoLinksStructure $infoLinks = null)
    {
        $this->InfoLinks = $infoLinks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataManagedObjectStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
