<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContextStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Common parameters for all SITUATIONs.
 * @subpackage Structs
 */
class ContextStructure extends AbstractStructBase
{
    /**
     * The CountryRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a Country of a Participant who published SITUATION.
     * - minOccurs: 0
     * @var \StructType\CountryRefStructure
     */
    public $CountryRef;
    /**
     * The ParticipantRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a system publishing SITUATIONs. If SITUATIONs from other participants are included in delivery, then ParticipantRef of immediate publisher must be given here.
     * @var \StructType\ParticipantRefStructure
     */
    public $ParticipantRef;
    /**
     * The TopographicPlaceRef
     * Meta informations extracted from the WSDL
     * - documentation: Refrence to a TOPOGRAPHIC PLACE (locality). Also Derivable from an individual StopRef.
     * - minOccurs: 0
     * @var string
     */
    public $TopographicPlaceRef;
    /**
     * The TopographicPlaceName
     * Meta informations extracted from the WSDL
     * - documentation: Name of locality in which SITUATIONs apply. Derivable from LocalityRef. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $TopographicPlaceName;
    /**
     * The DefaultLanguage
     * Meta informations extracted from the WSDL
     * - documentation: Default language of text.
     * - minOccurs: 0
     * @var string
     */
    public $DefaultLanguage;
    /**
     * The NetworkContext
     * Meta informations extracted from the WSDL
     * - documentation: Default context for common properties of Public Transport SITUATIONs.
     * - minOccurs: 0
     * @var \StructType\NetworkContextStructure
     */
    public $NetworkContext;
    /**
     * The Actions
     * Meta informations extracted from the WSDL
     * - documentation: Actions that apply to all SITUATIONs unless overridden.
     * - minOccurs: 0
     * @var \StructType\ActionsStructure
     */
    public $Actions;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for ContextStructure
     * @uses ContextStructure::setCountryRef()
     * @uses ContextStructure::setParticipantRef()
     * @uses ContextStructure::setTopographicPlaceRef()
     * @uses ContextStructure::setTopographicPlaceName()
     * @uses ContextStructure::setDefaultLanguage()
     * @uses ContextStructure::setNetworkContext()
     * @uses ContextStructure::setActions()
     * @uses ContextStructure::setExtensions()
     * @param \StructType\CountryRefStructure $countryRef
     * @param \StructType\ParticipantRefStructure $participantRef
     * @param string $topographicPlaceRef
     * @param \StructType\NaturalLanguageStringStructure[] $topographicPlaceName
     * @param string $defaultLanguage
     * @param \StructType\NetworkContextStructure $networkContext
     * @param \StructType\ActionsStructure $actions
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\CountryRefStructure $countryRef = null, \StructType\ParticipantRefStructure $participantRef = null, $topographicPlaceRef = null, array $topographicPlaceName = array(), $defaultLanguage = null, \StructType\NetworkContextStructure $networkContext = null, \StructType\ActionsStructure $actions = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setCountryRef($countryRef)
            ->setParticipantRef($participantRef)
            ->setTopographicPlaceRef($topographicPlaceRef)
            ->setTopographicPlaceName($topographicPlaceName)
            ->setDefaultLanguage($defaultLanguage)
            ->setNetworkContext($networkContext)
            ->setActions($actions)
            ->setExtensions($extensions);
    }
    /**
     * Get CountryRef value
     * @return \StructType\CountryRefStructure|null
     */
    public function getCountryRef()
    {
        return $this->CountryRef;
    }
    /**
     * Set CountryRef value
     * @param \StructType\CountryRefStructure $countryRef
     * @return \StructType\ContextStructure
     */
    public function setCountryRef(\StructType\CountryRefStructure $countryRef = null)
    {
        $this->CountryRef = $countryRef;
        return $this;
    }
    /**
     * Get ParticipantRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getParticipantRef()
    {
        return $this->ParticipantRef;
    }
    /**
     * Set ParticipantRef value
     * @param \StructType\ParticipantRefStructure $participantRef
     * @return \StructType\ContextStructure
     */
    public function setParticipantRef(\StructType\ParticipantRefStructure $participantRef = null)
    {
        $this->ParticipantRef = $participantRef;
        return $this;
    }
    /**
     * Get TopographicPlaceRef value
     * @return string|null
     */
    public function getTopographicPlaceRef()
    {
        return $this->TopographicPlaceRef;
    }
    /**
     * Set TopographicPlaceRef value
     * @param string $topographicPlaceRef
     * @return \StructType\ContextStructure
     */
    public function setTopographicPlaceRef($topographicPlaceRef = null)
    {
        // validation for constraint: string
        if (!is_null($topographicPlaceRef) && !is_string($topographicPlaceRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($topographicPlaceRef)), __LINE__);
        }
        $this->TopographicPlaceRef = $topographicPlaceRef;
        return $this;
    }
    /**
     * Get TopographicPlaceName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getTopographicPlaceName()
    {
        return $this->TopographicPlaceName;
    }
    /**
     * Set TopographicPlaceName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $topographicPlaceName
     * @return \StructType\ContextStructure
     */
    public function setTopographicPlaceName(array $topographicPlaceName = array())
    {
        foreach ($topographicPlaceName as $contextStructureTopographicPlaceNameItem) {
            // validation for constraint: itemType
            if (!$contextStructureTopographicPlaceNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The TopographicPlaceName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($contextStructureTopographicPlaceNameItem) ? get_class($contextStructureTopographicPlaceNameItem) : gettype($contextStructureTopographicPlaceNameItem)), __LINE__);
            }
        }
        $this->TopographicPlaceName = $topographicPlaceName;
        return $this;
    }
    /**
     * Add item to TopographicPlaceName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\ContextStructure
     */
    public function addToTopographicPlaceName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The TopographicPlaceName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TopographicPlaceName[] = $item;
        return $this;
    }
    /**
     * Get DefaultLanguage value
     * @return string|null
     */
    public function getDefaultLanguage()
    {
        return $this->DefaultLanguage;
    }
    /**
     * Set DefaultLanguage value
     * @param string $defaultLanguage
     * @return \StructType\ContextStructure
     */
    public function setDefaultLanguage($defaultLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($defaultLanguage) && !is_string($defaultLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultLanguage)), __LINE__);
        }
        $this->DefaultLanguage = $defaultLanguage;
        return $this;
    }
    /**
     * Get NetworkContext value
     * @return \StructType\NetworkContextStructure|null
     */
    public function getNetworkContext()
    {
        return $this->NetworkContext;
    }
    /**
     * Set NetworkContext value
     * @param \StructType\NetworkContextStructure $networkContext
     * @return \StructType\ContextStructure
     */
    public function setNetworkContext(\StructType\NetworkContextStructure $networkContext = null)
    {
        $this->NetworkContext = $networkContext;
        return $this;
    }
    /**
     * Get Actions value
     * @return \StructType\ActionsStructure|null
     */
    public function getActions()
    {
        return $this->Actions;
    }
    /**
     * Set Actions value
     * @param \StructType\ActionsStructure $actions
     * @return \StructType\ContextStructure
     */
    public function setActions(\StructType\ActionsStructure $actions = null)
    {
        $this->Actions = $actions;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ContextStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContextStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
