<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConstructionWorks StructType
 * @subpackage Structs
 */
class ConstructionWorks extends Roadworks
{
    /**
     * The constructionWorkType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $constructionWorkType;
    /**
     * The constructionWorksExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $constructionWorksExtension;
    /**
     * Constructor method for ConstructionWorks
     * @uses ConstructionWorks::setConstructionWorkType()
     * @uses ConstructionWorks::setConstructionWorksExtension()
     * @param string $constructionWorkType
     * @param \StructType\ExtensionType $constructionWorksExtension
     */
    public function __construct($constructionWorkType = null, \StructType\ExtensionType $constructionWorksExtension = null)
    {
        $this
            ->setConstructionWorkType($constructionWorkType)
            ->setConstructionWorksExtension($constructionWorksExtension);
    }
    /**
     * Get constructionWorkType value
     * @return string|null
     */
    public function getConstructionWorkType()
    {
        return $this->constructionWorkType;
    }
    /**
     * Set constructionWorkType value
     * @uses \EnumType\ConstructionWorkTypeEnum::valueIsValid()
     * @uses \EnumType\ConstructionWorkTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $constructionWorkType
     * @return \StructType\ConstructionWorks
     */
    public function setConstructionWorkType($constructionWorkType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConstructionWorkTypeEnum::valueIsValid($constructionWorkType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $constructionWorkType, implode(', ', \EnumType\ConstructionWorkTypeEnum::getValidValues())), __LINE__);
        }
        $this->constructionWorkType = $constructionWorkType;
        return $this;
    }
    /**
     * Get constructionWorksExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getConstructionWorksExtension()
    {
        return $this->constructionWorksExtension;
    }
    /**
     * Set constructionWorksExtension value
     * @param \StructType\ExtensionType $constructionWorksExtension
     * @return \StructType\ConstructionWorks
     */
    public function setConstructionWorksExtension(\StructType\ExtensionType $constructionWorksExtension = null)
    {
        $this->constructionWorksExtension = $constructionWorksExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConstructionWorks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
