<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionMonitoringRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Request Connection Monitoring Service.
 * @subpackage Structs
 */
class ConnectionMonitoringRequestStructure extends AbstractFunctionalServiceRequestStructure
{
    /**
     * The PreviewInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $PreviewInterval;
    /**
     * The ConnectionLinkRef
     * @var \StructType\ConnectionLinkRefStructure
     */
    public $ConnectionLinkRef;
    /**
     * The ConnectingTimeFilter
     * @var \StructType\ConnectingTimeFilterStructure
     */
    public $ConnectingTimeFilter;
    /**
     * The ConnectingJourneyFilter
     * @var \StructType\ConnectingJourneyFilterStructure
     */
    public $ConnectingJourneyFilter;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The IncludeTranslations
     * @var bool
     */
    public $IncludeTranslations;
    /**
     * The ConnectionMonitoringDetailLevel
     * @var string
     */
    public $ConnectionMonitoringDetailLevel;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for ConnectionMonitoringRequestStructure
     * @uses ConnectionMonitoringRequestStructure::setPreviewInterval()
     * @uses ConnectionMonitoringRequestStructure::setConnectionLinkRef()
     * @uses ConnectionMonitoringRequestStructure::setConnectingTimeFilter()
     * @uses ConnectionMonitoringRequestStructure::setConnectingJourneyFilter()
     * @uses ConnectionMonitoringRequestStructure::setLanguage()
     * @uses ConnectionMonitoringRequestStructure::setIncludeTranslations()
     * @uses ConnectionMonitoringRequestStructure::setConnectionMonitoringDetailLevel()
     * @uses ConnectionMonitoringRequestStructure::setExtensions()
     * @uses ConnectionMonitoringRequestStructure::setVersion()
     * @param string $previewInterval
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @param \StructType\ConnectingTimeFilterStructure $connectingTimeFilter
     * @param \StructType\ConnectingJourneyFilterStructure $connectingJourneyFilter
     * @param string $language
     * @param bool $includeTranslations
     * @param string $connectionMonitoringDetailLevel
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct($previewInterval = null, \StructType\ConnectionLinkRefStructure $connectionLinkRef = null, \StructType\ConnectingTimeFilterStructure $connectingTimeFilter = null, \StructType\ConnectingJourneyFilterStructure $connectingJourneyFilter = null, $language = null, $includeTranslations = null, $connectionMonitoringDetailLevel = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setPreviewInterval($previewInterval)
            ->setConnectionLinkRef($connectionLinkRef)
            ->setConnectingTimeFilter($connectingTimeFilter)
            ->setConnectingJourneyFilter($connectingJourneyFilter)
            ->setLanguage($language)
            ->setIncludeTranslations($includeTranslations)
            ->setConnectionMonitoringDetailLevel($connectionMonitoringDetailLevel)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get PreviewInterval value
     * @return string|null
     */
    public function getPreviewInterval()
    {
        return $this->PreviewInterval;
    }
    /**
     * Set PreviewInterval value
     * @param string $previewInterval
     * @return \StructType\ConnectionMonitoringRequestStructure
     */
    public function setPreviewInterval($previewInterval = null)
    {
        // validation for constraint: string
        if (!is_null($previewInterval) && !is_string($previewInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($previewInterval)), __LINE__);
        }
        $this->PreviewInterval = $previewInterval;
        return $this;
    }
    /**
     * Get ConnectionLinkRef value
     * @return \StructType\ConnectionLinkRefStructure|null
     */
    public function getConnectionLinkRef()
    {
        return $this->ConnectionLinkRef;
    }
    /**
     * Set ConnectionLinkRef value
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @return \StructType\ConnectionMonitoringRequestStructure
     */
    public function setConnectionLinkRef(\StructType\ConnectionLinkRefStructure $connectionLinkRef = null)
    {
        $this->ConnectionLinkRef = $connectionLinkRef;
        return $this;
    }
    /**
     * Get ConnectingTimeFilter value
     * @return \StructType\ConnectingTimeFilterStructure|null
     */
    public function getConnectingTimeFilter()
    {
        return $this->ConnectingTimeFilter;
    }
    /**
     * Set ConnectingTimeFilter value
     * @param \StructType\ConnectingTimeFilterStructure $connectingTimeFilter
     * @return \StructType\ConnectionMonitoringRequestStructure
     */
    public function setConnectingTimeFilter(\StructType\ConnectingTimeFilterStructure $connectingTimeFilter = null)
    {
        $this->ConnectingTimeFilter = $connectingTimeFilter;
        return $this;
    }
    /**
     * Get ConnectingJourneyFilter value
     * @return \StructType\ConnectingJourneyFilterStructure|null
     */
    public function getConnectingJourneyFilter()
    {
        return $this->ConnectingJourneyFilter;
    }
    /**
     * Set ConnectingJourneyFilter value
     * @param \StructType\ConnectingJourneyFilterStructure $connectingJourneyFilter
     * @return \StructType\ConnectionMonitoringRequestStructure
     */
    public function setConnectingJourneyFilter(\StructType\ConnectingJourneyFilterStructure $connectingJourneyFilter = null)
    {
        $this->ConnectingJourneyFilter = $connectingJourneyFilter;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\ConnectionMonitoringRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get IncludeTranslations value
     * @return bool|null
     */
    public function getIncludeTranslations()
    {
        return $this->IncludeTranslations;
    }
    /**
     * Set IncludeTranslations value
     * @param bool $includeTranslations
     * @return \StructType\ConnectionMonitoringRequestStructure
     */
    public function setIncludeTranslations($includeTranslations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTranslations) && !is_bool($includeTranslations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTranslations)), __LINE__);
        }
        $this->IncludeTranslations = $includeTranslations;
        return $this;
    }
    /**
     * Get ConnectionMonitoringDetailLevel value
     * @return string|null
     */
    public function getConnectionMonitoringDetailLevel()
    {
        return $this->ConnectionMonitoringDetailLevel;
    }
    /**
     * Set ConnectionMonitoringDetailLevel value
     * @uses \EnumType\ConnectionMonitoringDetailEnumeration::valueIsValid()
     * @uses \EnumType\ConnectionMonitoringDetailEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectionMonitoringDetailLevel
     * @return \StructType\ConnectionMonitoringRequestStructure
     */
    public function setConnectionMonitoringDetailLevel($connectionMonitoringDetailLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConnectionMonitoringDetailEnumeration::valueIsValid($connectionMonitoringDetailLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectionMonitoringDetailLevel, implode(', ', \EnumType\ConnectionMonitoringDetailEnumeration::getValidValues())), __LINE__);
        }
        $this->ConnectionMonitoringDetailLevel = $connectionMonitoringDetailLevel;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ConnectionMonitoringRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\ConnectionMonitoringRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionMonitoringRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
