<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionMonitoringFeederDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Delivery for Connection Monitoring.
 * @subpackage Structs
 */
class ConnectionMonitoringFeederDeliveryStructure extends AbstractServiceDeliveryStructure
{
    /**
     * The MonitoredFeederArrival
     * @var \StructType\MonitoredFeederArrivalStructure
     */
    public $MonitoredFeederArrival;
    /**
     * The MonitoredFeederArrivalCancellation
     * @var \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public $MonitoredFeederArrivalCancellation;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for ConnectionMonitoringFeederDeliveryStructure
     * @uses ConnectionMonitoringFeederDeliveryStructure::setMonitoredFeederArrival()
     * @uses ConnectionMonitoringFeederDeliveryStructure::setMonitoredFeederArrivalCancellation()
     * @uses ConnectionMonitoringFeederDeliveryStructure::setExtensions()
     * @uses ConnectionMonitoringFeederDeliveryStructure::setVersion()
     * @param \StructType\MonitoredFeederArrivalStructure $monitoredFeederArrival
     * @param \StructType\MonitoredFeederArrivalCancellationStructure $monitoredFeederArrivalCancellation
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\MonitoredFeederArrivalStructure $monitoredFeederArrival = null, \StructType\MonitoredFeederArrivalCancellationStructure $monitoredFeederArrivalCancellation = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setMonitoredFeederArrival($monitoredFeederArrival)
            ->setMonitoredFeederArrivalCancellation($monitoredFeederArrivalCancellation)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get MonitoredFeederArrival value
     * @return \StructType\MonitoredFeederArrivalStructure|null
     */
    public function getMonitoredFeederArrival()
    {
        return $this->MonitoredFeederArrival;
    }
    /**
     * Set MonitoredFeederArrival value
     * @param \StructType\MonitoredFeederArrivalStructure $monitoredFeederArrival
     * @return \StructType\ConnectionMonitoringFeederDeliveryStructure
     */
    public function setMonitoredFeederArrival(\StructType\MonitoredFeederArrivalStructure $monitoredFeederArrival = null)
    {
        $this->MonitoredFeederArrival = $monitoredFeederArrival;
        return $this;
    }
    /**
     * Get MonitoredFeederArrivalCancellation value
     * @return \StructType\MonitoredFeederArrivalCancellationStructure|null
     */
    public function getMonitoredFeederArrivalCancellation()
    {
        return $this->MonitoredFeederArrivalCancellation;
    }
    /**
     * Set MonitoredFeederArrivalCancellation value
     * @param \StructType\MonitoredFeederArrivalCancellationStructure $monitoredFeederArrivalCancellation
     * @return \StructType\ConnectionMonitoringFeederDeliveryStructure
     */
    public function setMonitoredFeederArrivalCancellation(\StructType\MonitoredFeederArrivalCancellationStructure $monitoredFeederArrivalCancellation = null)
    {
        $this->MonitoredFeederArrivalCancellation = $monitoredFeederArrivalCancellation;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ConnectionMonitoringFeederDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\ConnectionMonitoringFeederDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionMonitoringFeederDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
