<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionMonitoringDistributorDeliveryStructure
 * StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Distributor Delivery for Connection Monitoring Service.
 * @subpackage Structs
 */
class ConnectionMonitoringDistributorDeliveryStructure extends AbstractServiceDeliveryStructure
{
    /**
     * The WaitProlongedDeparture
     * @var \StructType\WaitProlongedDepartureStructure
     */
    public $WaitProlongedDeparture;
    /**
     * The StoppingPositionChangedDeparture
     * @var \StructType\StoppingPositionChangedDepartureStructure
     */
    public $StoppingPositionChangedDeparture;
    /**
     * The DistributorDepartureCancellation
     * @var \StructType\DistributorDepartureCancellationStructure
     */
    public $DistributorDepartureCancellation;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for ConnectionMonitoringDistributorDeliveryStructure
     * @uses ConnectionMonitoringDistributorDeliveryStructure::setWaitProlongedDeparture()
     * @uses ConnectionMonitoringDistributorDeliveryStructure::setStoppingPositionChangedDeparture()
     * @uses ConnectionMonitoringDistributorDeliveryStructure::setDistributorDepartureCancellation()
     * @uses ConnectionMonitoringDistributorDeliveryStructure::setExtensions()
     * @uses ConnectionMonitoringDistributorDeliveryStructure::setVersion()
     * @param \StructType\WaitProlongedDepartureStructure $waitProlongedDeparture
     * @param \StructType\StoppingPositionChangedDepartureStructure $stoppingPositionChangedDeparture
     * @param \StructType\DistributorDepartureCancellationStructure $distributorDepartureCancellation
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\WaitProlongedDepartureStructure $waitProlongedDeparture = null, \StructType\StoppingPositionChangedDepartureStructure $stoppingPositionChangedDeparture = null, \StructType\DistributorDepartureCancellationStructure $distributorDepartureCancellation = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setWaitProlongedDeparture($waitProlongedDeparture)
            ->setStoppingPositionChangedDeparture($stoppingPositionChangedDeparture)
            ->setDistributorDepartureCancellation($distributorDepartureCancellation)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get WaitProlongedDeparture value
     * @return \StructType\WaitProlongedDepartureStructure|null
     */
    public function getWaitProlongedDeparture()
    {
        return $this->WaitProlongedDeparture;
    }
    /**
     * Set WaitProlongedDeparture value
     * @param \StructType\WaitProlongedDepartureStructure $waitProlongedDeparture
     * @return \StructType\ConnectionMonitoringDistributorDeliveryStructure
     */
    public function setWaitProlongedDeparture(\StructType\WaitProlongedDepartureStructure $waitProlongedDeparture = null)
    {
        $this->WaitProlongedDeparture = $waitProlongedDeparture;
        return $this;
    }
    /**
     * Get StoppingPositionChangedDeparture value
     * @return \StructType\StoppingPositionChangedDepartureStructure|null
     */
    public function getStoppingPositionChangedDeparture()
    {
        return $this->StoppingPositionChangedDeparture;
    }
    /**
     * Set StoppingPositionChangedDeparture value
     * @param \StructType\StoppingPositionChangedDepartureStructure $stoppingPositionChangedDeparture
     * @return \StructType\ConnectionMonitoringDistributorDeliveryStructure
     */
    public function setStoppingPositionChangedDeparture(\StructType\StoppingPositionChangedDepartureStructure $stoppingPositionChangedDeparture = null)
    {
        $this->StoppingPositionChangedDeparture = $stoppingPositionChangedDeparture;
        return $this;
    }
    /**
     * Get DistributorDepartureCancellation value
     * @return \StructType\DistributorDepartureCancellationStructure|null
     */
    public function getDistributorDepartureCancellation()
    {
        return $this->DistributorDepartureCancellation;
    }
    /**
     * Set DistributorDepartureCancellation value
     * @param \StructType\DistributorDepartureCancellationStructure $distributorDepartureCancellation
     * @return \StructType\ConnectionMonitoringDistributorDeliveryStructure
     */
    public function setDistributorDepartureCancellation(\StructType\DistributorDepartureCancellationStructure $distributorDepartureCancellation = null)
    {
        $this->DistributorDepartureCancellation = $distributorDepartureCancellation;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ConnectionMonitoringDistributorDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\ConnectionMonitoringDistributorDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionMonitoringDistributorDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
