<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionLinksDiscoveryRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Requests for CONNECTION LINK data for use in service requests. +SIRI v2.0
 * @subpackage Structs
 */
class ConnectionLinksDiscoveryRequestStructure extends AbstractDiscoveryRequestStructure
{
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - documentation: Version number of request. Fixed | A string indicating the versioin of a SIRI data structure.
     * - fixed: 2.0
     * - use: required
     * @var string
     */
    public $version;
    /**
     * The BoundingBox
     * @var \StructType\BoundingBoxStructure
     */
    public $BoundingBox;
    /**
     * The Circle
     * @var \StructType\LocationStructure
     */
    public $Circle;
    /**
     * The PlaceRef
     * @var string
     */
    public $PlaceRef;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The ConnectionLinksDetailLevel
     * @var string
     */
    public $ConnectionLinksDetailLevel;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for ConnectionLinksDiscoveryRequestStructure
     * @uses ConnectionLinksDiscoveryRequestStructure::setVersion()
     * @uses ConnectionLinksDiscoveryRequestStructure::setBoundingBox()
     * @uses ConnectionLinksDiscoveryRequestStructure::setCircle()
     * @uses ConnectionLinksDiscoveryRequestStructure::setPlaceRef()
     * @uses ConnectionLinksDiscoveryRequestStructure::setLineRef()
     * @uses ConnectionLinksDiscoveryRequestStructure::setOperatorRef()
     * @uses ConnectionLinksDiscoveryRequestStructure::setLanguage()
     * @uses ConnectionLinksDiscoveryRequestStructure::setConnectionLinksDetailLevel()
     * @uses ConnectionLinksDiscoveryRequestStructure::setExtensions()
     * @param string $version
     * @param \StructType\BoundingBoxStructure $boundingBox
     * @param \StructType\LocationStructure $circle
     * @param string $placeRef
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param string $language
     * @param string $connectionLinksDetailLevel
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($version = null, \StructType\BoundingBoxStructure $boundingBox = null, \StructType\LocationStructure $circle = null, $placeRef = null, \StructType\LineRefStructure $lineRef = null, \StructType\OperatorRefStructure $operatorRef = null, $language = null, $connectionLinksDetailLevel = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setVersion($version)
            ->setBoundingBox($boundingBox)
            ->setCircle($circle)
            ->setPlaceRef($placeRef)
            ->setLineRef($lineRef)
            ->setOperatorRef($operatorRef)
            ->setLanguage($language)
            ->setConnectionLinksDetailLevel($connectionLinksDetailLevel)
            ->setExtensions($extensions);
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\ConnectionLinksDiscoveryRequestStructure
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get BoundingBox value
     * @return \StructType\BoundingBoxStructure|null
     */
    public function getBoundingBox()
    {
        return $this->BoundingBox;
    }
    /**
     * Set BoundingBox value
     * @param \StructType\BoundingBoxStructure $boundingBox
     * @return \StructType\ConnectionLinksDiscoveryRequestStructure
     */
    public function setBoundingBox(\StructType\BoundingBoxStructure $boundingBox = null)
    {
        $this->BoundingBox = $boundingBox;
        return $this;
    }
    /**
     * Get Circle value
     * @return \StructType\LocationStructure|null
     */
    public function getCircle()
    {
        return $this->Circle;
    }
    /**
     * Set Circle value
     * @param \StructType\LocationStructure $circle
     * @return \StructType\ConnectionLinksDiscoveryRequestStructure
     */
    public function setCircle(\StructType\LocationStructure $circle = null)
    {
        $this->Circle = $circle;
        return $this;
    }
    /**
     * Get PlaceRef value
     * @return string|null
     */
    public function getPlaceRef()
    {
        return $this->PlaceRef;
    }
    /**
     * Set PlaceRef value
     * @param string $placeRef
     * @return \StructType\ConnectionLinksDiscoveryRequestStructure
     */
    public function setPlaceRef($placeRef = null)
    {
        // validation for constraint: string
        if (!is_null($placeRef) && !is_string($placeRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeRef)), __LINE__);
        }
        $this->PlaceRef = $placeRef;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\ConnectionLinksDiscoveryRequestStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\ConnectionLinksDiscoveryRequestStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\ConnectionLinksDiscoveryRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get ConnectionLinksDetailLevel value
     * @return string|null
     */
    public function getConnectionLinksDetailLevel()
    {
        return $this->ConnectionLinksDetailLevel;
    }
    /**
     * Set ConnectionLinksDetailLevel value
     * @uses \EnumType\ConnectionLinksDetailEnumeration::valueIsValid()
     * @uses \EnumType\ConnectionLinksDetailEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectionLinksDetailLevel
     * @return \StructType\ConnectionLinksDiscoveryRequestStructure
     */
    public function setConnectionLinksDetailLevel($connectionLinksDetailLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConnectionLinksDetailEnumeration::valueIsValid($connectionLinksDetailLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectionLinksDetailLevel, implode(', ', \EnumType\ConnectionLinksDetailEnumeration::getValidValues())), __LINE__);
        }
        $this->ConnectionLinksDetailLevel = $connectionLinksDetailLevel;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ConnectionLinksDiscoveryRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionLinksDiscoveryRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
