<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionLinkPermissions StructType
 * Meta informations extracted from the WSDL
 * - documentation: The CONNECTION links that the participant may access.
 * @subpackage Structs
 */
class ConnectionLinkPermissions extends AbstractStructBase
{
    /**
     * The AllowAll
     * Meta informations extracted from the WSDL
     * - ref: AllowAll
     * @var bool
     */
    public $AllowAll;
    /**
     * The ConnectionLinkPermission
     * Meta informations extracted from the WSDL
     * - documentation: Participant's permission for this CONNECTION link.
     * - maxOccurs: unbounded
     * @var \StructType\ConnectionLinkPermissionStructure[]
     */
    public $ConnectionLinkPermission;
    /**
     * Constructor method for ConnectionLinkPermissions
     * @uses ConnectionLinkPermissions::setAllowAll()
     * @uses ConnectionLinkPermissions::setConnectionLinkPermission()
     * @param bool $allowAll
     * @param \StructType\ConnectionLinkPermissionStructure[] $connectionLinkPermission
     */
    public function __construct($allowAll = null, array $connectionLinkPermission = array())
    {
        $this
            ->setAllowAll($allowAll)
            ->setConnectionLinkPermission($connectionLinkPermission);
    }
    /**
     * Get AllowAll value
     * @return bool|null
     */
    public function getAllowAll()
    {
        return $this->AllowAll;
    }
    /**
     * Set AllowAll value
     * @param bool $allowAll
     * @return \StructType\ConnectionLinkPermissions
     */
    public function setAllowAll($allowAll = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAll) && !is_bool($allowAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowAll)), __LINE__);
        }
        $this->AllowAll = $allowAll;
        return $this;
    }
    /**
     * Get ConnectionLinkPermission value
     * @return \StructType\ConnectionLinkPermissionStructure[]|null
     */
    public function getConnectionLinkPermission()
    {
        return $this->ConnectionLinkPermission;
    }
    /**
     * Set ConnectionLinkPermission value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionLinkPermissionStructure[] $connectionLinkPermission
     * @return \StructType\ConnectionLinkPermissions
     */
    public function setConnectionLinkPermission(array $connectionLinkPermission = array())
    {
        foreach ($connectionLinkPermission as $connectionLinkPermissionsConnectionLinkPermissionItem) {
            // validation for constraint: itemType
            if (!$connectionLinkPermissionsConnectionLinkPermissionItem instanceof \StructType\ConnectionLinkPermissionStructure) {
                throw new \InvalidArgumentException(sprintf('The ConnectionLinkPermission property can only contain items of \StructType\ConnectionLinkPermissionStructure, "%s" given', is_object($connectionLinkPermissionsConnectionLinkPermissionItem) ? get_class($connectionLinkPermissionsConnectionLinkPermissionItem) : gettype($connectionLinkPermissionsConnectionLinkPermissionItem)), __LINE__);
            }
        }
        $this->ConnectionLinkPermission = $connectionLinkPermission;
        return $this;
    }
    /**
     * Add item to ConnectionLinkPermission value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionLinkPermissionStructure $item
     * @return \StructType\ConnectionLinkPermissions
     */
    public function addToConnectionLinkPermission(\StructType\ConnectionLinkPermissionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConnectionLinkPermissionStructure) {
            throw new \InvalidArgumentException(sprintf('The ConnectionLinkPermission property can only contain items of \StructType\ConnectionLinkPermissionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ConnectionLinkPermission[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionLinkPermissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
