<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionCapabilityAccessControlStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Abstract type for capability access control. | If access control is supported, whether access control by CONNECTION LINK is supported. Default is 'true'.
 * @subpackage Structs
 */
class ConnectionCapabilityAccessControlStructure extends CapabilityAccessControlStructure
{
    /**
     * The CheckOperatorRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: CheckOperatorRef
     * @var bool
     */
    public $CheckOperatorRef;
    /**
     * The CheckLineRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: CheckLineRef
     * @var bool
     */
    public $CheckLineRef;
    /**
     * The CheckConnectionLinkRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: CheckConnectionLinkRef
     * @var bool
     */
    public $CheckConnectionLinkRef;
    /**
     * Constructor method for ConnectionCapabilityAccessControlStructure
     * @uses ConnectionCapabilityAccessControlStructure::setCheckOperatorRef()
     * @uses ConnectionCapabilityAccessControlStructure::setCheckLineRef()
     * @uses ConnectionCapabilityAccessControlStructure::setCheckConnectionLinkRef()
     * @param bool $checkOperatorRef
     * @param bool $checkLineRef
     * @param bool $checkConnectionLinkRef
     */
    public function __construct($checkOperatorRef = null, $checkLineRef = null, $checkConnectionLinkRef = null)
    {
        $this
            ->setCheckOperatorRef($checkOperatorRef)
            ->setCheckLineRef($checkLineRef)
            ->setCheckConnectionLinkRef($checkConnectionLinkRef);
    }
    /**
     * Get CheckOperatorRef value
     * @return bool|null
     */
    public function getCheckOperatorRef()
    {
        return $this->CheckOperatorRef;
    }
    /**
     * Set CheckOperatorRef value
     * @param bool $checkOperatorRef
     * @return \StructType\ConnectionCapabilityAccessControlStructure
     */
    public function setCheckOperatorRef($checkOperatorRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkOperatorRef) && !is_bool($checkOperatorRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($checkOperatorRef)), __LINE__);
        }
        $this->CheckOperatorRef = $checkOperatorRef;
        return $this;
    }
    /**
     * Get CheckLineRef value
     * @return bool|null
     */
    public function getCheckLineRef()
    {
        return $this->CheckLineRef;
    }
    /**
     * Set CheckLineRef value
     * @param bool $checkLineRef
     * @return \StructType\ConnectionCapabilityAccessControlStructure
     */
    public function setCheckLineRef($checkLineRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkLineRef) && !is_bool($checkLineRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($checkLineRef)), __LINE__);
        }
        $this->CheckLineRef = $checkLineRef;
        return $this;
    }
    /**
     * Get CheckConnectionLinkRef value
     * @return bool|null
     */
    public function getCheckConnectionLinkRef()
    {
        return $this->CheckConnectionLinkRef;
    }
    /**
     * Set CheckConnectionLinkRef value
     * @param bool $checkConnectionLinkRef
     * @return \StructType\ConnectionCapabilityAccessControlStructure
     */
    public function setCheckConnectionLinkRef($checkConnectionLinkRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkConnectionLinkRef) && !is_bool($checkConnectionLinkRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($checkConnectionLinkRef)), __LINE__);
        }
        $this->CheckConnectionLinkRef = $checkConnectionLinkRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionCapabilityAccessControlStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
