<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectingTimeFilterStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for time filter for connecting journeys.
 * @subpackage Structs
 */
class ConnectingTimeFilterStructure extends AbstractStructBase
{
    /**
     * The LineRef
     * Meta informations extracted from the WSDL
     * - documentation: Feeder LINE for which data is to be supplied.
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The DirectionRef
     * Meta informations extracted from the WSDL
     * - documentation: Feeder for which data is to be supplied.
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The EarliestArrivalTime
     * Meta informations extracted from the WSDL
     * - documentation: Earliest managed arrival time at the connection point.
     * - minOccurs: 0
     * @var string
     */
    public $EarliestArrivalTime;
    /**
     * The LatestArrivalTime
     * Meta informations extracted from the WSDL
     * - documentation: Latest managedarrival time at the connection point.
     * - minOccurs: 0
     * @var string
     */
    public $LatestArrivalTime;
    /**
     * Constructor method for ConnectingTimeFilterStructure
     * @uses ConnectingTimeFilterStructure::setLineRef()
     * @uses ConnectingTimeFilterStructure::setDirectionRef()
     * @uses ConnectingTimeFilterStructure::setEarliestArrivalTime()
     * @uses ConnectingTimeFilterStructure::setLatestArrivalTime()
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\DirectionRefStructure $directionRef
     * @param string $earliestArrivalTime
     * @param string $latestArrivalTime
     */
    public function __construct(\StructType\LineRefStructure $lineRef = null, \StructType\DirectionRefStructure $directionRef = null, $earliestArrivalTime = null, $latestArrivalTime = null)
    {
        $this
            ->setLineRef($lineRef)
            ->setDirectionRef($directionRef)
            ->setEarliestArrivalTime($earliestArrivalTime)
            ->setLatestArrivalTime($latestArrivalTime);
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\ConnectingTimeFilterStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\ConnectingTimeFilterStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get EarliestArrivalTime value
     * @return string|null
     */
    public function getEarliestArrivalTime()
    {
        return $this->EarliestArrivalTime;
    }
    /**
     * Set EarliestArrivalTime value
     * @param string $earliestArrivalTime
     * @return \StructType\ConnectingTimeFilterStructure
     */
    public function setEarliestArrivalTime($earliestArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($earliestArrivalTime) && !is_string($earliestArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($earliestArrivalTime)), __LINE__);
        }
        $this->EarliestArrivalTime = $earliestArrivalTime;
        return $this;
    }
    /**
     * Get LatestArrivalTime value
     * @return string|null
     */
    public function getLatestArrivalTime()
    {
        return $this->LatestArrivalTime;
    }
    /**
     * Set LatestArrivalTime value
     * @param string $latestArrivalTime
     * @return \StructType\ConnectingTimeFilterStructure
     */
    public function setLatestArrivalTime($latestArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($latestArrivalTime) && !is_string($latestArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($latestArrivalTime)), __LINE__);
        }
        $this->LatestArrivalTime = $latestArrivalTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectingTimeFilterStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
