<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectingJourneyRefStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a reference to a connecting journey.
 * @subpackage Structs
 */
class ConnectingJourneyRefStructure extends AbstractStructBase
{
    /**
     * The FramedVehicleJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: A reference to the DATE VEHICLE JOURNEY that the VEHICLE is making, unique with the data horizon of the service.
     * - minOccurs: 0
     * @var \StructType\FramedVehicleJourneyRefStructure
     */
    public $FramedVehicleJourneyRef;
    /**
     * The LineRef
     * Meta informations extracted from the WSDL
     * - documentation: LINE Reference.
     * - minOccurs: 0
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The ParticipantRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParticipantRefStructure
     */
    public $ParticipantRef;
    /**
     * Constructor method for ConnectingJourneyRefStructure
     * @uses ConnectingJourneyRefStructure::setFramedVehicleJourneyRef()
     * @uses ConnectingJourneyRefStructure::setLineRef()
     * @uses ConnectingJourneyRefStructure::setParticipantRef()
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\ParticipantRefStructure $participantRef
     */
    public function __construct(\StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null, \StructType\LineRefStructure $lineRef = null, \StructType\ParticipantRefStructure $participantRef = null)
    {
        $this
            ->setFramedVehicleJourneyRef($framedVehicleJourneyRef)
            ->setLineRef($lineRef)
            ->setParticipantRef($participantRef);
    }
    /**
     * Get FramedVehicleJourneyRef value
     * @return \StructType\FramedVehicleJourneyRefStructure|null
     */
    public function getFramedVehicleJourneyRef()
    {
        return $this->FramedVehicleJourneyRef;
    }
    /**
     * Set FramedVehicleJourneyRef value
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @return \StructType\ConnectingJourneyRefStructure
     */
    public function setFramedVehicleJourneyRef(\StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null)
    {
        $this->FramedVehicleJourneyRef = $framedVehicleJourneyRef;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\ConnectingJourneyRefStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get ParticipantRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getParticipantRef()
    {
        return $this->ParticipantRef;
    }
    /**
     * Set ParticipantRef value
     * @param \StructType\ParticipantRefStructure $participantRef
     * @return \StructType\ConnectingJourneyRefStructure
     */
    public function setParticipantRef(\StructType\ParticipantRefStructure $participantRef = null)
    {
        $this->ParticipantRef = $participantRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectingJourneyRefStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
