<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectingJourneyFilterStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for filter for connecting journeys.
 * @subpackage Structs
 */
class ConnectingJourneyFilterStructure extends AbstractStructBase
{
    /**
     * The DatedVehicleJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: A reference to a dated VEHICLE JOURNEY. | Type for identifier of a Dated VEHICLE JOURNEY.
     * @var string
     */
    public $DatedVehicleJourneyRef;
    /**
     * The VisitNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: VisitNumber
     * - documentation: Type for Stop Visit.
     * @var int
     */
    public $VisitNumber;
    /**
     * The TimetabledArrivalTime
     * Meta informations extracted from the WSDL
     * - documentation: Timetabled arrival time at the connection point.
     * @var string
     */
    public $TimetabledArrivalTime;
    /**
     * Constructor method for ConnectingJourneyFilterStructure
     * @uses ConnectingJourneyFilterStructure::setDatedVehicleJourneyRef()
     * @uses ConnectingJourneyFilterStructure::setVisitNumber()
     * @uses ConnectingJourneyFilterStructure::setTimetabledArrivalTime()
     * @param string $datedVehicleJourneyRef
     * @param int $visitNumber
     * @param string $timetabledArrivalTime
     */
    public function __construct($datedVehicleJourneyRef = null, $visitNumber = null, $timetabledArrivalTime = null)
    {
        $this
            ->setDatedVehicleJourneyRef($datedVehicleJourneyRef)
            ->setVisitNumber($visitNumber)
            ->setTimetabledArrivalTime($timetabledArrivalTime);
    }
    /**
     * Get DatedVehicleJourneyRef value
     * @return string|null
     */
    public function getDatedVehicleJourneyRef()
    {
        return $this->DatedVehicleJourneyRef;
    }
    /**
     * Set DatedVehicleJourneyRef value
     * @param string $datedVehicleJourneyRef
     * @return \StructType\ConnectingJourneyFilterStructure
     */
    public function setDatedVehicleJourneyRef($datedVehicleJourneyRef = null)
    {
        // validation for constraint: string
        if (!is_null($datedVehicleJourneyRef) && !is_string($datedVehicleJourneyRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datedVehicleJourneyRef)), __LINE__);
        }
        $this->DatedVehicleJourneyRef = $datedVehicleJourneyRef;
        return $this;
    }
    /**
     * Get VisitNumber value
     * @return int|null
     */
    public function getVisitNumber()
    {
        return $this->VisitNumber;
    }
    /**
     * Set VisitNumber value
     * @param int $visitNumber
     * @return \StructType\ConnectingJourneyFilterStructure
     */
    public function setVisitNumber($visitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($visitNumber) && !is_numeric($visitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($visitNumber)), __LINE__);
        }
        $this->VisitNumber = $visitNumber;
        return $this;
    }
    /**
     * Get TimetabledArrivalTime value
     * @return string|null
     */
    public function getTimetabledArrivalTime()
    {
        return $this->TimetabledArrivalTime;
    }
    /**
     * Set TimetabledArrivalTime value
     * @param string $timetabledArrivalTime
     * @return \StructType\ConnectingJourneyFilterStructure
     */
    public function setTimetabledArrivalTime($timetabledArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($timetabledArrivalTime) && !is_string($timetabledArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timetabledArrivalTime)), __LINE__);
        }
        $this->TimetabledArrivalTime = $timetabledArrivalTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectingJourneyFilterStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
