<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckStatusResponseBodyStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Body of Service Status Check Response. Used in WSDL. | Same as CheckStatusResponseStructure, but without extension to be consistent with the other operation definition.
 * @subpackage Structs
 */
class CheckStatusResponseBodyStructure extends AbstractStructBase
{
    /**
     * The Status
     * @var bool
     */
    public $Status;
    /**
     * The DataReady
     * @var bool
     */
    public $DataReady;
    /**
     * The ErrorCondition
     * @var \StructType\ErrorCondition
     */
    public $ErrorCondition;
    /**
     * The ValidUntil
     * @var string
     */
    public $ValidUntil;
    /**
     * The ShortestPossibleCycle
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $ShortestPossibleCycle;
    /**
     * The ServiceStartedTime
     * @var string
     */
    public $ServiceStartedTime;
    /**
     * Constructor method for CheckStatusResponseBodyStructure
     * @uses CheckStatusResponseBodyStructure::setStatus()
     * @uses CheckStatusResponseBodyStructure::setDataReady()
     * @uses CheckStatusResponseBodyStructure::setErrorCondition()
     * @uses CheckStatusResponseBodyStructure::setValidUntil()
     * @uses CheckStatusResponseBodyStructure::setShortestPossibleCycle()
     * @uses CheckStatusResponseBodyStructure::setServiceStartedTime()
     * @param bool $status
     * @param bool $dataReady
     * @param \StructType\ErrorCondition $errorCondition
     * @param string $validUntil
     * @param string $shortestPossibleCycle
     * @param string $serviceStartedTime
     */
    public function __construct($status = null, $dataReady = null, \StructType\ErrorCondition $errorCondition = null, $validUntil = null, $shortestPossibleCycle = null, $serviceStartedTime = null)
    {
        $this
            ->setStatus($status)
            ->setDataReady($dataReady)
            ->setErrorCondition($errorCondition)
            ->setValidUntil($validUntil)
            ->setShortestPossibleCycle($shortestPossibleCycle)
            ->setServiceStartedTime($serviceStartedTime);
    }
    /**
     * Get Status value
     * @return bool|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return \StructType\CheckStatusResponseBodyStructure
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get DataReady value
     * @return bool|null
     */
    public function getDataReady()
    {
        return $this->DataReady;
    }
    /**
     * Set DataReady value
     * @param bool $dataReady
     * @return \StructType\CheckStatusResponseBodyStructure
     */
    public function setDataReady($dataReady = null)
    {
        // validation for constraint: boolean
        if (!is_null($dataReady) && !is_bool($dataReady)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dataReady)), __LINE__);
        }
        $this->DataReady = $dataReady;
        return $this;
    }
    /**
     * Get ErrorCondition value
     * @return \StructType\ErrorCondition|null
     */
    public function getErrorCondition()
    {
        return $this->ErrorCondition;
    }
    /**
     * Set ErrorCondition value
     * @param \StructType\ErrorCondition $errorCondition
     * @return \StructType\CheckStatusResponseBodyStructure
     */
    public function setErrorCondition(\StructType\ErrorCondition $errorCondition = null)
    {
        $this->ErrorCondition = $errorCondition;
        return $this;
    }
    /**
     * Get ValidUntil value
     * @return string|null
     */
    public function getValidUntil()
    {
        return $this->ValidUntil;
    }
    /**
     * Set ValidUntil value
     * @param string $validUntil
     * @return \StructType\CheckStatusResponseBodyStructure
     */
    public function setValidUntil($validUntil = null)
    {
        // validation for constraint: string
        if (!is_null($validUntil) && !is_string($validUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validUntil)), __LINE__);
        }
        $this->ValidUntil = $validUntil;
        return $this;
    }
    /**
     * Get ShortestPossibleCycle value
     * @return string|null
     */
    public function getShortestPossibleCycle()
    {
        return $this->ShortestPossibleCycle;
    }
    /**
     * Set ShortestPossibleCycle value
     * @param string $shortestPossibleCycle
     * @return \StructType\CheckStatusResponseBodyStructure
     */
    public function setShortestPossibleCycle($shortestPossibleCycle = null)
    {
        // validation for constraint: string
        if (!is_null($shortestPossibleCycle) && !is_string($shortestPossibleCycle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortestPossibleCycle)), __LINE__);
        }
        $this->ShortestPossibleCycle = $shortestPossibleCycle;
        return $this;
    }
    /**
     * Get ServiceStartedTime value
     * @return string|null
     */
    public function getServiceStartedTime()
    {
        return $this->ServiceStartedTime;
    }
    /**
     * Set ServiceStartedTime value
     * @param string $serviceStartedTime
     * @return \StructType\CheckStatusResponseBodyStructure
     */
    public function setServiceStartedTime($serviceStartedTime = null)
    {
        // validation for constraint: string
        if (!is_null($serviceStartedTime) && !is_string($serviceStartedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceStartedTime)), __LINE__);
        }
        $this->ServiceStartedTime = $serviceStartedTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckStatusResponseBodyStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
