<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckStatusRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for check status request.
 * @subpackage Structs
 */
class CheckStatusRequestStructure extends RequestStructure
{
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for CheckStatusRequestStructure
     * @uses CheckStatusRequestStructure::setExtensions()
     * @uses CheckStatusRequestStructure::setVersion()
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\CheckStatusRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\CheckStatusRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckStatusRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
