<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CasualtiesStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Information on casualties.
 * @subpackage Structs
 */
class CasualtiesStructure extends AbstractStructBase
{
    /**
     * The NumberOfDeaths
     * Meta informations extracted from the WSDL
     * - documentation: Number of fatalities.
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfDeaths;
    /**
     * The NumberOfInjured
     * Meta informations extracted from the WSDL
     * - documentation: Number of injured presons.
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfInjured;
    /**
     * Constructor method for CasualtiesStructure
     * @uses CasualtiesStructure::setNumberOfDeaths()
     * @uses CasualtiesStructure::setNumberOfInjured()
     * @param int $numberOfDeaths
     * @param int $numberOfInjured
     */
    public function __construct($numberOfDeaths = null, $numberOfInjured = null)
    {
        $this
            ->setNumberOfDeaths($numberOfDeaths)
            ->setNumberOfInjured($numberOfInjured);
    }
    /**
     * Get NumberOfDeaths value
     * @return int|null
     */
    public function getNumberOfDeaths()
    {
        return $this->NumberOfDeaths;
    }
    /**
     * Set NumberOfDeaths value
     * @param int $numberOfDeaths
     * @return \StructType\CasualtiesStructure
     */
    public function setNumberOfDeaths($numberOfDeaths = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDeaths) && !is_numeric($numberOfDeaths)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfDeaths)), __LINE__);
        }
        $this->NumberOfDeaths = $numberOfDeaths;
        return $this;
    }
    /**
     * Get NumberOfInjured value
     * @return int|null
     */
    public function getNumberOfInjured()
    {
        return $this->NumberOfInjured;
    }
    /**
     * Set NumberOfInjured value
     * @param int $numberOfInjured
     * @return \StructType\CasualtiesStructure
     */
    public function setNumberOfInjured($numberOfInjured = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInjured) && !is_numeric($numberOfInjured)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfInjured)), __LINE__);
        }
        $this->NumberOfInjured = $numberOfInjured;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CasualtiesStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
