<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CapabilityGeneralInteractionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Common Request Policy capabilities.
 * @subpackage Structs
 */
class CapabilityGeneralInteractionStructure extends AbstractStructBase
{
    /**
     * The Interaction
     * @var \StructType\Interaction
     */
    public $Interaction;
    /**
     * The Delivery
     * @var \StructType\Delivery
     */
    public $Delivery;
    /**
     * The MultipartDespatch
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether the service supports multiple part despatch with MoreData flag. Default is 'true'.
     * @var bool
     */
    public $MultipartDespatch;
    /**
     * The MultipleSubscriberFilter
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether the service supports multiple Subscriber Filters. Default is ' false'.
     * @var bool
     */
    public $MultipleSubscriberFilter;
    /**
     * The HasConfirmDelivery
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether the service supports Delivery confirm.
     * @var bool
     */
    public $HasConfirmDelivery;
    /**
     * The HasHeartbeat
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether the service has a heartbeat message. Default is 'false'.
     * @var bool
     */
    public $HasHeartbeat;
    /**
     * The VisitNumberisOrder
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether VisitNumber can be used as a strict order number within JOURNEY PATTERN. Default is 'false'.
     * - minOccurs: 0
     * @var bool
     */
    public $VisitNumberisOrder;
    /**
     * Constructor method for CapabilityGeneralInteractionStructure
     * @uses CapabilityGeneralInteractionStructure::setInteraction()
     * @uses CapabilityGeneralInteractionStructure::setDelivery()
     * @uses CapabilityGeneralInteractionStructure::setMultipartDespatch()
     * @uses CapabilityGeneralInteractionStructure::setMultipleSubscriberFilter()
     * @uses CapabilityGeneralInteractionStructure::setHasConfirmDelivery()
     * @uses CapabilityGeneralInteractionStructure::setHasHeartbeat()
     * @uses CapabilityGeneralInteractionStructure::setVisitNumberisOrder()
     * @param \StructType\Interaction $interaction
     * @param \StructType\Delivery $delivery
     * @param bool $multipartDespatch
     * @param bool $multipleSubscriberFilter
     * @param bool $hasConfirmDelivery
     * @param bool $hasHeartbeat
     * @param bool $visitNumberisOrder
     */
    public function __construct(\StructType\Interaction $interaction = null, \StructType\Delivery $delivery = null, $multipartDespatch = true, $multipleSubscriberFilter = false, $hasConfirmDelivery = false, $hasHeartbeat = false, $visitNumberisOrder = false)
    {
        $this
            ->setInteraction($interaction)
            ->setDelivery($delivery)
            ->setMultipartDespatch($multipartDespatch)
            ->setMultipleSubscriberFilter($multipleSubscriberFilter)
            ->setHasConfirmDelivery($hasConfirmDelivery)
            ->setHasHeartbeat($hasHeartbeat)
            ->setVisitNumberisOrder($visitNumberisOrder);
    }
    /**
     * Get Interaction value
     * @return \StructType\Interaction|null
     */
    public function getInteraction()
    {
        return $this->Interaction;
    }
    /**
     * Set Interaction value
     * @param \StructType\Interaction $interaction
     * @return \StructType\CapabilityGeneralInteractionStructure
     */
    public function setInteraction(\StructType\Interaction $interaction = null)
    {
        $this->Interaction = $interaction;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \StructType\Delivery|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \StructType\Delivery $delivery
     * @return \StructType\CapabilityGeneralInteractionStructure
     */
    public function setDelivery(\StructType\Delivery $delivery = null)
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get MultipartDespatch value
     * @return bool|null
     */
    public function getMultipartDespatch()
    {
        return $this->MultipartDespatch;
    }
    /**
     * Set MultipartDespatch value
     * @param bool $multipartDespatch
     * @return \StructType\CapabilityGeneralInteractionStructure
     */
    public function setMultipartDespatch($multipartDespatch = true)
    {
        // validation for constraint: boolean
        if (!is_null($multipartDespatch) && !is_bool($multipartDespatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($multipartDespatch)), __LINE__);
        }
        $this->MultipartDespatch = $multipartDespatch;
        return $this;
    }
    /**
     * Get MultipleSubscriberFilter value
     * @return bool|null
     */
    public function getMultipleSubscriberFilter()
    {
        return $this->MultipleSubscriberFilter;
    }
    /**
     * Set MultipleSubscriberFilter value
     * @param bool $multipleSubscriberFilter
     * @return \StructType\CapabilityGeneralInteractionStructure
     */
    public function setMultipleSubscriberFilter($multipleSubscriberFilter = false)
    {
        // validation for constraint: boolean
        if (!is_null($multipleSubscriberFilter) && !is_bool($multipleSubscriberFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($multipleSubscriberFilter)), __LINE__);
        }
        $this->MultipleSubscriberFilter = $multipleSubscriberFilter;
        return $this;
    }
    /**
     * Get HasConfirmDelivery value
     * @return bool|null
     */
    public function getHasConfirmDelivery()
    {
        return $this->HasConfirmDelivery;
    }
    /**
     * Set HasConfirmDelivery value
     * @param bool $hasConfirmDelivery
     * @return \StructType\CapabilityGeneralInteractionStructure
     */
    public function setHasConfirmDelivery($hasConfirmDelivery = false)
    {
        // validation for constraint: boolean
        if (!is_null($hasConfirmDelivery) && !is_bool($hasConfirmDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasConfirmDelivery)), __LINE__);
        }
        $this->HasConfirmDelivery = $hasConfirmDelivery;
        return $this;
    }
    /**
     * Get HasHeartbeat value
     * @return bool|null
     */
    public function getHasHeartbeat()
    {
        return $this->HasHeartbeat;
    }
    /**
     * Set HasHeartbeat value
     * @param bool $hasHeartbeat
     * @return \StructType\CapabilityGeneralInteractionStructure
     */
    public function setHasHeartbeat($hasHeartbeat = false)
    {
        // validation for constraint: boolean
        if (!is_null($hasHeartbeat) && !is_bool($hasHeartbeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasHeartbeat)), __LINE__);
        }
        $this->HasHeartbeat = $hasHeartbeat;
        return $this;
    }
    /**
     * Get VisitNumberisOrder value
     * @return bool|null
     */
    public function getVisitNumberisOrder()
    {
        return $this->VisitNumberisOrder;
    }
    /**
     * Set VisitNumberisOrder value
     * @param bool $visitNumberisOrder
     * @return \StructType\CapabilityGeneralInteractionStructure
     */
    public function setVisitNumberisOrder($visitNumberisOrder = false)
    {
        // validation for constraint: boolean
        if (!is_null($visitNumberisOrder) && !is_bool($visitNumberisOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($visitNumberisOrder)), __LINE__);
        }
        $this->VisitNumberisOrder = $visitNumberisOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CapabilityGeneralInteractionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
