<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CapabilitiesRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Requests for capabilities of the current system. | If request has been proxied by an intermediate aggregting system, trackng informattion relating to the original requestor. This allows the aggregation to be stateless
 * @subpackage Structs
 */
class CapabilitiesRequestStructure extends AuthenticatedRequestStructure
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Address to which response is to be sent. This may also be determined from RequestorRef and preconfigured data. | Type for a endpoint.
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The RequestorRef
     * Meta informations extracted from the WSDL
     * - ref: RequestorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $RequestorRef;
    /**
     * The DelegatorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $DelegatorAddress;
    /**
     * The DelegatorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $DelegatorRef;
    /**
     * The ProductionTimetableCapabilitiesRequest
     * @var \StructType\ProductionTimetableCapabilitiesRequest
     */
    public $ProductionTimetableCapabilitiesRequest;
    /**
     * The EstimatedTimetableCapabilitiesRequest
     * @var \StructType\ServiceCapabilitiesRequestStructure
     */
    public $EstimatedTimetableCapabilitiesRequest;
    /**
     * The StopTimetableCapabilitiesRequest
     * @var \StructType\ServiceCapabilitiesRequestStructure
     */
    public $StopTimetableCapabilitiesRequest;
    /**
     * The StopMonitoringCapabilitiesRequest
     * @var \StructType\ServiceCapabilitiesRequestStructure
     */
    public $StopMonitoringCapabilitiesRequest;
    /**
     * The VehicleMonitoringCapabilitiesRequest
     * @var \StructType\ServiceCapabilitiesRequestStructure
     */
    public $VehicleMonitoringCapabilitiesRequest;
    /**
     * The ConnectionTimetableCapabilitiesRequest
     * @var \StructType\ServiceCapabilitiesRequestStructure
     */
    public $ConnectionTimetableCapabilitiesRequest;
    /**
     * The ConnectionMonitoringCapabilitiesRequest
     * @var \StructType\ServiceCapabilitiesRequestStructure
     */
    public $ConnectionMonitoringCapabilitiesRequest;
    /**
     * The GeneralMessageCapabilitiesRequest
     * @var \StructType\ServiceCapabilitiesRequestStructure
     */
    public $GeneralMessageCapabilitiesRequest;
    /**
     * The FacilityMonitoringCapabilitiesRequest
     * @var \StructType\ServiceCapabilitiesRequestStructure
     */
    public $FacilityMonitoringCapabilitiesRequest;
    /**
     * The SituationExchangeCapabilitiesRequest
     * @var \StructType\ServiceCapabilitiesRequestStructure
     */
    public $SituationExchangeCapabilitiesRequest;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for CapabilitiesRequestStructure
     * @uses CapabilitiesRequestStructure::setAddress()
     * @uses CapabilitiesRequestStructure::setRequestorRef()
     * @uses CapabilitiesRequestStructure::setDelegatorAddress()
     * @uses CapabilitiesRequestStructure::setDelegatorRef()
     * @uses CapabilitiesRequestStructure::setProductionTimetableCapabilitiesRequest()
     * @uses CapabilitiesRequestStructure::setEstimatedTimetableCapabilitiesRequest()
     * @uses CapabilitiesRequestStructure::setStopTimetableCapabilitiesRequest()
     * @uses CapabilitiesRequestStructure::setStopMonitoringCapabilitiesRequest()
     * @uses CapabilitiesRequestStructure::setVehicleMonitoringCapabilitiesRequest()
     * @uses CapabilitiesRequestStructure::setConnectionTimetableCapabilitiesRequest()
     * @uses CapabilitiesRequestStructure::setConnectionMonitoringCapabilitiesRequest()
     * @uses CapabilitiesRequestStructure::setGeneralMessageCapabilitiesRequest()
     * @uses CapabilitiesRequestStructure::setFacilityMonitoringCapabilitiesRequest()
     * @uses CapabilitiesRequestStructure::setSituationExchangeCapabilitiesRequest()
     * @uses CapabilitiesRequestStructure::setVersion()
     * @param string $address
     * @param \StructType\ParticipantRefStructure $requestorRef
     * @param string $delegatorAddress
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @param \StructType\ProductionTimetableCapabilitiesRequest $productionTimetableCapabilitiesRequest
     * @param \StructType\ServiceCapabilitiesRequestStructure $estimatedTimetableCapabilitiesRequest
     * @param \StructType\ServiceCapabilitiesRequestStructure $stopTimetableCapabilitiesRequest
     * @param \StructType\ServiceCapabilitiesRequestStructure $stopMonitoringCapabilitiesRequest
     * @param \StructType\ServiceCapabilitiesRequestStructure $vehicleMonitoringCapabilitiesRequest
     * @param \StructType\ServiceCapabilitiesRequestStructure $connectionTimetableCapabilitiesRequest
     * @param \StructType\ServiceCapabilitiesRequestStructure $connectionMonitoringCapabilitiesRequest
     * @param \StructType\ServiceCapabilitiesRequestStructure $generalMessageCapabilitiesRequest
     * @param \StructType\ServiceCapabilitiesRequestStructure $facilityMonitoringCapabilitiesRequest
     * @param \StructType\ServiceCapabilitiesRequestStructure $situationExchangeCapabilitiesRequest
     * @param string $version
     */
    public function __construct($address = null, \StructType\ParticipantRefStructure $requestorRef = null, $delegatorAddress = null, \StructType\ParticipantRefStructure $delegatorRef = null, \StructType\ProductionTimetableCapabilitiesRequest $productionTimetableCapabilitiesRequest = null, \StructType\ServiceCapabilitiesRequestStructure $estimatedTimetableCapabilitiesRequest = null, \StructType\ServiceCapabilitiesRequestStructure $stopTimetableCapabilitiesRequest = null, \StructType\ServiceCapabilitiesRequestStructure $stopMonitoringCapabilitiesRequest = null, \StructType\ServiceCapabilitiesRequestStructure $vehicleMonitoringCapabilitiesRequest = null, \StructType\ServiceCapabilitiesRequestStructure $connectionTimetableCapabilitiesRequest = null, \StructType\ServiceCapabilitiesRequestStructure $connectionMonitoringCapabilitiesRequest = null, \StructType\ServiceCapabilitiesRequestStructure $generalMessageCapabilitiesRequest = null, \StructType\ServiceCapabilitiesRequestStructure $facilityMonitoringCapabilitiesRequest = null, \StructType\ServiceCapabilitiesRequestStructure $situationExchangeCapabilitiesRequest = null, $version = '2.0')
    {
        $this
            ->setAddress($address)
            ->setRequestorRef($requestorRef)
            ->setDelegatorAddress($delegatorAddress)
            ->setDelegatorRef($delegatorRef)
            ->setProductionTimetableCapabilitiesRequest($productionTimetableCapabilitiesRequest)
            ->setEstimatedTimetableCapabilitiesRequest($estimatedTimetableCapabilitiesRequest)
            ->setStopTimetableCapabilitiesRequest($stopTimetableCapabilitiesRequest)
            ->setStopMonitoringCapabilitiesRequest($stopMonitoringCapabilitiesRequest)
            ->setVehicleMonitoringCapabilitiesRequest($vehicleMonitoringCapabilitiesRequest)
            ->setConnectionTimetableCapabilitiesRequest($connectionTimetableCapabilitiesRequest)
            ->setConnectionMonitoringCapabilitiesRequest($connectionMonitoringCapabilitiesRequest)
            ->setGeneralMessageCapabilitiesRequest($generalMessageCapabilitiesRequest)
            ->setFacilityMonitoringCapabilitiesRequest($facilityMonitoringCapabilitiesRequest)
            ->setSituationExchangeCapabilitiesRequest($situationExchangeCapabilitiesRequest)
            ->setVersion($version);
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get RequestorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getRequestorRef()
    {
        return $this->RequestorRef;
    }
    /**
     * Set RequestorRef value
     * @param \StructType\ParticipantRefStructure $requestorRef
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setRequestorRef(\StructType\ParticipantRefStructure $requestorRef = null)
    {
        $this->RequestorRef = $requestorRef;
        return $this;
    }
    /**
     * Get DelegatorAddress value
     * @return string|null
     */
    public function getDelegatorAddress()
    {
        return $this->DelegatorAddress;
    }
    /**
     * Set DelegatorAddress value
     * @param string $delegatorAddress
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setDelegatorAddress($delegatorAddress = null)
    {
        // validation for constraint: string
        if (!is_null($delegatorAddress) && !is_string($delegatorAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delegatorAddress)), __LINE__);
        }
        $this->DelegatorAddress = $delegatorAddress;
        return $this;
    }
    /**
     * Get DelegatorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getDelegatorRef()
    {
        return $this->DelegatorRef;
    }
    /**
     * Set DelegatorRef value
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setDelegatorRef(\StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this->DelegatorRef = $delegatorRef;
        return $this;
    }
    /**
     * Get ProductionTimetableCapabilitiesRequest value
     * @return \StructType\ProductionTimetableCapabilitiesRequest|null
     */
    public function getProductionTimetableCapabilitiesRequest()
    {
        return $this->ProductionTimetableCapabilitiesRequest;
    }
    /**
     * Set ProductionTimetableCapabilitiesRequest value
     * @param \StructType\ProductionTimetableCapabilitiesRequest $productionTimetableCapabilitiesRequest
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setProductionTimetableCapabilitiesRequest(\StructType\ProductionTimetableCapabilitiesRequest $productionTimetableCapabilitiesRequest = null)
    {
        $this->ProductionTimetableCapabilitiesRequest = $productionTimetableCapabilitiesRequest;
        return $this;
    }
    /**
     * Get EstimatedTimetableCapabilitiesRequest value
     * @return \StructType\ServiceCapabilitiesRequestStructure|null
     */
    public function getEstimatedTimetableCapabilitiesRequest()
    {
        return $this->EstimatedTimetableCapabilitiesRequest;
    }
    /**
     * Set EstimatedTimetableCapabilitiesRequest value
     * @param \StructType\ServiceCapabilitiesRequestStructure $estimatedTimetableCapabilitiesRequest
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setEstimatedTimetableCapabilitiesRequest(\StructType\ServiceCapabilitiesRequestStructure $estimatedTimetableCapabilitiesRequest = null)
    {
        $this->EstimatedTimetableCapabilitiesRequest = $estimatedTimetableCapabilitiesRequest;
        return $this;
    }
    /**
     * Get StopTimetableCapabilitiesRequest value
     * @return \StructType\ServiceCapabilitiesRequestStructure|null
     */
    public function getStopTimetableCapabilitiesRequest()
    {
        return $this->StopTimetableCapabilitiesRequest;
    }
    /**
     * Set StopTimetableCapabilitiesRequest value
     * @param \StructType\ServiceCapabilitiesRequestStructure $stopTimetableCapabilitiesRequest
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setStopTimetableCapabilitiesRequest(\StructType\ServiceCapabilitiesRequestStructure $stopTimetableCapabilitiesRequest = null)
    {
        $this->StopTimetableCapabilitiesRequest = $stopTimetableCapabilitiesRequest;
        return $this;
    }
    /**
     * Get StopMonitoringCapabilitiesRequest value
     * @return \StructType\ServiceCapabilitiesRequestStructure|null
     */
    public function getStopMonitoringCapabilitiesRequest()
    {
        return $this->StopMonitoringCapabilitiesRequest;
    }
    /**
     * Set StopMonitoringCapabilitiesRequest value
     * @param \StructType\ServiceCapabilitiesRequestStructure $stopMonitoringCapabilitiesRequest
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setStopMonitoringCapabilitiesRequest(\StructType\ServiceCapabilitiesRequestStructure $stopMonitoringCapabilitiesRequest = null)
    {
        $this->StopMonitoringCapabilitiesRequest = $stopMonitoringCapabilitiesRequest;
        return $this;
    }
    /**
     * Get VehicleMonitoringCapabilitiesRequest value
     * @return \StructType\ServiceCapabilitiesRequestStructure|null
     */
    public function getVehicleMonitoringCapabilitiesRequest()
    {
        return $this->VehicleMonitoringCapabilitiesRequest;
    }
    /**
     * Set VehicleMonitoringCapabilitiesRequest value
     * @param \StructType\ServiceCapabilitiesRequestStructure $vehicleMonitoringCapabilitiesRequest
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setVehicleMonitoringCapabilitiesRequest(\StructType\ServiceCapabilitiesRequestStructure $vehicleMonitoringCapabilitiesRequest = null)
    {
        $this->VehicleMonitoringCapabilitiesRequest = $vehicleMonitoringCapabilitiesRequest;
        return $this;
    }
    /**
     * Get ConnectionTimetableCapabilitiesRequest value
     * @return \StructType\ServiceCapabilitiesRequestStructure|null
     */
    public function getConnectionTimetableCapabilitiesRequest()
    {
        return $this->ConnectionTimetableCapabilitiesRequest;
    }
    /**
     * Set ConnectionTimetableCapabilitiesRequest value
     * @param \StructType\ServiceCapabilitiesRequestStructure $connectionTimetableCapabilitiesRequest
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setConnectionTimetableCapabilitiesRequest(\StructType\ServiceCapabilitiesRequestStructure $connectionTimetableCapabilitiesRequest = null)
    {
        $this->ConnectionTimetableCapabilitiesRequest = $connectionTimetableCapabilitiesRequest;
        return $this;
    }
    /**
     * Get ConnectionMonitoringCapabilitiesRequest value
     * @return \StructType\ServiceCapabilitiesRequestStructure|null
     */
    public function getConnectionMonitoringCapabilitiesRequest()
    {
        return $this->ConnectionMonitoringCapabilitiesRequest;
    }
    /**
     * Set ConnectionMonitoringCapabilitiesRequest value
     * @param \StructType\ServiceCapabilitiesRequestStructure $connectionMonitoringCapabilitiesRequest
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setConnectionMonitoringCapabilitiesRequest(\StructType\ServiceCapabilitiesRequestStructure $connectionMonitoringCapabilitiesRequest = null)
    {
        $this->ConnectionMonitoringCapabilitiesRequest = $connectionMonitoringCapabilitiesRequest;
        return $this;
    }
    /**
     * Get GeneralMessageCapabilitiesRequest value
     * @return \StructType\ServiceCapabilitiesRequestStructure|null
     */
    public function getGeneralMessageCapabilitiesRequest()
    {
        return $this->GeneralMessageCapabilitiesRequest;
    }
    /**
     * Set GeneralMessageCapabilitiesRequest value
     * @param \StructType\ServiceCapabilitiesRequestStructure $generalMessageCapabilitiesRequest
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setGeneralMessageCapabilitiesRequest(\StructType\ServiceCapabilitiesRequestStructure $generalMessageCapabilitiesRequest = null)
    {
        $this->GeneralMessageCapabilitiesRequest = $generalMessageCapabilitiesRequest;
        return $this;
    }
    /**
     * Get FacilityMonitoringCapabilitiesRequest value
     * @return \StructType\ServiceCapabilitiesRequestStructure|null
     */
    public function getFacilityMonitoringCapabilitiesRequest()
    {
        return $this->FacilityMonitoringCapabilitiesRequest;
    }
    /**
     * Set FacilityMonitoringCapabilitiesRequest value
     * @param \StructType\ServiceCapabilitiesRequestStructure $facilityMonitoringCapabilitiesRequest
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setFacilityMonitoringCapabilitiesRequest(\StructType\ServiceCapabilitiesRequestStructure $facilityMonitoringCapabilitiesRequest = null)
    {
        $this->FacilityMonitoringCapabilitiesRequest = $facilityMonitoringCapabilitiesRequest;
        return $this;
    }
    /**
     * Get SituationExchangeCapabilitiesRequest value
     * @return \StructType\ServiceCapabilitiesRequestStructure|null
     */
    public function getSituationExchangeCapabilitiesRequest()
    {
        return $this->SituationExchangeCapabilitiesRequest;
    }
    /**
     * Set SituationExchangeCapabilitiesRequest value
     * @param \StructType\ServiceCapabilitiesRequestStructure $situationExchangeCapabilitiesRequest
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setSituationExchangeCapabilitiesRequest(\StructType\ServiceCapabilitiesRequestStructure $situationExchangeCapabilitiesRequest = null)
    {
        $this->SituationExchangeCapabilitiesRequest = $situationExchangeCapabilitiesRequest;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\CapabilitiesRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CapabilitiesRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
