<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoardingStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for boarding restrictions.
 * @subpackage Structs
 */
class BoardingStructure extends AbstractStructBase
{
    /**
     * The ArrivalBoardingActivity
     * Meta informations extracted from the WSDL
     * - default: alighting
     * - documentation: Type of boarding and alighting allowed at stop. Default is 'Alighting'.
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalBoardingActivity;
    /**
     * The DepartureBoardingActivity
     * Meta informations extracted from the WSDL
     * - default: boarding
     * - documentation: Type of alighting allowed at stop. Default is 'Boarding'.
     * - minOccurs: 0
     * @var string
     */
    public $DepartureBoardingActivity;
    /**
     * Constructor method for BoardingStructure
     * @uses BoardingStructure::setArrivalBoardingActivity()
     * @uses BoardingStructure::setDepartureBoardingActivity()
     * @param string $arrivalBoardingActivity
     * @param string $departureBoardingActivity
     */
    public function __construct($arrivalBoardingActivity = 'alighting', $departureBoardingActivity = 'boarding')
    {
        $this
            ->setArrivalBoardingActivity($arrivalBoardingActivity)
            ->setDepartureBoardingActivity($departureBoardingActivity);
    }
    /**
     * Get ArrivalBoardingActivity value
     * @return string|null
     */
    public function getArrivalBoardingActivity()
    {
        return $this->ArrivalBoardingActivity;
    }
    /**
     * Set ArrivalBoardingActivity value
     * @uses \EnumType\ArrivalBoardingActivityEnumeration::valueIsValid()
     * @uses \EnumType\ArrivalBoardingActivityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrivalBoardingActivity
     * @return \StructType\BoardingStructure
     */
    public function setArrivalBoardingActivity($arrivalBoardingActivity = 'alighting')
    {
        // validation for constraint: enumeration
        if (!\EnumType\ArrivalBoardingActivityEnumeration::valueIsValid($arrivalBoardingActivity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $arrivalBoardingActivity, implode(', ', \EnumType\ArrivalBoardingActivityEnumeration::getValidValues())), __LINE__);
        }
        $this->ArrivalBoardingActivity = $arrivalBoardingActivity;
        return $this;
    }
    /**
     * Get DepartureBoardingActivity value
     * @return string|null
     */
    public function getDepartureBoardingActivity()
    {
        return $this->DepartureBoardingActivity;
    }
    /**
     * Set DepartureBoardingActivity value
     * @uses \EnumType\DepartureBoardingActivityEnumeration::valueIsValid()
     * @uses \EnumType\DepartureBoardingActivityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureBoardingActivity
     * @return \StructType\BoardingStructure
     */
    public function setDepartureBoardingActivity($departureBoardingActivity = 'boarding')
    {
        // validation for constraint: enumeration
        if (!\EnumType\DepartureBoardingActivityEnumeration::valueIsValid($departureBoardingActivity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $departureBoardingActivity, implode(', ', \EnumType\DepartureBoardingActivityEnumeration::getValidValues())), __LINE__);
        }
        $this->DepartureBoardingActivity = $departureBoardingActivity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BoardingStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
