<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BeforeNotices StructType
 * Meta informations extracted from the WSDL
 * - documentation: Whether reminders should be sent.
 * @subpackage Structs
 */
class BeforeNotices extends AbstractStructBase
{
    /**
     * The Interval
     * Meta informations extracted from the WSDL
     * - documentation: Intervals before validity start date to send reminders. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should
     * not be used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Interval;
    /**
     * Constructor method for BeforeNotices
     * @uses BeforeNotices::setInterval()
     * @param string[] $interval
     */
    public function __construct(array $interval = array())
    {
        $this
            ->setInterval($interval);
    }
    /**
     * Get Interval value
     * @return string[]|null
     */
    public function getInterval()
    {
        return $this->Interval;
    }
    /**
     * Set Interval value
     * @throws \InvalidArgumentException
     * @param string[] $interval
     * @return \StructType\BeforeNotices
     */
    public function setInterval(array $interval = array())
    {
        foreach ($interval as $beforeNoticesIntervalItem) {
            // validation for constraint: itemType
            if (!is_string($beforeNoticesIntervalItem)) {
                throw new \InvalidArgumentException(sprintf('The Interval property can only contain items of duration, "%s" given', is_object($beforeNoticesIntervalItem) ? get_class($beforeNoticesIntervalItem) : gettype($beforeNoticesIntervalItem)), __LINE__);
            }
        }
        $this->Interval = $interval;
        return $this;
    }
    /**
     * Add item to Interval value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BeforeNotices
     */
    public function addToInterval($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Interval property can only contain items of duration, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Interval[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BeforeNotices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
