<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasicDataValue StructType
 * @subpackage Structs
 */
abstract class BasicDataValue extends AbstractStructBase
{
    /**
     * The accuracy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $accuracy;
    /**
     * The computationalMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $computationalMethod;
    /**
     * The fault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $fault;
    /**
     * The faultReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $faultReason;
    /**
     * The numberOfIncompleteInputs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfIncompleteInputs;
    /**
     * The numberOfInputValuesUsed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfInputValuesUsed;
    /**
     * The period
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $period;
    /**
     * The smoothingFactor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $smoothingFactor;
    /**
     * The standardDeviation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $standardDeviation;
    /**
     * The supplierCalculatedDataQuality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $supplierCalculatedDataQuality;
    /**
     * The time
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $time;
    /**
     * The pertinentLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GroupOfLocations
     */
    public $pertinentLocation;
    /**
     * The basicDataValueExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $basicDataValueExtension;
    /**
     * Constructor method for BasicDataValue
     * @uses BasicDataValue::setAccuracy()
     * @uses BasicDataValue::setComputationalMethod()
     * @uses BasicDataValue::setFault()
     * @uses BasicDataValue::setFaultReason()
     * @uses BasicDataValue::setNumberOfIncompleteInputs()
     * @uses BasicDataValue::setNumberOfInputValuesUsed()
     * @uses BasicDataValue::setPeriod()
     * @uses BasicDataValue::setSmoothingFactor()
     * @uses BasicDataValue::setStandardDeviation()
     * @uses BasicDataValue::setSupplierCalculatedDataQuality()
     * @uses BasicDataValue::setTime()
     * @uses BasicDataValue::setPertinentLocation()
     * @uses BasicDataValue::setBasicDataValueExtension()
     * @param float $accuracy
     * @param string $computationalMethod
     * @param bool $fault
     * @param \StructType\MultilingualString $faultReason
     * @param int $numberOfIncompleteInputs
     * @param int $numberOfInputValuesUsed
     * @param float $period
     * @param float $smoothingFactor
     * @param float $standardDeviation
     * @param float $supplierCalculatedDataQuality
     * @param string $time
     * @param \StructType\GroupOfLocations $pertinentLocation
     * @param \StructType\ExtensionType $basicDataValueExtension
     */
    public function __construct($accuracy = null, $computationalMethod = null, $fault = null, \StructType\MultilingualString $faultReason = null, $numberOfIncompleteInputs = null, $numberOfInputValuesUsed = null, $period = null, $smoothingFactor = null, $standardDeviation = null, $supplierCalculatedDataQuality = null, $time = null, \StructType\GroupOfLocations $pertinentLocation = null, \StructType\ExtensionType $basicDataValueExtension = null)
    {
        $this
            ->setAccuracy($accuracy)
            ->setComputationalMethod($computationalMethod)
            ->setFault($fault)
            ->setFaultReason($faultReason)
            ->setNumberOfIncompleteInputs($numberOfIncompleteInputs)
            ->setNumberOfInputValuesUsed($numberOfInputValuesUsed)
            ->setPeriod($period)
            ->setSmoothingFactor($smoothingFactor)
            ->setStandardDeviation($standardDeviation)
            ->setSupplierCalculatedDataQuality($supplierCalculatedDataQuality)
            ->setTime($time)
            ->setPertinentLocation($pertinentLocation)
            ->setBasicDataValueExtension($basicDataValueExtension);
    }
    /**
     * Get accuracy value
     * @return float|null
     */
    public function getAccuracy()
    {
        return $this->accuracy;
    }
    /**
     * Set accuracy value
     * @param float $accuracy
     * @return \StructType\BasicDataValue
     */
    public function setAccuracy($accuracy = null)
    {
        $this->accuracy = $accuracy;
        return $this;
    }
    /**
     * Get computationalMethod value
     * @return string|null
     */
    public function getComputationalMethod()
    {
        return $this->computationalMethod;
    }
    /**
     * Set computationalMethod value
     * @uses \EnumType\ComputationMethodEnum::valueIsValid()
     * @uses \EnumType\ComputationMethodEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $computationalMethod
     * @return \StructType\BasicDataValue
     */
    public function setComputationalMethod($computationalMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComputationMethodEnum::valueIsValid($computationalMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $computationalMethod, implode(', ', \EnumType\ComputationMethodEnum::getValidValues())), __LINE__);
        }
        $this->computationalMethod = $computationalMethod;
        return $this;
    }
    /**
     * Get fault value
     * @return bool|null
     */
    public function getFault()
    {
        return $this->fault;
    }
    /**
     * Set fault value
     * @param bool $fault
     * @return \StructType\BasicDataValue
     */
    public function setFault($fault = null)
    {
        // validation for constraint: boolean
        if (!is_null($fault) && !is_bool($fault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fault)), __LINE__);
        }
        $this->fault = $fault;
        return $this;
    }
    /**
     * Get faultReason value
     * @return \StructType\MultilingualString|null
     */
    public function getFaultReason()
    {
        return $this->faultReason;
    }
    /**
     * Set faultReason value
     * @param \StructType\MultilingualString $faultReason
     * @return \StructType\BasicDataValue
     */
    public function setFaultReason(\StructType\MultilingualString $faultReason = null)
    {
        $this->faultReason = $faultReason;
        return $this;
    }
    /**
     * Get numberOfIncompleteInputs value
     * @return int|null
     */
    public function getNumberOfIncompleteInputs()
    {
        return $this->numberOfIncompleteInputs;
    }
    /**
     * Set numberOfIncompleteInputs value
     * @param int $numberOfIncompleteInputs
     * @return \StructType\BasicDataValue
     */
    public function setNumberOfIncompleteInputs($numberOfIncompleteInputs = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfIncompleteInputs) && !is_numeric($numberOfIncompleteInputs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfIncompleteInputs)), __LINE__);
        }
        $this->numberOfIncompleteInputs = $numberOfIncompleteInputs;
        return $this;
    }
    /**
     * Get numberOfInputValuesUsed value
     * @return int|null
     */
    public function getNumberOfInputValuesUsed()
    {
        return $this->numberOfInputValuesUsed;
    }
    /**
     * Set numberOfInputValuesUsed value
     * @param int $numberOfInputValuesUsed
     * @return \StructType\BasicDataValue
     */
    public function setNumberOfInputValuesUsed($numberOfInputValuesUsed = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInputValuesUsed) && !is_numeric($numberOfInputValuesUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfInputValuesUsed)), __LINE__);
        }
        $this->numberOfInputValuesUsed = $numberOfInputValuesUsed;
        return $this;
    }
    /**
     * Get period value
     * @return float|null
     */
    public function getPeriod()
    {
        return $this->period;
    }
    /**
     * Set period value
     * @param float $period
     * @return \StructType\BasicDataValue
     */
    public function setPeriod($period = null)
    {
        $this->period = $period;
        return $this;
    }
    /**
     * Get smoothingFactor value
     * @return float|null
     */
    public function getSmoothingFactor()
    {
        return $this->smoothingFactor;
    }
    /**
     * Set smoothingFactor value
     * @param float $smoothingFactor
     * @return \StructType\BasicDataValue
     */
    public function setSmoothingFactor($smoothingFactor = null)
    {
        $this->smoothingFactor = $smoothingFactor;
        return $this;
    }
    /**
     * Get standardDeviation value
     * @return float|null
     */
    public function getStandardDeviation()
    {
        return $this->standardDeviation;
    }
    /**
     * Set standardDeviation value
     * @param float $standardDeviation
     * @return \StructType\BasicDataValue
     */
    public function setStandardDeviation($standardDeviation = null)
    {
        $this->standardDeviation = $standardDeviation;
        return $this;
    }
    /**
     * Get supplierCalculatedDataQuality value
     * @return float|null
     */
    public function getSupplierCalculatedDataQuality()
    {
        return $this->supplierCalculatedDataQuality;
    }
    /**
     * Set supplierCalculatedDataQuality value
     * @param float $supplierCalculatedDataQuality
     * @return \StructType\BasicDataValue
     */
    public function setSupplierCalculatedDataQuality($supplierCalculatedDataQuality = null)
    {
        $this->supplierCalculatedDataQuality = $supplierCalculatedDataQuality;
        return $this;
    }
    /**
     * Get time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param string $time
     * @return \StructType\BasicDataValue
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get pertinentLocation value
     * @return \StructType\GroupOfLocations|null
     */
    public function getPertinentLocation()
    {
        return $this->pertinentLocation;
    }
    /**
     * Set pertinentLocation value
     * @param \StructType\GroupOfLocations $pertinentLocation
     * @return \StructType\BasicDataValue
     */
    public function setPertinentLocation(\StructType\GroupOfLocations $pertinentLocation = null)
    {
        $this->pertinentLocation = $pertinentLocation;
        return $this;
    }
    /**
     * Get basicDataValueExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getBasicDataValueExtension()
    {
        return $this->basicDataValueExtension;
    }
    /**
     * Set basicDataValueExtension value
     * @param \StructType\ExtensionType $basicDataValueExtension
     * @return \StructType\BasicDataValue
     */
    public function setBasicDataValueExtension(\StructType\ExtensionType $basicDataValueExtension = null)
    {
        $this->basicDataValueExtension = $basicDataValueExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BasicDataValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
