<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorityOperation StructType
 * @subpackage Structs
 */
class AuthorityOperation extends Activity
{
    /**
     * The authorityOperationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $authorityOperationType;
    /**
     * The authorityOperationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $authorityOperationExtension;
    /**
     * Constructor method for AuthorityOperation
     * @uses AuthorityOperation::setAuthorityOperationType()
     * @uses AuthorityOperation::setAuthorityOperationExtension()
     * @param string $authorityOperationType
     * @param \StructType\ExtensionType $authorityOperationExtension
     */
    public function __construct($authorityOperationType = null, \StructType\ExtensionType $authorityOperationExtension = null)
    {
        $this
            ->setAuthorityOperationType($authorityOperationType)
            ->setAuthorityOperationExtension($authorityOperationExtension);
    }
    /**
     * Get authorityOperationType value
     * @return string
     */
    public function getAuthorityOperationType()
    {
        return $this->authorityOperationType;
    }
    /**
     * Set authorityOperationType value
     * @uses \EnumType\AuthorityOperationTypeEnum::valueIsValid()
     * @uses \EnumType\AuthorityOperationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authorityOperationType
     * @return \StructType\AuthorityOperation
     */
    public function setAuthorityOperationType($authorityOperationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AuthorityOperationTypeEnum::valueIsValid($authorityOperationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authorityOperationType, implode(', ', \EnumType\AuthorityOperationTypeEnum::getValidValues())), __LINE__);
        }
        $this->authorityOperationType = $authorityOperationType;
        return $this;
    }
    /**
     * Get authorityOperationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getAuthorityOperationExtension()
    {
        return $this->authorityOperationExtension;
    }
    /**
     * Set authorityOperationExtension value
     * @param \StructType\ExtensionType $authorityOperationExtension
     * @return \StructType\AuthorityOperation
     */
    public function setAuthorityOperationExtension(\StructType\ExtensionType $authorityOperationExtension = null)
    {
        $this->authorityOperationExtension = $authorityOperationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorityOperation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
