<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticatedRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Authticated SIRI Request.
 * @subpackage Structs
 */
abstract class AuthenticatedRequestStructure extends AbstractRequestStructure
{
    /**
     * The AccountId
     * @var string
     */
    public $AccountId;
    /**
     * The AccountKey
     * @var string
     */
    public $AccountKey;
    /**
     * Constructor method for AuthenticatedRequestStructure
     * @uses AuthenticatedRequestStructure::setAccountId()
     * @uses AuthenticatedRequestStructure::setAccountKey()
     * @param string $accountId
     * @param string $accountKey
     */
    public function __construct($accountId = null, $accountKey = null)
    {
        $this
            ->setAccountId($accountId)
            ->setAccountKey($accountKey);
    }
    /**
     * Get AccountId value
     * @return string|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param string $accountId
     * @return \StructType\AuthenticatedRequestStructure
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get AccountKey value
     * @return string|null
     */
    public function getAccountKey()
    {
        return $this->AccountKey;
    }
    /**
     * Set AccountKey value
     * @param string $accountKey
     * @return \StructType\AuthenticatedRequestStructure
     */
    public function setAccountKey($accountKey = null)
    {
        // validation for constraint: string
        if (!is_null($accountKey) && !is_string($accountKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountKey)), __LINE__);
        }
        $this->AccountKey = $accountKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthenticatedRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
