<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnnotatedDestinationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for DESTINATION and place name.
 * @subpackage Structs
 */
class AnnotatedDestinationStructure extends AbstractStructBase
{
    /**
     * The DestinationRef
     * @var \StructType\DestinationRefStructure
     */
    public $DestinationRef;
    /**
     * The PlaceName
     * Meta informations extracted from the WSDL
     * - documentation: Name of destination TOPOGRAPHIC PLACE. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $PlaceName;
    /**
     * The DirectionRef
     * Meta informations extracted from the WSDL
     * - documentation: Direction in which destination lies. relatoive to currernt stop SIRI 2.0
     * - minOccurs: 0
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * Constructor method for AnnotatedDestinationStructure
     * @uses AnnotatedDestinationStructure::setDestinationRef()
     * @uses AnnotatedDestinationStructure::setPlaceName()
     * @uses AnnotatedDestinationStructure::setDirectionRef()
     * @param \StructType\DestinationRefStructure $destinationRef
     * @param \StructType\NaturalLanguageStringStructure[] $placeName
     * @param \StructType\DirectionRefStructure $directionRef
     */
    public function __construct(\StructType\DestinationRefStructure $destinationRef = null, array $placeName = array(), \StructType\DirectionRefStructure $directionRef = null)
    {
        $this
            ->setDestinationRef($destinationRef)
            ->setPlaceName($placeName)
            ->setDirectionRef($directionRef);
    }
    /**
     * Get DestinationRef value
     * @return \StructType\DestinationRefStructure|null
     */
    public function getDestinationRef()
    {
        return $this->DestinationRef;
    }
    /**
     * Set DestinationRef value
     * @param \StructType\DestinationRefStructure $destinationRef
     * @return \StructType\AnnotatedDestinationStructure
     */
    public function setDestinationRef(\StructType\DestinationRefStructure $destinationRef = null)
    {
        $this->DestinationRef = $destinationRef;
        return $this;
    }
    /**
     * Get PlaceName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getPlaceName()
    {
        return $this->PlaceName;
    }
    /**
     * Set PlaceName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $placeName
     * @return \StructType\AnnotatedDestinationStructure
     */
    public function setPlaceName(array $placeName = array())
    {
        foreach ($placeName as $annotatedDestinationStructurePlaceNameItem) {
            // validation for constraint: itemType
            if (!$annotatedDestinationStructurePlaceNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The PlaceName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($annotatedDestinationStructurePlaceNameItem) ? get_class($annotatedDestinationStructurePlaceNameItem) : gettype($annotatedDestinationStructurePlaceNameItem)), __LINE__);
            }
        }
        $this->PlaceName = $placeName;
        return $this;
    }
    /**
     * Add item to PlaceName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AnnotatedDestinationStructure
     */
    public function addToPlaceName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The PlaceName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlaceName[] = $item;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\AnnotatedDestinationStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnnotatedDestinationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
