<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AliasStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Alternative Private Code.
 * @subpackage Structs
 */
class AliasStructure extends AbstractStructBase
{
    /**
     * The PrivateCode
     * Meta informations extracted from the WSDL
     * - documentation: Alternative identifier. | Private code alternative identifier that may be associated with element.
     * @var string
     */
    public $PrivateCode;
    /**
     * The IdentifierType
     * Meta informations extracted from the WSDL
     * - documentation: Type of Identifier.
     * - minOccurs: 0
     * @var string
     */
    public $IdentifierType;
    /**
     * Constructor method for AliasStructure
     * @uses AliasStructure::setPrivateCode()
     * @uses AliasStructure::setIdentifierType()
     * @param string $privateCode
     * @param string $identifierType
     */
    public function __construct($privateCode = null, $identifierType = null)
    {
        $this
            ->setPrivateCode($privateCode)
            ->setIdentifierType($identifierType);
    }
    /**
     * Get PrivateCode value
     * @return string|null
     */
    public function getPrivateCode()
    {
        return $this->PrivateCode;
    }
    /**
     * Set PrivateCode value
     * @param string $privateCode
     * @return \StructType\AliasStructure
     */
    public function setPrivateCode($privateCode = null)
    {
        // validation for constraint: string
        if (!is_null($privateCode) && !is_string($privateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($privateCode)), __LINE__);
        }
        $this->PrivateCode = $privateCode;
        return $this;
    }
    /**
     * Get IdentifierType value
     * @return string|null
     */
    public function getIdentifierType()
    {
        return $this->IdentifierType;
    }
    /**
     * Set IdentifierType value
     * @param string $identifierType
     * @return \StructType\AliasStructure
     */
    public function setIdentifierType($identifierType = null)
    {
        // validation for constraint: string
        if (!is_null($identifierType) && !is_string($identifierType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifierType)), __LINE__);
        }
        $this->IdentifierType = $identifierType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AliasStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
