<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlertCDirection StructType
 * @subpackage Structs
 */
class AlertCDirection extends AbstractStructBase
{
    /**
     * The alertCDirectionCoded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $alertCDirectionCoded;
    /**
     * The alertCDirectionNamed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $alertCDirectionNamed;
    /**
     * The alertCDirectionSense
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $alertCDirectionSense;
    /**
     * The alertCDirectionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $alertCDirectionExtension;
    /**
     * Constructor method for AlertCDirection
     * @uses AlertCDirection::setAlertCDirectionCoded()
     * @uses AlertCDirection::setAlertCDirectionNamed()
     * @uses AlertCDirection::setAlertCDirectionSense()
     * @uses AlertCDirection::setAlertCDirectionExtension()
     * @param string $alertCDirectionCoded
     * @param \StructType\MultilingualString $alertCDirectionNamed
     * @param bool $alertCDirectionSense
     * @param \StructType\ExtensionType $alertCDirectionExtension
     */
    public function __construct($alertCDirectionCoded = null, \StructType\MultilingualString $alertCDirectionNamed = null, $alertCDirectionSense = null, \StructType\ExtensionType $alertCDirectionExtension = null)
    {
        $this
            ->setAlertCDirectionCoded($alertCDirectionCoded)
            ->setAlertCDirectionNamed($alertCDirectionNamed)
            ->setAlertCDirectionSense($alertCDirectionSense)
            ->setAlertCDirectionExtension($alertCDirectionExtension);
    }
    /**
     * Get alertCDirectionCoded value
     * @return string
     */
    public function getAlertCDirectionCoded()
    {
        return $this->alertCDirectionCoded;
    }
    /**
     * Set alertCDirectionCoded value
     * @uses \EnumType\AlertCDirectionEnum::valueIsValid()
     * @uses \EnumType\AlertCDirectionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alertCDirectionCoded
     * @return \StructType\AlertCDirection
     */
    public function setAlertCDirectionCoded($alertCDirectionCoded = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AlertCDirectionEnum::valueIsValid($alertCDirectionCoded)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alertCDirectionCoded, implode(', ', \EnumType\AlertCDirectionEnum::getValidValues())), __LINE__);
        }
        $this->alertCDirectionCoded = $alertCDirectionCoded;
        return $this;
    }
    /**
     * Get alertCDirectionNamed value
     * @return \StructType\MultilingualString|null
     */
    public function getAlertCDirectionNamed()
    {
        return $this->alertCDirectionNamed;
    }
    /**
     * Set alertCDirectionNamed value
     * @param \StructType\MultilingualString $alertCDirectionNamed
     * @return \StructType\AlertCDirection
     */
    public function setAlertCDirectionNamed(\StructType\MultilingualString $alertCDirectionNamed = null)
    {
        $this->alertCDirectionNamed = $alertCDirectionNamed;
        return $this;
    }
    /**
     * Get alertCDirectionSense value
     * @return bool|null
     */
    public function getAlertCDirectionSense()
    {
        return $this->alertCDirectionSense;
    }
    /**
     * Set alertCDirectionSense value
     * @param bool $alertCDirectionSense
     * @return \StructType\AlertCDirection
     */
    public function setAlertCDirectionSense($alertCDirectionSense = null)
    {
        // validation for constraint: boolean
        if (!is_null($alertCDirectionSense) && !is_bool($alertCDirectionSense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($alertCDirectionSense)), __LINE__);
        }
        $this->alertCDirectionSense = $alertCDirectionSense;
        return $this;
    }
    /**
     * Get alertCDirectionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getAlertCDirectionExtension()
    {
        return $this->alertCDirectionExtension;
    }
    /**
     * Set alertCDirectionExtension value
     * @param \StructType\ExtensionType $alertCDirectionExtension
     * @return \StructType\AlertCDirection
     */
    public function setAlertCDirectionExtension(\StructType\ExtensionType $alertCDirectionExtension = null)
    {
        $this->alertCDirectionExtension = $alertCDirectionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AlertCDirection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
