<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedVehicleStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for information about a VEHICLE affected by an SITUATION.
 * @subpackage Structs
 */
class AffectedVehicleStructure extends AbstractStructBase
{
    /**
     * The VehicleRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a specific VEHICLE affected by an SITUATION.
     * @var \StructType\VehicleRefStructure
     */
    public $VehicleRef;
    /**
     * The VehicleRegistrationNumberPlate
     * Meta informations extracted from the WSDL
     * - documentation: Registration plate of VEHICLE
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $VehicleRegistrationNumberPlate;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: (Mobile) phone number on which the vehicle can be called | International phonenumber +41675601 etc.
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The IPAddress
     * Meta informations extracted from the WSDL
     * - documentation: Internet protocol address of the VEHICLE in form 000.000.000.000
     * - minOccurs: 0
     * @var string
     */
    public $IPAddress;
    /**
     * The RadioAddress
     * Meta informations extracted from the WSDL
     * - documentation: Radio address of the VEHICLE
     * - minOccurs: 0
     * @var string
     */
    public $RadioAddress;
    /**
     * The FramedVehicleJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to VEHICLE JOURNEY that VEHICLE is making.
     * - minOccurs: 0
     * @var \StructType\FramedVehicleJourneyRefStructure
     */
    public $FramedVehicleJourneyRef;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - documentation: Location where the VEHICLE was when the situation arosse
     * - minOccurs: 0
     * @var \StructType\LocationStructure
     */
    public $Location;
    /**
     * The CurrentLocation
     * Meta informations extracted from the WSDL
     * - documentation: Current Location of the VEHICLE
     * - minOccurs: 0
     * @var \StructType\LocationStructure
     */
    public $CurrentLocation;
    /**
     * The AccessibilityAssessment
     * Meta informations extracted from the WSDL
     * - documentation: Current Accessibility assessment of vehicle.
     * - minOccurs: 0
     * @var \StructType\AccessibilityAssessmentStructure
     */
    public $AccessibilityAssessment;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The ProductCategoryRef
     * @var \StructType\ProductCategoryRefStructure
     */
    public $ProductCategoryRef;
    /**
     * The ServiceFeatureRef
     * @var \StructType\ServiceFeatureRefStructure
     */
    public $ServiceFeatureRef;
    /**
     * The VehicleFeatureRef
     * @var \StructType\VehicleFeatureRefStructure
     */
    public $VehicleFeatureRef;
    /**
     * The TrainBlockPart
     * Meta informations extracted from the WSDL
     * - documentation: If a VEHICLE JOURNEY is a coupled journey, i.e. comprises several coupled BLOCKparts, there will be a separate delivery for each BLOCKp art and this element will indicate the vehicles that the journey part uses.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TrainBlockPartStructure[]
     */
    public $TrainBlockPart;
    /**
     * The BlockRef
     * @var \StructType\BlockRefStructure
     */
    public $BlockRef;
    /**
     * The CourseOfJourneyRef
     * @var \StructType\CourseOfJourneyRefStructure
     */
    public $CourseOfJourneyRef;
    /**
     * The InCongestion
     * Meta informations extracted from the WSDL
     * - documentation: Whether the VEHICLE is in traffic congestion. If not, present, not known.
     * - minOccurs: 0
     * @var bool
     */
    public $InCongestion;
    /**
     * The InPanic
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether the panic alarm on the VEHICLE is activated. Default is 'false'.
     * - minOccurs: 0
     * @var bool
     */
    public $InPanic;
    /**
     * The HeadwayService
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether this is a Headway Service, that is shown as operating at a prescribed interval rather than to a fixed timetable. Default is 'false'.
     * - minOccurs: 0
     * @var bool
     */
    public $HeadwayService;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedVehicleStructure
     * @uses AffectedVehicleStructure::setVehicleRef()
     * @uses AffectedVehicleStructure::setVehicleRegistrationNumberPlate()
     * @uses AffectedVehicleStructure::setPhoneNumber()
     * @uses AffectedVehicleStructure::setIPAddress()
     * @uses AffectedVehicleStructure::setRadioAddress()
     * @uses AffectedVehicleStructure::setFramedVehicleJourneyRef()
     * @uses AffectedVehicleStructure::setLocation()
     * @uses AffectedVehicleStructure::setCurrentLocation()
     * @uses AffectedVehicleStructure::setAccessibilityAssessment()
     * @uses AffectedVehicleStructure::setOperatorRef()
     * @uses AffectedVehicleStructure::setProductCategoryRef()
     * @uses AffectedVehicleStructure::setServiceFeatureRef()
     * @uses AffectedVehicleStructure::setVehicleFeatureRef()
     * @uses AffectedVehicleStructure::setTrainBlockPart()
     * @uses AffectedVehicleStructure::setBlockRef()
     * @uses AffectedVehicleStructure::setCourseOfJourneyRef()
     * @uses AffectedVehicleStructure::setInCongestion()
     * @uses AffectedVehicleStructure::setInPanic()
     * @uses AffectedVehicleStructure::setHeadwayService()
     * @uses AffectedVehicleStructure::setExtensions()
     * @param \StructType\VehicleRefStructure $vehicleRef
     * @param string[] $vehicleRegistrationNumberPlate
     * @param string $phoneNumber
     * @param string $iPAddress
     * @param string $radioAddress
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @param \StructType\LocationStructure $location
     * @param \StructType\LocationStructure $currentLocation
     * @param \StructType\AccessibilityAssessmentStructure $accessibilityAssessment
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @param \StructType\TrainBlockPartStructure[] $trainBlockPart
     * @param \StructType\BlockRefStructure $blockRef
     * @param \StructType\CourseOfJourneyRefStructure $courseOfJourneyRef
     * @param bool $inCongestion
     * @param bool $inPanic
     * @param bool $headwayService
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\VehicleRefStructure $vehicleRef = null, array $vehicleRegistrationNumberPlate = array(), $phoneNumber = null, $iPAddress = null, $radioAddress = null, \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null, \StructType\LocationStructure $location = null, \StructType\LocationStructure $currentLocation = null, \StructType\AccessibilityAssessmentStructure $accessibilityAssessment = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\ProductCategoryRefStructure $productCategoryRef = null, \StructType\ServiceFeatureRefStructure $serviceFeatureRef = null, \StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null, array $trainBlockPart = array(), \StructType\BlockRefStructure $blockRef = null, \StructType\CourseOfJourneyRefStructure $courseOfJourneyRef = null, $inCongestion = null, $inPanic = false, $headwayService = false, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setVehicleRef($vehicleRef)
            ->setVehicleRegistrationNumberPlate($vehicleRegistrationNumberPlate)
            ->setPhoneNumber($phoneNumber)
            ->setIPAddress($iPAddress)
            ->setRadioAddress($radioAddress)
            ->setFramedVehicleJourneyRef($framedVehicleJourneyRef)
            ->setLocation($location)
            ->setCurrentLocation($currentLocation)
            ->setAccessibilityAssessment($accessibilityAssessment)
            ->setOperatorRef($operatorRef)
            ->setProductCategoryRef($productCategoryRef)
            ->setServiceFeatureRef($serviceFeatureRef)
            ->setVehicleFeatureRef($vehicleFeatureRef)
            ->setTrainBlockPart($trainBlockPart)
            ->setBlockRef($blockRef)
            ->setCourseOfJourneyRef($courseOfJourneyRef)
            ->setInCongestion($inCongestion)
            ->setInPanic($inPanic)
            ->setHeadwayService($headwayService)
            ->setExtensions($extensions);
    }
    /**
     * Get VehicleRef value
     * @return \StructType\VehicleRefStructure|null
     */
    public function getVehicleRef()
    {
        return $this->VehicleRef;
    }
    /**
     * Set VehicleRef value
     * @param \StructType\VehicleRefStructure $vehicleRef
     * @return \StructType\AffectedVehicleStructure
     */
    public function setVehicleRef(\StructType\VehicleRefStructure $vehicleRef = null)
    {
        $this->VehicleRef = $vehicleRef;
        return $this;
    }
    /**
     * Get VehicleRegistrationNumberPlate value
     * @return string[]|null
     */
    public function getVehicleRegistrationNumberPlate()
    {
        return $this->VehicleRegistrationNumberPlate;
    }
    /**
     * Set VehicleRegistrationNumberPlate value
     * @throws \InvalidArgumentException
     * @param string[] $vehicleRegistrationNumberPlate
     * @return \StructType\AffectedVehicleStructure
     */
    public function setVehicleRegistrationNumberPlate(array $vehicleRegistrationNumberPlate = array())
    {
        foreach ($vehicleRegistrationNumberPlate as $affectedVehicleStructureVehicleRegistrationNumberPlateItem) {
            // validation for constraint: itemType
            if (!is_string($affectedVehicleStructureVehicleRegistrationNumberPlateItem)) {
                throw new \InvalidArgumentException(sprintf('The VehicleRegistrationNumberPlate property can only contain items of normalizedString, "%s" given', is_object($affectedVehicleStructureVehicleRegistrationNumberPlateItem) ? get_class($affectedVehicleStructureVehicleRegistrationNumberPlateItem) : gettype($affectedVehicleStructureVehicleRegistrationNumberPlateItem)), __LINE__);
            }
        }
        $this->VehicleRegistrationNumberPlate = $vehicleRegistrationNumberPlate;
        return $this;
    }
    /**
     * Add item to VehicleRegistrationNumberPlate value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AffectedVehicleStructure
     */
    public function addToVehicleRegistrationNumberPlate($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The VehicleRegistrationNumberPlate property can only contain items of normalizedString, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleRegistrationNumberPlate[] = $item;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\AffectedVehicleStructure
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get IPAddress value
     * @return string|null
     */
    public function getIPAddress()
    {
        return $this->IPAddress;
    }
    /**
     * Set IPAddress value
     * @param string $iPAddress
     * @return \StructType\AffectedVehicleStructure
     */
    public function setIPAddress($iPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($iPAddress) && !is_string($iPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPAddress)), __LINE__);
        }
        $this->IPAddress = $iPAddress;
        return $this;
    }
    /**
     * Get RadioAddress value
     * @return string|null
     */
    public function getRadioAddress()
    {
        return $this->RadioAddress;
    }
    /**
     * Set RadioAddress value
     * @param string $radioAddress
     * @return \StructType\AffectedVehicleStructure
     */
    public function setRadioAddress($radioAddress = null)
    {
        // validation for constraint: string
        if (!is_null($radioAddress) && !is_string($radioAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($radioAddress)), __LINE__);
        }
        $this->RadioAddress = $radioAddress;
        return $this;
    }
    /**
     * Get FramedVehicleJourneyRef value
     * @return \StructType\FramedVehicleJourneyRefStructure|null
     */
    public function getFramedVehicleJourneyRef()
    {
        return $this->FramedVehicleJourneyRef;
    }
    /**
     * Set FramedVehicleJourneyRef value
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @return \StructType\AffectedVehicleStructure
     */
    public function setFramedVehicleJourneyRef(\StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null)
    {
        $this->FramedVehicleJourneyRef = $framedVehicleJourneyRef;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\LocationStructure|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\LocationStructure $location
     * @return \StructType\AffectedVehicleStructure
     */
    public function setLocation(\StructType\LocationStructure $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get CurrentLocation value
     * @return \StructType\LocationStructure|null
     */
    public function getCurrentLocation()
    {
        return $this->CurrentLocation;
    }
    /**
     * Set CurrentLocation value
     * @param \StructType\LocationStructure $currentLocation
     * @return \StructType\AffectedVehicleStructure
     */
    public function setCurrentLocation(\StructType\LocationStructure $currentLocation = null)
    {
        $this->CurrentLocation = $currentLocation;
        return $this;
    }
    /**
     * Get AccessibilityAssessment value
     * @return \StructType\AccessibilityAssessmentStructure|null
     */
    public function getAccessibilityAssessment()
    {
        return $this->AccessibilityAssessment;
    }
    /**
     * Set AccessibilityAssessment value
     * @param \StructType\AccessibilityAssessmentStructure $accessibilityAssessment
     * @return \StructType\AffectedVehicleStructure
     */
    public function setAccessibilityAssessment(\StructType\AccessibilityAssessmentStructure $accessibilityAssessment = null)
    {
        $this->AccessibilityAssessment = $accessibilityAssessment;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\AffectedVehicleStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get ProductCategoryRef value
     * @return \StructType\ProductCategoryRefStructure|null
     */
    public function getProductCategoryRef()
    {
        return $this->ProductCategoryRef;
    }
    /**
     * Set ProductCategoryRef value
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @return \StructType\AffectedVehicleStructure
     */
    public function setProductCategoryRef(\StructType\ProductCategoryRefStructure $productCategoryRef = null)
    {
        $this->ProductCategoryRef = $productCategoryRef;
        return $this;
    }
    /**
     * Get ServiceFeatureRef value
     * @return \StructType\ServiceFeatureRefStructure|null
     */
    public function getServiceFeatureRef()
    {
        return $this->ServiceFeatureRef;
    }
    /**
     * Set ServiceFeatureRef value
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @return \StructType\AffectedVehicleStructure
     */
    public function setServiceFeatureRef(\StructType\ServiceFeatureRefStructure $serviceFeatureRef = null)
    {
        $this->ServiceFeatureRef = $serviceFeatureRef;
        return $this;
    }
    /**
     * Get VehicleFeatureRef value
     * @return \StructType\VehicleFeatureRefStructure|null
     */
    public function getVehicleFeatureRef()
    {
        return $this->VehicleFeatureRef;
    }
    /**
     * Set VehicleFeatureRef value
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @return \StructType\AffectedVehicleStructure
     */
    public function setVehicleFeatureRef(\StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null)
    {
        $this->VehicleFeatureRef = $vehicleFeatureRef;
        return $this;
    }
    /**
     * Get TrainBlockPart value
     * @return \StructType\TrainBlockPartStructure[]|null
     */
    public function getTrainBlockPart()
    {
        return $this->TrainBlockPart;
    }
    /**
     * Set TrainBlockPart value
     * @throws \InvalidArgumentException
     * @param \StructType\TrainBlockPartStructure[] $trainBlockPart
     * @return \StructType\AffectedVehicleStructure
     */
    public function setTrainBlockPart(array $trainBlockPart = array())
    {
        foreach ($trainBlockPart as $affectedVehicleStructureTrainBlockPartItem) {
            // validation for constraint: itemType
            if (!$affectedVehicleStructureTrainBlockPartItem instanceof \StructType\TrainBlockPartStructure) {
                throw new \InvalidArgumentException(sprintf('The TrainBlockPart property can only contain items of \StructType\TrainBlockPartStructure, "%s" given', is_object($affectedVehicleStructureTrainBlockPartItem) ? get_class($affectedVehicleStructureTrainBlockPartItem) : gettype($affectedVehicleStructureTrainBlockPartItem)), __LINE__);
            }
        }
        $this->TrainBlockPart = $trainBlockPart;
        return $this;
    }
    /**
     * Add item to TrainBlockPart value
     * @throws \InvalidArgumentException
     * @param \StructType\TrainBlockPartStructure $item
     * @return \StructType\AffectedVehicleStructure
     */
    public function addToTrainBlockPart(\StructType\TrainBlockPartStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrainBlockPartStructure) {
            throw new \InvalidArgumentException(sprintf('The TrainBlockPart property can only contain items of \StructType\TrainBlockPartStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TrainBlockPart[] = $item;
        return $this;
    }
    /**
     * Get BlockRef value
     * @return \StructType\BlockRefStructure|null
     */
    public function getBlockRef()
    {
        return $this->BlockRef;
    }
    /**
     * Set BlockRef value
     * @param \StructType\BlockRefStructure $blockRef
     * @return \StructType\AffectedVehicleStructure
     */
    public function setBlockRef(\StructType\BlockRefStructure $blockRef = null)
    {
        $this->BlockRef = $blockRef;
        return $this;
    }
    /**
     * Get CourseOfJourneyRef value
     * @return \StructType\CourseOfJourneyRefStructure|null
     */
    public function getCourseOfJourneyRef()
    {
        return $this->CourseOfJourneyRef;
    }
    /**
     * Set CourseOfJourneyRef value
     * @param \StructType\CourseOfJourneyRefStructure $courseOfJourneyRef
     * @return \StructType\AffectedVehicleStructure
     */
    public function setCourseOfJourneyRef(\StructType\CourseOfJourneyRefStructure $courseOfJourneyRef = null)
    {
        $this->CourseOfJourneyRef = $courseOfJourneyRef;
        return $this;
    }
    /**
     * Get InCongestion value
     * @return bool|null
     */
    public function getInCongestion()
    {
        return $this->InCongestion;
    }
    /**
     * Set InCongestion value
     * @param bool $inCongestion
     * @return \StructType\AffectedVehicleStructure
     */
    public function setInCongestion($inCongestion = null)
    {
        // validation for constraint: boolean
        if (!is_null($inCongestion) && !is_bool($inCongestion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inCongestion)), __LINE__);
        }
        $this->InCongestion = $inCongestion;
        return $this;
    }
    /**
     * Get InPanic value
     * @return bool|null
     */
    public function getInPanic()
    {
        return $this->InPanic;
    }
    /**
     * Set InPanic value
     * @param bool $inPanic
     * @return \StructType\AffectedVehicleStructure
     */
    public function setInPanic($inPanic = false)
    {
        // validation for constraint: boolean
        if (!is_null($inPanic) && !is_bool($inPanic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inPanic)), __LINE__);
        }
        $this->InPanic = $inPanic;
        return $this;
    }
    /**
     * Get HeadwayService value
     * @return bool|null
     */
    public function getHeadwayService()
    {
        return $this->HeadwayService;
    }
    /**
     * Set HeadwayService value
     * @param bool $headwayService
     * @return \StructType\AffectedVehicleStructure
     */
    public function setHeadwayService($headwayService = false)
    {
        // validation for constraint: boolean
        if (!is_null($headwayService) && !is_bool($headwayService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($headwayService)), __LINE__);
        }
        $this->HeadwayService = $headwayService;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedVehicleStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedVehicleStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
