<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedStopPointStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for an SCHEDUELD STOP POINT affected by a SITUATION.
 * @subpackage Structs
 */
class AffectedStopPointStructure extends AbstractStructBase
{
    /**
     * The StopPointRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The PrivateRef
     * Meta informations extracted from the WSDL
     * - documentation: Alternative private code of stop.
     * - minOccurs: 0
     * @var string
     */
    public $PrivateRef;
    /**
     * The StopPointName
     * Meta informations extracted from the WSDL
     * - documentation: Name of SCHEDULED STOP POIHT. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $StopPointName;
    /**
     * The StopPointType
     * Meta informations extracted from the WSDL
     * - documentation: Type of stop type. Normally implicit in VEHICLE mode. TPEG table pti 17_4
     * - minOccurs: 0
     * @var string
     */
    public $StopPointType;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - documentation: Spatial coordinates of STOP POINT. Derivable from StopRef.
     * - minOccurs: 0
     * @var \StructType\LocationStructure
     */
    public $Location;
    /**
     * The AffectedModes
     * Meta informations extracted from the WSDL
     * - documentation: Modes within station/stop affected by the SITUATION. If not specified, assume all modes of that station.
     * - minOccurs: 0
     * @var \StructType\AffectedModesStructure
     */
    public $AffectedModes;
    /**
     * The PlaceRef
     * Meta informations extracted from the WSDL
     * - documentation: Refernce to a SITE or TOPOGRAPHIC PLACE affected by the Locality of stop (In UK NPtg Locality Code). Derivable from StopRef.
     * - minOccurs: 0
     * @var \StructType\ZoneRefStructure
     */
    public $PlaceRef;
    /**
     * The PlaceName
     * Meta informations extracted from the WSDL
     * - documentation: Name of locality in which stop is found. Derivable from LocalityRef. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $PlaceName;
    /**
     * The AccessibilityAssessment
     * Meta informations extracted from the WSDL
     * - documentation: Assesment of current ACCESSIBILITY of the STOP POINT as affected by the SITUATION.
     * - minOccurs: 0
     * @var \StructType\AccessibilityAssessmentStructure
     */
    public $AccessibilityAssessment;
    /**
     * The StopCondition
     * Meta informations extracted from the WSDL
     * - documentation: Status of STOP
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $StopCondition;
    /**
     * The ConnectionLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ConnectionLinks
     */
    public $ConnectionLinks;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedStopPointStructure
     * @uses AffectedStopPointStructure::setStopPointRef()
     * @uses AffectedStopPointStructure::setPrivateRef()
     * @uses AffectedStopPointStructure::setStopPointName()
     * @uses AffectedStopPointStructure::setStopPointType()
     * @uses AffectedStopPointStructure::setLocation()
     * @uses AffectedStopPointStructure::setAffectedModes()
     * @uses AffectedStopPointStructure::setPlaceRef()
     * @uses AffectedStopPointStructure::setPlaceName()
     * @uses AffectedStopPointStructure::setAccessibilityAssessment()
     * @uses AffectedStopPointStructure::setStopCondition()
     * @uses AffectedStopPointStructure::setConnectionLinks()
     * @uses AffectedStopPointStructure::setExtensions()
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param string $privateRef
     * @param \StructType\NaturalLanguageStringStructure[] $stopPointName
     * @param string $stopPointType
     * @param \StructType\LocationStructure $location
     * @param \StructType\AffectedModesStructure $affectedModes
     * @param \StructType\ZoneRefStructure $placeRef
     * @param \StructType\NaturalLanguageStringStructure[] $placeName
     * @param \StructType\AccessibilityAssessmentStructure $accessibilityAssessment
     * @param string[] $stopCondition
     * @param \StructType\ConnectionLinks $connectionLinks
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\StopPointRefStructure $stopPointRef = null, $privateRef = null, array $stopPointName = array(), $stopPointType = null, \StructType\LocationStructure $location = null, \StructType\AffectedModesStructure $affectedModes = null, \StructType\ZoneRefStructure $placeRef = null, array $placeName = array(), \StructType\AccessibilityAssessmentStructure $accessibilityAssessment = null, array $stopCondition = array(), \StructType\ConnectionLinks $connectionLinks = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setStopPointRef($stopPointRef)
            ->setPrivateRef($privateRef)
            ->setStopPointName($stopPointName)
            ->setStopPointType($stopPointType)
            ->setLocation($location)
            ->setAffectedModes($affectedModes)
            ->setPlaceRef($placeRef)
            ->setPlaceName($placeName)
            ->setAccessibilityAssessment($accessibilityAssessment)
            ->setStopCondition($stopCondition)
            ->setConnectionLinks($connectionLinks)
            ->setExtensions($extensions);
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\AffectedStopPointStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get PrivateRef value
     * @return string|null
     */
    public function getPrivateRef()
    {
        return $this->PrivateRef;
    }
    /**
     * Set PrivateRef value
     * @param string $privateRef
     * @return \StructType\AffectedStopPointStructure
     */
    public function setPrivateRef($privateRef = null)
    {
        // validation for constraint: string
        if (!is_null($privateRef) && !is_string($privateRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($privateRef)), __LINE__);
        }
        $this->PrivateRef = $privateRef;
        return $this;
    }
    /**
     * Get StopPointName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getStopPointName()
    {
        return $this->StopPointName;
    }
    /**
     * Set StopPointName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $stopPointName
     * @return \StructType\AffectedStopPointStructure
     */
    public function setStopPointName(array $stopPointName = array())
    {
        foreach ($stopPointName as $affectedStopPointStructureStopPointNameItem) {
            // validation for constraint: itemType
            if (!$affectedStopPointStructureStopPointNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The StopPointName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedStopPointStructureStopPointNameItem) ? get_class($affectedStopPointStructureStopPointNameItem) : gettype($affectedStopPointStructureStopPointNameItem)), __LINE__);
            }
        }
        $this->StopPointName = $stopPointName;
        return $this;
    }
    /**
     * Add item to StopPointName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedStopPointStructure
     */
    public function addToStopPointName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The StopPointName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StopPointName[] = $item;
        return $this;
    }
    /**
     * Get StopPointType value
     * @return string|null
     */
    public function getStopPointType()
    {
        return $this->StopPointType;
    }
    /**
     * Set StopPointType value
     * @uses \EnumType\StopPointTypeEnumeration::valueIsValid()
     * @uses \EnumType\StopPointTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopPointType
     * @return \StructType\AffectedStopPointStructure
     */
    public function setStopPointType($stopPointType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StopPointTypeEnumeration::valueIsValid($stopPointType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stopPointType, implode(', ', \EnumType\StopPointTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->StopPointType = $stopPointType;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\LocationStructure|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\LocationStructure $location
     * @return \StructType\AffectedStopPointStructure
     */
    public function setLocation(\StructType\LocationStructure $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get AffectedModes value
     * @return \StructType\AffectedModesStructure|null
     */
    public function getAffectedModes()
    {
        return $this->AffectedModes;
    }
    /**
     * Set AffectedModes value
     * @param \StructType\AffectedModesStructure $affectedModes
     * @return \StructType\AffectedStopPointStructure
     */
    public function setAffectedModes(\StructType\AffectedModesStructure $affectedModes = null)
    {
        $this->AffectedModes = $affectedModes;
        return $this;
    }
    /**
     * Get PlaceRef value
     * @return \StructType\ZoneRefStructure|null
     */
    public function getPlaceRef()
    {
        return $this->PlaceRef;
    }
    /**
     * Set PlaceRef value
     * @param \StructType\ZoneRefStructure $placeRef
     * @return \StructType\AffectedStopPointStructure
     */
    public function setPlaceRef(\StructType\ZoneRefStructure $placeRef = null)
    {
        $this->PlaceRef = $placeRef;
        return $this;
    }
    /**
     * Get PlaceName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getPlaceName()
    {
        return $this->PlaceName;
    }
    /**
     * Set PlaceName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $placeName
     * @return \StructType\AffectedStopPointStructure
     */
    public function setPlaceName(array $placeName = array())
    {
        foreach ($placeName as $affectedStopPointStructurePlaceNameItem) {
            // validation for constraint: itemType
            if (!$affectedStopPointStructurePlaceNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The PlaceName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedStopPointStructurePlaceNameItem) ? get_class($affectedStopPointStructurePlaceNameItem) : gettype($affectedStopPointStructurePlaceNameItem)), __LINE__);
            }
        }
        $this->PlaceName = $placeName;
        return $this;
    }
    /**
     * Add item to PlaceName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedStopPointStructure
     */
    public function addToPlaceName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The PlaceName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlaceName[] = $item;
        return $this;
    }
    /**
     * Get AccessibilityAssessment value
     * @return \StructType\AccessibilityAssessmentStructure|null
     */
    public function getAccessibilityAssessment()
    {
        return $this->AccessibilityAssessment;
    }
    /**
     * Set AccessibilityAssessment value
     * @param \StructType\AccessibilityAssessmentStructure $accessibilityAssessment
     * @return \StructType\AffectedStopPointStructure
     */
    public function setAccessibilityAssessment(\StructType\AccessibilityAssessmentStructure $accessibilityAssessment = null)
    {
        $this->AccessibilityAssessment = $accessibilityAssessment;
        return $this;
    }
    /**
     * Get StopCondition value
     * @return string[]|null
     */
    public function getStopCondition()
    {
        return $this->StopCondition;
    }
    /**
     * Set StopCondition value
     * @uses \EnumType\RoutePointTypeEnumeration::valueIsValid()
     * @uses \EnumType\RoutePointTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $stopCondition
     * @return \StructType\AffectedStopPointStructure
     */
    public function setStopCondition(array $stopCondition = array())
    {
        $invalidValues = array();
        foreach ($stopCondition as $affectedStopPointStructureStopConditionItem) {
            if (!\EnumType\RoutePointTypeEnumeration::valueIsValid($affectedStopPointStructureStopConditionItem)) {
                $invalidValues[] = var_export($affectedStopPointStructureStopConditionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\RoutePointTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->StopCondition = $stopCondition;
        return $this;
    }
    /**
     * Add item to StopCondition value
     * @uses \EnumType\RoutePointTypeEnumeration::valueIsValid()
     * @uses \EnumType\RoutePointTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AffectedStopPointStructure
     */
    public function addToStopCondition($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoutePointTypeEnumeration::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\RoutePointTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->StopCondition[] = $item;
        return $this;
    }
    /**
     * Get ConnectionLinks value
     * @return \StructType\ConnectionLinks|null
     */
    public function getConnectionLinks()
    {
        return $this->ConnectionLinks;
    }
    /**
     * Set ConnectionLinks value
     * @param \StructType\ConnectionLinks $connectionLinks
     * @return \StructType\AffectedStopPointStructure
     */
    public function setConnectionLinks(\StructType\ConnectionLinks $connectionLinks = null)
    {
        $this->ConnectionLinks = $connectionLinks;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedStopPointStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedStopPointStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
