<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedSectionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for information about the sectons affected by a SITUATION. | Spatial projection of element that can be used to show affected area on a map.
 * @subpackage Structs
 */
class AffectedSectionStructure extends AbstractStructBase
{
    /**
     * The SectionRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a section of ROUTE affected by a SITUATION.
     * - minOccurs: 0
     * @var \StructType\SectionRefStructure
     */
    public $SectionRef;
    /**
     * The LinkProjection
     * @var \StructType\LinkProjectionStructure
     */
    public $LinkProjection;
    /**
     * The Offset
     * @var \StructType\OffsetStructure
     */
    public $Offset;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedSectionStructure
     * @uses AffectedSectionStructure::setSectionRef()
     * @uses AffectedSectionStructure::setLinkProjection()
     * @uses AffectedSectionStructure::setOffset()
     * @uses AffectedSectionStructure::setExtensions()
     * @param \StructType\SectionRefStructure $sectionRef
     * @param \StructType\LinkProjectionStructure $linkProjection
     * @param \StructType\OffsetStructure $offset
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\SectionRefStructure $sectionRef = null, \StructType\LinkProjectionStructure $linkProjection = null, \StructType\OffsetStructure $offset = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setSectionRef($sectionRef)
            ->setLinkProjection($linkProjection)
            ->setOffset($offset)
            ->setExtensions($extensions);
    }
    /**
     * Get SectionRef value
     * @return \StructType\SectionRefStructure|null
     */
    public function getSectionRef()
    {
        return $this->SectionRef;
    }
    /**
     * Set SectionRef value
     * @param \StructType\SectionRefStructure $sectionRef
     * @return \StructType\AffectedSectionStructure
     */
    public function setSectionRef(\StructType\SectionRefStructure $sectionRef = null)
    {
        $this->SectionRef = $sectionRef;
        return $this;
    }
    /**
     * Get LinkProjection value
     * @return \StructType\LinkProjectionStructure|null
     */
    public function getLinkProjection()
    {
        return $this->LinkProjection;
    }
    /**
     * Set LinkProjection value
     * @param \StructType\LinkProjectionStructure $linkProjection
     * @return \StructType\AffectedSectionStructure
     */
    public function setLinkProjection(\StructType\LinkProjectionStructure $linkProjection = null)
    {
        $this->LinkProjection = $linkProjection;
        return $this;
    }
    /**
     * Get Offset value
     * @return \StructType\OffsetStructure|null
     */
    public function getOffset()
    {
        return $this->Offset;
    }
    /**
     * Set Offset value
     * @param \StructType\OffsetStructure $offset
     * @return \StructType\AffectedSectionStructure
     */
    public function setOffset(\StructType\OffsetStructure $offset = null)
    {
        $this->Offset = $offset;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedSectionStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedSectionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
