<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedPathLinkStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Information about a CONNECTION link from a given stop affected by a SITUATION. | Spatial projection of element that can be used to show affected area on a map.
 * @subpackage Structs
 */
class AffectedPathLinkStructure extends AbstractStructBase
{
    /**
     * The LinkRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of CONNECTION link.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $LinkRef;
    /**
     * The LinkName
     * Meta informations extracted from the WSDL
     * - documentation: Description of Link. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $LinkName;
    /**
     * The AccessibilityFeature
     * Meta informations extracted from the WSDL
     * - documentation: Nature of CONNECTION link.
     * - minOccurs: 0
     * @var string
     */
    public $AccessibilityFeature;
    /**
     * The LinkDirection
     * Meta informations extracted from the WSDL
     * - documentation: Description of a DIRECTION of CONNECTION link.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $LinkDirection;
    /**
     * The LinkProjection
     * @var \StructType\LinkProjectionStructure
     */
    public $LinkProjection;
    /**
     * The Offset
     * @var \StructType\OffsetStructure
     */
    public $Offset;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedPathLinkStructure
     * @uses AffectedPathLinkStructure::setLinkRef()
     * @uses AffectedPathLinkStructure::setLinkName()
     * @uses AffectedPathLinkStructure::setAccessibilityFeature()
     * @uses AffectedPathLinkStructure::setLinkDirection()
     * @uses AffectedPathLinkStructure::setLinkProjection()
     * @uses AffectedPathLinkStructure::setOffset()
     * @uses AffectedPathLinkStructure::setExtensions()
     * @param string[] $linkRef
     * @param \StructType\NaturalLanguageStringStructure[] $linkName
     * @param string $accessibilityFeature
     * @param string[] $linkDirection
     * @param \StructType\LinkProjectionStructure $linkProjection
     * @param \StructType\OffsetStructure $offset
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(array $linkRef = array(), array $linkName = array(), $accessibilityFeature = null, array $linkDirection = array(), \StructType\LinkProjectionStructure $linkProjection = null, \StructType\OffsetStructure $offset = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setLinkRef($linkRef)
            ->setLinkName($linkName)
            ->setAccessibilityFeature($accessibilityFeature)
            ->setLinkDirection($linkDirection)
            ->setLinkProjection($linkProjection)
            ->setOffset($offset)
            ->setExtensions($extensions);
    }
    /**
     * Get LinkRef value
     * @return string[]|null
     */
    public function getLinkRef()
    {
        return $this->LinkRef;
    }
    /**
     * Set LinkRef value
     * @throws \InvalidArgumentException
     * @param string[] $linkRef
     * @return \StructType\AffectedPathLinkStructure
     */
    public function setLinkRef(array $linkRef = array())
    {
        foreach ($linkRef as $affectedPathLinkStructureLinkRefItem) {
            // validation for constraint: itemType
            if (!is_string($affectedPathLinkStructureLinkRefItem)) {
                throw new \InvalidArgumentException(sprintf('The LinkRef property can only contain items of NMTOKEN, "%s" given', is_object($affectedPathLinkStructureLinkRefItem) ? get_class($affectedPathLinkStructureLinkRefItem) : gettype($affectedPathLinkStructureLinkRefItem)), __LINE__);
            }
        }
        $this->LinkRef = $linkRef;
        return $this;
    }
    /**
     * Add item to LinkRef value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AffectedPathLinkStructure
     */
    public function addToLinkRef($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The LinkRef property can only contain items of NMTOKEN, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LinkRef[] = $item;
        return $this;
    }
    /**
     * Get LinkName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getLinkName()
    {
        return $this->LinkName;
    }
    /**
     * Set LinkName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $linkName
     * @return \StructType\AffectedPathLinkStructure
     */
    public function setLinkName(array $linkName = array())
    {
        foreach ($linkName as $affectedPathLinkStructureLinkNameItem) {
            // validation for constraint: itemType
            if (!$affectedPathLinkStructureLinkNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The LinkName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedPathLinkStructureLinkNameItem) ? get_class($affectedPathLinkStructureLinkNameItem) : gettype($affectedPathLinkStructureLinkNameItem)), __LINE__);
            }
        }
        $this->LinkName = $linkName;
        return $this;
    }
    /**
     * Add item to LinkName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedPathLinkStructure
     */
    public function addToLinkName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The LinkName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LinkName[] = $item;
        return $this;
    }
    /**
     * Get AccessibilityFeature value
     * @return string|null
     */
    public function getAccessibilityFeature()
    {
        return $this->AccessibilityFeature;
    }
    /**
     * Set AccessibilityFeature value
     * @uses \EnumType\AccessibilityFeatureEnumeration::valueIsValid()
     * @uses \EnumType\AccessibilityFeatureEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessibilityFeature
     * @return \StructType\AffectedPathLinkStructure
     */
    public function setAccessibilityFeature($accessibilityFeature = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccessibilityFeatureEnumeration::valueIsValid($accessibilityFeature)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accessibilityFeature, implode(', ', \EnumType\AccessibilityFeatureEnumeration::getValidValues())), __LINE__);
        }
        $this->AccessibilityFeature = $accessibilityFeature;
        return $this;
    }
    /**
     * Get LinkDirection value
     * @return string[]|null
     */
    public function getLinkDirection()
    {
        return $this->LinkDirection;
    }
    /**
     * Set LinkDirection value
     * @throws \InvalidArgumentException
     * @param string[] $linkDirection
     * @return \StructType\AffectedPathLinkStructure
     */
    public function setLinkDirection(array $linkDirection = array())
    {
        foreach ($linkDirection as $affectedPathLinkStructureLinkDirectionItem) {
            // validation for constraint: itemType
            if (!is_string($affectedPathLinkStructureLinkDirectionItem)) {
                throw new \InvalidArgumentException(sprintf('The LinkDirection property can only contain items of string, "%s" given', is_object($affectedPathLinkStructureLinkDirectionItem) ? get_class($affectedPathLinkStructureLinkDirectionItem) : gettype($affectedPathLinkStructureLinkDirectionItem)), __LINE__);
            }
        }
        $this->LinkDirection = $linkDirection;
        return $this;
    }
    /**
     * Add item to LinkDirection value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AffectedPathLinkStructure
     */
    public function addToLinkDirection($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The LinkDirection property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LinkDirection[] = $item;
        return $this;
    }
    /**
     * Get LinkProjection value
     * @return \StructType\LinkProjectionStructure|null
     */
    public function getLinkProjection()
    {
        return $this->LinkProjection;
    }
    /**
     * Set LinkProjection value
     * @param \StructType\LinkProjectionStructure $linkProjection
     * @return \StructType\AffectedPathLinkStructure
     */
    public function setLinkProjection(\StructType\LinkProjectionStructure $linkProjection = null)
    {
        $this->LinkProjection = $linkProjection;
        return $this;
    }
    /**
     * Get Offset value
     * @return \StructType\OffsetStructure|null
     */
    public function getOffset()
    {
        return $this->Offset;
    }
    /**
     * Set Offset value
     * @param \StructType\OffsetStructure $offset
     * @return \StructType\AffectedPathLinkStructure
     */
    public function setOffset(\StructType\OffsetStructure $offset = null)
    {
        $this->Offset = $offset;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedPathLinkStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedPathLinkStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
