<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedFacilityStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for information about a FACILITY affected by an SITUATION. (+SIRI 2.0)
 * @subpackage Structs
 */
class AffectedFacilityStructure extends AbstractStructBase
{
    /**
     * The FacilityRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: FacilityRef
     * @var \StructType\FacilityRefStructure
     */
    public $FacilityRef;
    /**
     * The StartStopPointRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of stop point at which availability first applies.
     * - minOccurs: 0
     * @var \StructType\StopPointRefStructure
     */
    public $StartStopPointRef;
    /**
     * The EndStopPointRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of stop point at which availability last applies.
     * - minOccurs: 0
     * @var \StructType\StopPointRefStructure
     */
    public $EndStopPointRef;
    /**
     * The FacilityName
     * Meta informations extracted from the WSDL
     * - documentation: Name of FACILITY.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $FacilityName;
    /**
     * The FacilityStatus
     * Meta informations extracted from the WSDL
     * - documentation: Status of Facility
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FacilityStatus;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure[]
     */
    public $Extensions;
    /**
     * Constructor method for AffectedFacilityStructure
     * @uses AffectedFacilityStructure::setFacilityRef()
     * @uses AffectedFacilityStructure::setStartStopPointRef()
     * @uses AffectedFacilityStructure::setEndStopPointRef()
     * @uses AffectedFacilityStructure::setFacilityName()
     * @uses AffectedFacilityStructure::setFacilityStatus()
     * @uses AffectedFacilityStructure::setExtensions()
     * @param \StructType\FacilityRefStructure $facilityRef
     * @param \StructType\StopPointRefStructure $startStopPointRef
     * @param \StructType\StopPointRefStructure $endStopPointRef
     * @param \StructType\NaturalLanguageStringStructure[] $facilityName
     * @param string[] $facilityStatus
     * @param \StructType\ExtensionsStructure[] $extensions
     */
    public function __construct(\StructType\FacilityRefStructure $facilityRef = null, \StructType\StopPointRefStructure $startStopPointRef = null, \StructType\StopPointRefStructure $endStopPointRef = null, array $facilityName = array(), array $facilityStatus = array(), array $extensions = array())
    {
        $this
            ->setFacilityRef($facilityRef)
            ->setStartStopPointRef($startStopPointRef)
            ->setEndStopPointRef($endStopPointRef)
            ->setFacilityName($facilityName)
            ->setFacilityStatus($facilityStatus)
            ->setExtensions($extensions);
    }
    /**
     * Get FacilityRef value
     * @return \StructType\FacilityRefStructure|null
     */
    public function getFacilityRef()
    {
        return $this->FacilityRef;
    }
    /**
     * Set FacilityRef value
     * @param \StructType\FacilityRefStructure $facilityRef
     * @return \StructType\AffectedFacilityStructure
     */
    public function setFacilityRef(\StructType\FacilityRefStructure $facilityRef = null)
    {
        $this->FacilityRef = $facilityRef;
        return $this;
    }
    /**
     * Get StartStopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStartStopPointRef()
    {
        return $this->StartStopPointRef;
    }
    /**
     * Set StartStopPointRef value
     * @param \StructType\StopPointRefStructure $startStopPointRef
     * @return \StructType\AffectedFacilityStructure
     */
    public function setStartStopPointRef(\StructType\StopPointRefStructure $startStopPointRef = null)
    {
        $this->StartStopPointRef = $startStopPointRef;
        return $this;
    }
    /**
     * Get EndStopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getEndStopPointRef()
    {
        return $this->EndStopPointRef;
    }
    /**
     * Set EndStopPointRef value
     * @param \StructType\StopPointRefStructure $endStopPointRef
     * @return \StructType\AffectedFacilityStructure
     */
    public function setEndStopPointRef(\StructType\StopPointRefStructure $endStopPointRef = null)
    {
        $this->EndStopPointRef = $endStopPointRef;
        return $this;
    }
    /**
     * Get FacilityName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getFacilityName()
    {
        return $this->FacilityName;
    }
    /**
     * Set FacilityName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $facilityName
     * @return \StructType\AffectedFacilityStructure
     */
    public function setFacilityName(array $facilityName = array())
    {
        foreach ($facilityName as $affectedFacilityStructureFacilityNameItem) {
            // validation for constraint: itemType
            if (!$affectedFacilityStructureFacilityNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The FacilityName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedFacilityStructureFacilityNameItem) ? get_class($affectedFacilityStructureFacilityNameItem) : gettype($affectedFacilityStructureFacilityNameItem)), __LINE__);
            }
        }
        $this->FacilityName = $facilityName;
        return $this;
    }
    /**
     * Add item to FacilityName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedFacilityStructure
     */
    public function addToFacilityName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The FacilityName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FacilityName[] = $item;
        return $this;
    }
    /**
     * Get FacilityStatus value
     * @return string[]|null
     */
    public function getFacilityStatus()
    {
        return $this->FacilityStatus;
    }
    /**
     * Set FacilityStatus value
     * @uses \EnumType\FacilityStatusEnumeration::valueIsValid()
     * @uses \EnumType\FacilityStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $facilityStatus
     * @return \StructType\AffectedFacilityStructure
     */
    public function setFacilityStatus(array $facilityStatus = array())
    {
        $invalidValues = array();
        foreach ($facilityStatus as $affectedFacilityStructureFacilityStatusItem) {
            if (!\EnumType\FacilityStatusEnumeration::valueIsValid($affectedFacilityStructureFacilityStatusItem)) {
                $invalidValues[] = var_export($affectedFacilityStructureFacilityStatusItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\FacilityStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->FacilityStatus = $facilityStatus;
        return $this;
    }
    /**
     * Add item to FacilityStatus value
     * @uses \EnumType\FacilityStatusEnumeration::valueIsValid()
     * @uses \EnumType\FacilityStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AffectedFacilityStructure
     */
    public function addToFacilityStatus($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FacilityStatusEnumeration::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\FacilityStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->FacilityStatus[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure[]|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtensionsStructure[] $extensions
     * @return \StructType\AffectedFacilityStructure
     */
    public function setExtensions(array $extensions = array())
    {
        foreach ($extensions as $affectedFacilityStructureExtensionsItem) {
            // validation for constraint: itemType
            if (!$affectedFacilityStructureExtensionsItem instanceof \StructType\ExtensionsStructure) {
                throw new \InvalidArgumentException(sprintf('The Extensions property can only contain items of \StructType\ExtensionsStructure, "%s" given', is_object($affectedFacilityStructureExtensionsItem) ? get_class($affectedFacilityStructureExtensionsItem) : gettype($affectedFacilityStructureExtensionsItem)), __LINE__);
            }
        }
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Add item to Extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtensionsStructure $item
     * @return \StructType\AffectedFacilityStructure
     */
    public function addToExtensions(\StructType\ExtensionsStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExtensionsStructure) {
            throw new \InvalidArgumentException(sprintf('The Extensions property can only contain items of \StructType\ExtensionsStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Extensions[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedFacilityStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
