<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdministratorVersionedRefStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a versioned reference to an ORGANISATION with administrative responsibility. | Type for identifier of an ORGANISATION with administrative responsibility.
 * @subpackage Structs
 */
class AdministratorVersionedRefStructure extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: Type for identifier of an ORGANISATION with administrative responsibility.
     * @var string
     */
    public $_;
    /**
     * The created
     * @var string
     */
    public $created;
    /**
     * The lastUpdated
     * @var string
     */
    public $lastUpdated;
    /**
     * The modification
     * @var string
     */
    public $modification;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - documentation: A revision number is an integer that should be increased by one each time the unit that is refers to is modified.
     * @var int
     */
    public $version;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * Constructor method for AdministratorVersionedRefStructure
     * @uses AdministratorVersionedRefStructure::set_()
     * @uses AdministratorVersionedRefStructure::setCreated()
     * @uses AdministratorVersionedRefStructure::setLastUpdated()
     * @uses AdministratorVersionedRefStructure::setModification()
     * @uses AdministratorVersionedRefStructure::setVersion()
     * @uses AdministratorVersionedRefStructure::setStatus()
     * @param string $_
     * @param string $created
     * @param string $lastUpdated
     * @param string $modification
     * @param int $version
     * @param string $status
     */
    public function __construct($_ = null, $created = null, $lastUpdated = null, $modification = null, $version = null, $status = null)
    {
        $this
            ->set_($_)
            ->setCreated($created)
            ->setLastUpdated($lastUpdated)
            ->setModification($modification)
            ->setVersion($version)
            ->setStatus($status);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\AdministratorVersionedRefStructure
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get created value
     * @return string|null
     */
    public function getCreated()
    {
        return $this->created;
    }
    /**
     * Set created value
     * @param string $created
     * @return \StructType\AdministratorVersionedRefStructure
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created)), __LINE__);
        }
        $this->created = $created;
        return $this;
    }
    /**
     * Get lastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->lastUpdated;
    }
    /**
     * Set lastUpdated value
     * @param string $lastUpdated
     * @return \StructType\AdministratorVersionedRefStructure
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdated)), __LINE__);
        }
        $this->lastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Get modification value
     * @return string|null
     */
    public function getModification()
    {
        return $this->modification;
    }
    /**
     * Set modification value
     * @uses \EnumType\ModificationEnumeration::valueIsValid()
     * @uses \EnumType\ModificationEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $modification
     * @return \StructType\AdministratorVersionedRefStructure
     */
    public function setModification($modification = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModificationEnumeration::valueIsValid($modification)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $modification, implode(', ', \EnumType\ModificationEnumeration::getValidValues())), __LINE__);
        }
        $this->modification = $modification;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\AdministratorVersionedRefStructure
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !is_numeric($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\StatusEnumeration::valueIsValid()
     * @uses \EnumType\StatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\AdministratorVersionedRefStructure
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusEnumeration::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\StatusEnumeration::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdministratorVersionedRefStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
