<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActionDataStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for list of SITUATIONs.
 * @subpackage Structs
 */
class ActionDataStructure extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Name of action data Element.
     * @var string
     */
    public $Name;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Data type of action data.
     * @var string
     */
    public $Type;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - documentation: Value for action.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $Value;
    /**
     * The Prompt
     * Meta informations extracted from the WSDL
     * - documentation: Display prompt for presenting action to user. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Prompt;
    /**
     * Constructor method for ActionDataStructure
     * @uses ActionDataStructure::setName()
     * @uses ActionDataStructure::setType()
     * @uses ActionDataStructure::setValue()
     * @uses ActionDataStructure::setPrompt()
     * @param string $name
     * @param string $type
     * @param mixed[] $value
     * @param \StructType\NaturalLanguageStringStructure[] $prompt
     */
    public function __construct($name = null, $type = null, array $value = array(), array $prompt = array())
    {
        $this
            ->setName($name)
            ->setType($type)
            ->setValue($value)
            ->setPrompt($prompt);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ActionDataStructure
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ActionDataStructure
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Value value
     * @return mixed[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @throws \InvalidArgumentException
     * @param mixed[] $value
     * @return \StructType\ActionDataStructure
     */
    public function setValue(array $value = array())
    {
        foreach ($value as $actionDataStructureValueItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The Value property can only contain items of anyType, "%s" given', is_object($actionDataStructureValueItem) ? get_class($actionDataStructureValueItem) : gettype($actionDataStructureValueItem)), __LINE__);
            }
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Add item to Value value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\ActionDataStructure
     */
    public function addToValue($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The Value property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
    /**
     * Get Prompt value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getPrompt()
    {
        return $this->Prompt;
    }
    /**
     * Set Prompt value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $prompt
     * @return \StructType\ActionDataStructure
     */
    public function setPrompt(array $prompt = array())
    {
        foreach ($prompt as $actionDataStructurePromptItem) {
            // validation for constraint: itemType
            if (!$actionDataStructurePromptItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Prompt property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($actionDataStructurePromptItem) ? get_class($actionDataStructurePromptItem) : gettype($actionDataStructurePromptItem)), __LINE__);
            }
        }
        $this->Prompt = $prompt;
        return $this;
    }
    /**
     * Add item to Prompt value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\ActionDataStructure
     */
    public function addToPrompt(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Prompt property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Prompt[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActionDataStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
