<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Accident StructType
 * @subpackage Structs
 */
class Accident extends TrafficElement
{
    /**
     * The accidentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $accidentType;
    /**
     * The accidentCause
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accidentCause;
    /**
     * The totalNumberOfPeopleInvolved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $totalNumberOfPeopleInvolved;
    /**
     * The totalNumberOfVehiclesInvolved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $totalNumberOfVehiclesInvolved;
    /**
     * The vehicleInvolved
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Vehicle[]
     */
    public $vehicleInvolved;
    /**
     * The groupOfVehiclesInvolved
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GroupOfVehiclesInvolved[]
     */
    public $groupOfVehiclesInvolved;
    /**
     * The groupOfPeopleInvolved
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GroupOfPeopleInvolved[]
     */
    public $groupOfPeopleInvolved;
    /**
     * The accidentExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $accidentExtension;
    /**
     * Constructor method for Accident
     * @uses Accident::setAccidentType()
     * @uses Accident::setAccidentCause()
     * @uses Accident::setTotalNumberOfPeopleInvolved()
     * @uses Accident::setTotalNumberOfVehiclesInvolved()
     * @uses Accident::setVehicleInvolved()
     * @uses Accident::setGroupOfVehiclesInvolved()
     * @uses Accident::setGroupOfPeopleInvolved()
     * @uses Accident::setAccidentExtension()
     * @param string[] $accidentType
     * @param string $accidentCause
     * @param int $totalNumberOfPeopleInvolved
     * @param int $totalNumberOfVehiclesInvolved
     * @param \StructType\Vehicle[] $vehicleInvolved
     * @param \StructType\GroupOfVehiclesInvolved[] $groupOfVehiclesInvolved
     * @param \StructType\GroupOfPeopleInvolved[] $groupOfPeopleInvolved
     * @param \StructType\ExtensionType $accidentExtension
     */
    public function __construct(array $accidentType = array(), $accidentCause = null, $totalNumberOfPeopleInvolved = null, $totalNumberOfVehiclesInvolved = null, array $vehicleInvolved = array(), array $groupOfVehiclesInvolved = array(), array $groupOfPeopleInvolved = array(), \StructType\ExtensionType $accidentExtension = null)
    {
        $this
            ->setAccidentType($accidentType)
            ->setAccidentCause($accidentCause)
            ->setTotalNumberOfPeopleInvolved($totalNumberOfPeopleInvolved)
            ->setTotalNumberOfVehiclesInvolved($totalNumberOfVehiclesInvolved)
            ->setVehicleInvolved($vehicleInvolved)
            ->setGroupOfVehiclesInvolved($groupOfVehiclesInvolved)
            ->setGroupOfPeopleInvolved($groupOfPeopleInvolved)
            ->setAccidentExtension($accidentExtension);
    }
    /**
     * Get accidentType value
     * @return string[]
     */
    public function getAccidentType()
    {
        return $this->accidentType;
    }
    /**
     * Set accidentType value
     * @uses \EnumType\AccidentTypeEnum::valueIsValid()
     * @uses \EnumType\AccidentTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accidentType
     * @return \StructType\Accident
     */
    public function setAccidentType(array $accidentType = array())
    {
        $invalidValues = array();
        foreach ($accidentType as $accidentAccidentTypeItem) {
            if (!\EnumType\AccidentTypeEnum::valueIsValid($accidentAccidentTypeItem)) {
                $invalidValues[] = var_export($accidentAccidentTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\AccidentTypeEnum::getValidValues())), __LINE__);
        }
        $this->accidentType = $accidentType;
        return $this;
    }
    /**
     * Add item to accidentType value
     * @uses \EnumType\AccidentTypeEnum::valueIsValid()
     * @uses \EnumType\AccidentTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Accident
     */
    public function addToAccidentType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccidentTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\AccidentTypeEnum::getValidValues())), __LINE__);
        }
        $this->accidentType[] = $item;
        return $this;
    }
    /**
     * Get accidentCause value
     * @return string|null
     */
    public function getAccidentCause()
    {
        return $this->accidentCause;
    }
    /**
     * Set accidentCause value
     * @uses \EnumType\AccidentCauseEnum::valueIsValid()
     * @uses \EnumType\AccidentCauseEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accidentCause
     * @return \StructType\Accident
     */
    public function setAccidentCause($accidentCause = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccidentCauseEnum::valueIsValid($accidentCause)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accidentCause, implode(', ', \EnumType\AccidentCauseEnum::getValidValues())), __LINE__);
        }
        $this->accidentCause = $accidentCause;
        return $this;
    }
    /**
     * Get totalNumberOfPeopleInvolved value
     * @return int|null
     */
    public function getTotalNumberOfPeopleInvolved()
    {
        return $this->totalNumberOfPeopleInvolved;
    }
    /**
     * Set totalNumberOfPeopleInvolved value
     * @param int $totalNumberOfPeopleInvolved
     * @return \StructType\Accident
     */
    public function setTotalNumberOfPeopleInvolved($totalNumberOfPeopleInvolved = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfPeopleInvolved) && !is_numeric($totalNumberOfPeopleInvolved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfPeopleInvolved)), __LINE__);
        }
        $this->totalNumberOfPeopleInvolved = $totalNumberOfPeopleInvolved;
        return $this;
    }
    /**
     * Get totalNumberOfVehiclesInvolved value
     * @return int|null
     */
    public function getTotalNumberOfVehiclesInvolved()
    {
        return $this->totalNumberOfVehiclesInvolved;
    }
    /**
     * Set totalNumberOfVehiclesInvolved value
     * @param int $totalNumberOfVehiclesInvolved
     * @return \StructType\Accident
     */
    public function setTotalNumberOfVehiclesInvolved($totalNumberOfVehiclesInvolved = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfVehiclesInvolved) && !is_numeric($totalNumberOfVehiclesInvolved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfVehiclesInvolved)), __LINE__);
        }
        $this->totalNumberOfVehiclesInvolved = $totalNumberOfVehiclesInvolved;
        return $this;
    }
    /**
     * Get vehicleInvolved value
     * @return \StructType\Vehicle[]|null
     */
    public function getVehicleInvolved()
    {
        return $this->vehicleInvolved;
    }
    /**
     * Set vehicleInvolved value
     * @throws \InvalidArgumentException
     * @param \StructType\Vehicle[] $vehicleInvolved
     * @return \StructType\Accident
     */
    public function setVehicleInvolved(array $vehicleInvolved = array())
    {
        foreach ($vehicleInvolved as $accidentVehicleInvolvedItem) {
            // validation for constraint: itemType
            if (!$accidentVehicleInvolvedItem instanceof \StructType\Vehicle) {
                throw new \InvalidArgumentException(sprintf('The vehicleInvolved property can only contain items of \StructType\Vehicle, "%s" given', is_object($accidentVehicleInvolvedItem) ? get_class($accidentVehicleInvolvedItem) : gettype($accidentVehicleInvolvedItem)), __LINE__);
            }
        }
        $this->vehicleInvolved = $vehicleInvolved;
        return $this;
    }
    /**
     * Add item to vehicleInvolved value
     * @throws \InvalidArgumentException
     * @param \StructType\Vehicle $item
     * @return \StructType\Accident
     */
    public function addToVehicleInvolved(\StructType\Vehicle $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Vehicle) {
            throw new \InvalidArgumentException(sprintf('The vehicleInvolved property can only contain items of \StructType\Vehicle, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vehicleInvolved[] = $item;
        return $this;
    }
    /**
     * Get groupOfVehiclesInvolved value
     * @return \StructType\GroupOfVehiclesInvolved[]|null
     */
    public function getGroupOfVehiclesInvolved()
    {
        return $this->groupOfVehiclesInvolved;
    }
    /**
     * Set groupOfVehiclesInvolved value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupOfVehiclesInvolved[] $groupOfVehiclesInvolved
     * @return \StructType\Accident
     */
    public function setGroupOfVehiclesInvolved(array $groupOfVehiclesInvolved = array())
    {
        foreach ($groupOfVehiclesInvolved as $accidentGroupOfVehiclesInvolvedItem) {
            // validation for constraint: itemType
            if (!$accidentGroupOfVehiclesInvolvedItem instanceof \StructType\GroupOfVehiclesInvolved) {
                throw new \InvalidArgumentException(sprintf('The groupOfVehiclesInvolved property can only contain items of \StructType\GroupOfVehiclesInvolved, "%s" given', is_object($accidentGroupOfVehiclesInvolvedItem) ? get_class($accidentGroupOfVehiclesInvolvedItem) : gettype($accidentGroupOfVehiclesInvolvedItem)), __LINE__);
            }
        }
        $this->groupOfVehiclesInvolved = $groupOfVehiclesInvolved;
        return $this;
    }
    /**
     * Add item to groupOfVehiclesInvolved value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupOfVehiclesInvolved $item
     * @return \StructType\Accident
     */
    public function addToGroupOfVehiclesInvolved(\StructType\GroupOfVehiclesInvolved $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupOfVehiclesInvolved) {
            throw new \InvalidArgumentException(sprintf('The groupOfVehiclesInvolved property can only contain items of \StructType\GroupOfVehiclesInvolved, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->groupOfVehiclesInvolved[] = $item;
        return $this;
    }
    /**
     * Get groupOfPeopleInvolved value
     * @return \StructType\GroupOfPeopleInvolved[]|null
     */
    public function getGroupOfPeopleInvolved()
    {
        return $this->groupOfPeopleInvolved;
    }
    /**
     * Set groupOfPeopleInvolved value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupOfPeopleInvolved[] $groupOfPeopleInvolved
     * @return \StructType\Accident
     */
    public function setGroupOfPeopleInvolved(array $groupOfPeopleInvolved = array())
    {
        foreach ($groupOfPeopleInvolved as $accidentGroupOfPeopleInvolvedItem) {
            // validation for constraint: itemType
            if (!$accidentGroupOfPeopleInvolvedItem instanceof \StructType\GroupOfPeopleInvolved) {
                throw new \InvalidArgumentException(sprintf('The groupOfPeopleInvolved property can only contain items of \StructType\GroupOfPeopleInvolved, "%s" given', is_object($accidentGroupOfPeopleInvolvedItem) ? get_class($accidentGroupOfPeopleInvolvedItem) : gettype($accidentGroupOfPeopleInvolvedItem)), __LINE__);
            }
        }
        $this->groupOfPeopleInvolved = $groupOfPeopleInvolved;
        return $this;
    }
    /**
     * Add item to groupOfPeopleInvolved value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupOfPeopleInvolved $item
     * @return \StructType\Accident
     */
    public function addToGroupOfPeopleInvolved(\StructType\GroupOfPeopleInvolved $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupOfPeopleInvolved) {
            throw new \InvalidArgumentException(sprintf('The groupOfPeopleInvolved property can only contain items of \StructType\GroupOfPeopleInvolved, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->groupOfPeopleInvolved[] = $item;
        return $this;
    }
    /**
     * Get accidentExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getAccidentExtension()
    {
        return $this->accidentExtension;
    }
    /**
     * Set accidentExtension value
     * @param \StructType\ExtensionType $accidentExtension
     * @return \StructType\Accident
     */
    public function setAccidentExtension(\StructType\ExtensionType $accidentExtension = null)
    {
        $this->accidentExtension = $accidentExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Accident
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
