<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessibilityNeedsFilterStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for information about Accessibility Facilities status.
 * @subpackage Structs
 */
class AccessibilityNeedsFilterStructure extends AbstractStructBase
{
    /**
     * The UserNeed
     * Meta informations extracted from the WSDL
     * - documentation: User need to be monitored.
     * - maxOccurs: unbounded
     * @var \StructType\UserNeedStructure[]
     */
    public $UserNeed;
    /**
     * Constructor method for AccessibilityNeedsFilterStructure
     * @uses AccessibilityNeedsFilterStructure::setUserNeed()
     * @param \StructType\UserNeedStructure[] $userNeed
     */
    public function __construct(array $userNeed = array())
    {
        $this
            ->setUserNeed($userNeed);
    }
    /**
     * Get UserNeed value
     * @return \StructType\UserNeedStructure[]|null
     */
    public function getUserNeed()
    {
        return $this->UserNeed;
    }
    /**
     * Set UserNeed value
     * @throws \InvalidArgumentException
     * @param \StructType\UserNeedStructure[] $userNeed
     * @return \StructType\AccessibilityNeedsFilterStructure
     */
    public function setUserNeed(array $userNeed = array())
    {
        foreach ($userNeed as $accessibilityNeedsFilterStructureUserNeedItem) {
            // validation for constraint: itemType
            if (!$accessibilityNeedsFilterStructureUserNeedItem instanceof \StructType\UserNeedStructure) {
                throw new \InvalidArgumentException(sprintf('The UserNeed property can only contain items of \StructType\UserNeedStructure, "%s" given', is_object($accessibilityNeedsFilterStructureUserNeedItem) ? get_class($accessibilityNeedsFilterStructureUserNeedItem) : gettype($accessibilityNeedsFilterStructureUserNeedItem)), __LINE__);
            }
        }
        $this->UserNeed = $userNeed;
        return $this;
    }
    /**
     * Add item to UserNeed value
     * @throws \InvalidArgumentException
     * @param \StructType\UserNeedStructure $item
     * @return \StructType\AccessibilityNeedsFilterStructure
     */
    public function addToUserNeed(\StructType\UserNeedStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserNeedStructure) {
            throw new \InvalidArgumentException(sprintf('The UserNeed property can only contain items of \StructType\UserNeedStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserNeed[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccessibilityNeedsFilterStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
