<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessibilityAssessmentStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Assesment.
 * @subpackage Structs
 */
class AccessibilityAssessmentStructure extends AbstractStructBase
{
    /**
     * The MobilityImpairedAccess
     * Meta informations extracted from the WSDL
     * - documentation: Summary indication as to whether the component is considered to be accessible or not.
     * @var bool
     */
    public $MobilityImpairedAccess;
    /**
     * The Limitations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Limitations
     */
    public $Limitations;
    /**
     * The Suitabilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Suitabilities
     */
    public $Suitabilities;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ifopt:Extensions
     * @var \StructType\Extensions
     */
    public $Extensions;
    /**
     * Constructor method for AccessibilityAssessmentStructure
     * @uses AccessibilityAssessmentStructure::setMobilityImpairedAccess()
     * @uses AccessibilityAssessmentStructure::setLimitations()
     * @uses AccessibilityAssessmentStructure::setSuitabilities()
     * @uses AccessibilityAssessmentStructure::setExtensions()
     * @param bool $mobilityImpairedAccess
     * @param \StructType\Limitations $limitations
     * @param \StructType\Suitabilities $suitabilities
     * @param \StructType\Extensions $extensions
     */
    public function __construct($mobilityImpairedAccess = null, \StructType\Limitations $limitations = null, \StructType\Suitabilities $suitabilities = null, \StructType\Extensions $extensions = null)
    {
        $this
            ->setMobilityImpairedAccess($mobilityImpairedAccess)
            ->setLimitations($limitations)
            ->setSuitabilities($suitabilities)
            ->setExtensions($extensions);
    }
    /**
     * Get MobilityImpairedAccess value
     * @return bool|null
     */
    public function getMobilityImpairedAccess()
    {
        return $this->MobilityImpairedAccess;
    }
    /**
     * Set MobilityImpairedAccess value
     * @param bool $mobilityImpairedAccess
     * @return \StructType\AccessibilityAssessmentStructure
     */
    public function setMobilityImpairedAccess($mobilityImpairedAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($mobilityImpairedAccess) && !is_bool($mobilityImpairedAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mobilityImpairedAccess)), __LINE__);
        }
        $this->MobilityImpairedAccess = $mobilityImpairedAccess;
        return $this;
    }
    /**
     * Get Limitations value
     * @return \StructType\Limitations|null
     */
    public function getLimitations()
    {
        return $this->Limitations;
    }
    /**
     * Set Limitations value
     * @param \StructType\Limitations $limitations
     * @return \StructType\AccessibilityAssessmentStructure
     */
    public function setLimitations(\StructType\Limitations $limitations = null)
    {
        $this->Limitations = $limitations;
        return $this;
    }
    /**
     * Get Suitabilities value
     * @return \StructType\Suitabilities|null
     */
    public function getSuitabilities()
    {
        return $this->Suitabilities;
    }
    /**
     * Set Suitabilities value
     * @param \StructType\Suitabilities $suitabilities
     * @return \StructType\AccessibilityAssessmentStructure
     */
    public function setSuitabilities(\StructType\Suitabilities $suitabilities = null)
    {
        $this->Suitabilities = $suitabilities;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\Extensions|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\Extensions $extensions
     * @return \StructType\AccessibilityAssessmentStructure
     */
    public function setExtensions(\StructType\Extensions $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccessibilityAssessmentStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
