<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractServiceRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Abstract Service Request for SIRI Service request. | Unique reference to request: participant and SIRI service type are given by context. Used on requests that are embedded in the context of another request. Only a message identfiier
 * may be needed.
 * @subpackage Structs
 */
abstract class AbstractServiceRequestStructure extends AbstractRequestStructure
{
    /**
     * The MessageIdentifier
     * @var \StructType\MessageQualifierStructure
     */
    public $MessageIdentifier;
    /**
     * Constructor method for AbstractServiceRequestStructure
     * @uses AbstractServiceRequestStructure::setMessageIdentifier()
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     */
    public function __construct(\StructType\MessageQualifierStructure $messageIdentifier = null)
    {
        $this
            ->setMessageIdentifier($messageIdentifier);
    }
    /**
     * Get MessageIdentifier value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getMessageIdentifier()
    {
        return $this->MessageIdentifier;
    }
    /**
     * Set MessageIdentifier value
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     * @return \StructType\AbstractServiceRequestStructure
     */
    public function setMessageIdentifier(\StructType\MessageQualifierStructure $messageIdentifier = null)
    {
        $this->MessageIdentifier = $messageIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractServiceRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
