<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for General SIRI Request.
 * @subpackage Structs
 */
abstract class AbstractRequestStructure extends AbstractStructBase
{
    /**
     * The RequestTimestamp
     * Meta informations extracted from the WSDL
     * - ref: RequestTimestamp
     * @var string
     */
    public $RequestTimestamp;
    /**
     * Constructor method for AbstractRequestStructure
     * @uses AbstractRequestStructure::setRequestTimestamp()
     * @param string $requestTimestamp
     */
    public function __construct($requestTimestamp = null)
    {
        $this
            ->setRequestTimestamp($requestTimestamp);
    }
    /**
     * Get RequestTimestamp value
     * @return string|null
     */
    public function getRequestTimestamp()
    {
        return $this->RequestTimestamp;
    }
    /**
     * Set RequestTimestamp value
     * @param string $requestTimestamp
     * @return \StructType\AbstractRequestStructure
     */
    public function setRequestTimestamp($requestTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($requestTimestamp) && !is_string($requestTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTimestamp)), __LINE__);
        }
        $this->RequestTimestamp = $requestTimestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
